/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.ftp;

import com.nokia.em.poseidon.comm.ftp.AccessRight;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class UserProfile {
    private String myUserName;
    private String myPassword;
    private String myHomeDir;
    private Collection myAccessRights;

    protected UserProfile(String userName, String password, String homeDir) {
        if (userName == null || password == null || homeDir == null) {
            throw new IllegalArgumentException("Cannot create user profile");
        }
        this.myUserName = userName;
        this.myPassword = password;
        this.myHomeDir = homeDir;
        this.myAccessRights = new ArrayList();
    }

    public AccessRight createAccessRight(String path, boolean read, boolean write) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot create access right");
        }
        AccessRight access = this.getAccessRight(path);
        if (access != null) {
            access.setRead(read);
            access.setWrite(write);
        } else {
            access = new AccessRight(path, read, write);
            this.myAccessRights.add(access);
        }
        return access;
    }

    public void deleteAccessRight(String path) {
        File requested = new File(path);
        File accessFile = null;
        Iterator iter = this.myAccessRights.iterator();
        AccessRight access = null;
        while (iter.hasNext()) {
            access = (AccessRight)iter.next();
            accessFile = new File(access.getPath());
            if (!accessFile.equals(requested)) continue;
            this.myAccessRights.remove(access);
            break;
        }
    }

    public Collection getAccessRights() {
        return new ArrayList(this.myAccessRights);
    }

    public AccessRight getAccessRight(String path) {
        Iterator iter = this.myAccessRights.iterator();
        AccessRight access = null;
        File requested = new File(path);
        File found = null;
        while (iter.hasNext()) {
            access = (AccessRight)iter.next();
            found = new File(access.getPath());
            if (!PFileUtils.isEqual(requested, found)) continue;
            return access;
        }
        return null;
    }

    public boolean canRead(String path) {
        AccessRight access2 = this.getAccessRight(path);
        if (access2 != null) {
            return access2.canRead();
        }
        for (AccessRight access2 : this.myAccessRights) {
            if (!access2.canRead() || !this.isParentDirectory(access2.getPath(), path)) continue;
            return true;
        }
        return false;
    }

    public boolean canWrite(String path) {
        AccessRight access2 = this.getAccessRight(path);
        if (access2 != null) {
            return access2.canWrite();
        }
        for (AccessRight access2 : this.myAccessRights) {
            if (!access2.canWrite() || !this.isParentDirectory(access2.getPath(), path)) continue;
            return true;
        }
        return false;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public void setHomeDir(String dir) {
        this.myHomeDir = dir;
    }

    public String getHomeDir() {
        return this.myHomeDir;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(String password) {
        this.myPassword = password;
    }

    public boolean equals(Object user) {
        boolean equals = false;
        if (user != null && user instanceof UserProfile) {
            equals = ((UserProfile)user).myUserName.equals(this.myUserName);
        }
        return equals;
    }

    public int hashCode() {
        return this.myUserName.hashCode();
    }

    private boolean isParentDirectory(String parentPath, String path) {
        return PFileUtils.isParent(new File(parentPath), new File(path));
    }
}

