/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http;

import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.widgets.ipfield.rules.IpRule;
import com.nokia.widgets.ipfield.rules.IpRuleFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;

public class Tools {
    public static final String getHTTPParameter(String header, String param) {
        String tempParam = param;
        String tempHeader = header;
        if (tempHeader.indexOf(tempParam = String.valueOf(tempParam) + ":") < 0) {
            return "";
        }
        tempHeader = String.valueOf(tempHeader) + ",";
        tempHeader = tempHeader.substring(tempHeader.indexOf(tempParam) + tempParam.length() + 1);
        if ((tempHeader = tempHeader.substring(0, tempHeader.indexOf(" "))).startsWith("\"")) {
            tempHeader = tempHeader.substring(1, tempHeader.length() - 1);
        }
        return tempHeader;
    }

    public static final String bytesToString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(bytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static final byte[] stringToBytes(String str) {
        byte[] bytes = new byte[str.length()];
        int i = 0;
        while (i < str.length()) {
            bytes[i] = (byte)(str.charAt(i) & 0xFF);
            ++i;
        }
        return bytes;
    }

    public static KeyStore loadKeyStoreFromFile(String fileName, char[] password) {
        KeyStore keyStore = null;
        try {
            URL url = PFileUtils.parseToURL(fileName);
            keyStore = KeyStore.getInstance("JKS");
            InputStream stream = url.openStream();
            keyStore.load(stream, password);
            stream.close();
        }
        catch (Exception e) {
            Logger.getLogger(Tools.class).error("KeyStore Loading Failed", e);
        }
        return keyStore;
    }

    public static SSLContext getSSLContextWithStrongestTLSVersion() throws NoSuchAlgorithmException {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException e) {
            sc = SSLContext.getInstance("TLSv1");
        }
        return sc;
    }

    public static String[] getSupportedProtocols(String[] enabledProtocols) {
        String[] systemSupportedProtocols = Tools.getSystemSupportedProtocols();
        ArrayList<String> systemSupportedProtocolsList = new ArrayList<String>(Arrays.asList(systemSupportedProtocols));
        ArrayList<String> enabledProtcolsList = new ArrayList<String>(Arrays.asList(enabledProtocols));
        enabledProtcolsList.retainAll(systemSupportedProtocolsList);
        return enabledProtcolsList.toArray(new String[enabledProtcolsList.size()]);
    }

    public static String[] getSystemSupportedProtocols() {
        SSLServerSocketFactory sslSrvFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        try {
            SSLServerSocket socket = (SSLServerSocket)sslSrvFact.createServerSocket();
            return socket.getSupportedProtocols();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public static String[] getSupportedCipherSuites(String[] enabledSet) {
        String[] systemSupportedCiphers = Tools.getSystemSupportedCipherSuites();
        ArrayList<String> systemSupportedCiphersList = new ArrayList<String>(Arrays.asList(systemSupportedCiphers));
        ArrayList<String> enabledSuitesList = new ArrayList<String>(Arrays.asList(enabledSet));
        enabledSuitesList.retainAll(systemSupportedCiphersList);
        return enabledSuitesList.toArray(new String[enabledSuitesList.size()]);
    }

    public static String[] getSystemSupportedCipherSuites() {
        SSLServerSocketFactory sslSrvFact = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        try {
            SSLServerSocket socket = (SSLServerSocket)sslSrvFact.createServerSocket();
            return socket.getSupportedCipherSuites();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public static String getSupportedCipherSuites(String enabledSuites) {
        String[] enabledSuitesArray = Tools.getSupportedCipherSuites(enabledSuites.split(","));
        String supportedEnabledSuites = "";
        int i = 0;
        while (i < enabledSuitesArray.length) {
            supportedEnabledSuites = String.valueOf(supportedEnabledSuites) + enabledSuitesArray[i] + ",";
            ++i;
        }
        return supportedEnabledSuites.length() == 0 ? "" : supportedEnabledSuites.substring(0, supportedEnabledSuites.length() - 1);
    }

    public static String getSupportedProtocols(String enabledProtocols) {
        String supportedEnabledProtocols = "";
        String[] enabledProtocolsArray = Tools.getSupportedProtocols(enabledProtocols.split(","));
        int i = 0;
        while (i < enabledProtocolsArray.length) {
            supportedEnabledProtocols = String.valueOf(supportedEnabledProtocols) + enabledProtocolsArray[i] + ",";
            ++i;
        }
        return supportedEnabledProtocols.length() == 0 ? "" : supportedEnabledProtocols.substring(0, supportedEnabledProtocols.length() - 1);
    }

    public static String getURLAsString(String protocol, String ip, int port, String uri) {
        String result = "";
        String resource = uri;
        if (!uri.startsWith("/")) {
            resource = "/" + resource;
        }
        try {
            URL url = new URL(protocol, ip, port, resource);
            result = url.toString();
        }
        catch (MalformedURLException e) {
            Logger.getLogger(Tools.class).error("Invalid URL", e);
        }
        return result;
    }

    public static String getTransferIPAddress(String ipAddressWithPort) {
        if (ipAddressWithPort.contains(":")) {
            return ipAddressWithPort.substring(0, ipAddressWithPort.lastIndexOf(":"));
        }
        return ipAddressWithPort;
    }

    public static int getTransferPort(String ipAddressWithPort, int defaultPort) {
        int port = defaultPort;
        try {
            port = Integer.parseInt(ipAddressWithPort.substring(ipAddressWithPort.lastIndexOf(":") + 1));
        }
        catch (Exception e) {
            Logger.getLogger(Tools.class).error("Failed to get port, using " + port + " by default.");
        }
        return port;
    }

    public static String appendBlanketForIPv6(String ipAddress) {
        if (Tools.isIPv6Address(ipAddress) && !ipAddress.startsWith("[")) {
            return "[" + ipAddress + "]";
        }
        return ipAddress;
    }

    public static String getIPAddressWithoutPort(String ipAddressWithPort) {
        if (Tools.isIPv6Address(ipAddressWithPort)) {
            return ipAddressWithPort.contains("]:") ? ipAddressWithPort.substring(0, ipAddressWithPort.indexOf("]:") + 1) : ipAddressWithPort;
        }
        return ipAddressWithPort.contains(":") ? ipAddressWithPort.substring(0, ipAddressWithPort.indexOf(":")) : ipAddressWithPort;
    }

    private static boolean isIPv6Address(String address) {
        int count = 0;
        char[] cArray = address.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ':') {
                ++count;
            }
            ++n2;
        }
        return count > 1;
    }

    public static boolean testAgainstRules(String address, List<IpRule> rules) {
        for (IpRule rule : rules) {
            if (!rule.matches(address)) continue;
            return true;
        }
        return false;
    }

    public static byte[] getBytes(String address) {
        StringTokenizer token = new StringTokenizer(address, ".");
        byte[] bytes = new byte[token.countTokens()];
        int i = 0;
        while (token.hasMoreTokens()) {
            bytes[i++] = (byte)Integer.parseInt(token.nextToken());
        }
        return bytes;
    }

    public static boolean isIpv4Address(String address) {
        return address != null && Tools.testAgainstRules(address, IpRuleFactory.getIpv4Rules());
    }

    public static boolean isIpv6Address(String address) {
        return address != null && !Tools.isIpv4Address(address) && Tools.testAgainstRules(address, IpRuleFactory.getHybridRules());
    }

    public static boolean isIpv6WithPort(String address) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]:(.*)");
        Matcher matcher = pattern.matcher(address);
        if (matcher.find()) {
            String ipport = matcher.group(0);
            String ip = matcher.group(1);
            String port = matcher.group(2);
            return ipport.equals(address) && Tools.isIpv6Address(ip) && Tools.isValidPort(port);
        }
        return false;
    }

    public static boolean isValidPort(String port) {
        return port != null && port.length() > 0 && TextUtils.isInteger(port) && port.charAt(0) != '-';
    }

    public static String[] splitIPAndPort(String address) {
        String ipAddress = null;
        String ipPort = null;
        if (address != null) {
            int colon = -1;
            boolean isIPV6WithPort = Tools.isIpv6WithPort(address);
            if (isIPV6WithPort || !Tools.isIpv6Address(address)) {
                colon = address.lastIndexOf(58);
            }
            if (colon != -1) {
                ipAddress = address.substring(isIPV6WithPort ? 1 : 0, isIPV6WithPort ? colon - 1 : colon);
                ipPort = address.substring(colon + 1);
            } else {
                ipAddress = address;
            }
        }
        return new String[]{ipAddress, ipPort};
    }

    public static boolean isDnsName(String address) {
        return address != null && !Tools.isIpv4Address(address) && !Tools.isIpv6Address(address);
    }

    public static InetSocketAddress createInetSocketAddress(String address, int port) throws UnknownHostException {
        if (Tools.isDnsName(address)) {
            return new InetSocketAddress(address, port);
        }
        if (Tools.isIpv4Address(address) || Tools.isIpv6Address(address)) {
            return new InetSocketAddress(InetAddress.getByAddress(address, Tools.getBytes(address)), port);
        }
        throw new UnknownHostException("Given address (" + address + ") is not DNS name, IPv4 address, IPv6 address or given IP address is illegal length.");
    }
}

