/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.client;

import com.nokia.em.poseidon.comm.http.Tools;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class DefaultTrustManager
implements X509TrustManager {
    private Logger myLogger = Logger.getLogger(this.getClass());
    private KeyStore myKeyStore;
    private X509TrustManager myDefaultTrustManager;
    private String myTrustStoreFile;
    private char[] myTrustStorePassword;

    public DefaultTrustManager(String trustStoreFile, char[] trustStorePassword) {
        this.myTrustStoreFile = trustStoreFile;
        this.myTrustStorePassword = trustStorePassword;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.myKeyStore == null) {
            this.initKeyStore();
        }
        if (this.myDefaultTrustManager == null) {
            this.initTrustManager();
        }
        try {
            this.myDefaultTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certE) {
            this.myLogger.debug("Connection attempted with invalid certificates. ", certE);
            throw certE;
        }
        catch (Exception e) {
            this.myLogger.error("Exception in connection attempt.", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        try {
            if (this.myKeyStore == null) {
                this.initKeyStore();
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            Enumeration<String> alias = this.myKeyStore.aliases();
            while (alias.hasMoreElements()) {
                certs.add((X509Certificate)this.myKeyStore.getCertificate(alias.nextElement()));
            }
            X509Certificate[] certArray = new X509Certificate[certs.size()];
            return certs.toArray(certArray);
        }
        catch (Exception e) {
            this.myLogger.error(e);
            return new X509Certificate[0];
        }
    }

    private void initKeyStore() {
        try {
            this.myKeyStore = Tools.loadKeyStoreFromFile(this.myTrustStoreFile, this.myTrustStorePassword);
        }
        catch (Exception e) {
            this.myLogger.error("Keystore initialization failed.", e);
        }
    }

    public void initTrustManager() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
            if (this.myKeyStore == null) {
                this.initKeyStore();
            }
            factory.init(this.myKeyStore);
            this.myDefaultTrustManager = (X509TrustManager)factory.getTrustManagers()[0];
        }
        catch (Exception e) {
            this.myLogger.error("Trust manager initialization failed.", e);
        }
    }
}

