/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.client;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.comm.http.client.DefaultTrustManager;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileOutputStream;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import com.nokia.em.poseidon.util.security.Base64;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class HttpClient {
    private static final String FS = System.getProperty("file.separator");
    private static final int CONNECTION_RETRY_ATTEMPTS = 10;
    private static final int CONNECTION_RETRY_INTERVAL = 2000;
    private int mySocketTimeOut = 30000;
    protected String myHost;
    protected int myPort = 80;
    protected String myLocalFileName;
    private String myUsername;
    private String myPassword;
    private HttpConstants.Authentication myAuthentication = HttpConstants.Authentication.AUTHENTICATION_OFF;
    private Set<TransferListener> myListeners;
    private boolean myUseSecure = false;
    private X509TrustManager myTrustManager;
    private String[] myEnabledCipherSuites;
    private Object myTempStoredSystemCiphersSuites;
    protected Logger myLogger;
    private boolean myUseClientMode = true;
    private String myTrustStoreFile = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
    private String myClientKeyStoreFile = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
    private char[] myClientKeyStorePassword = HttpConstants.DEFAULT_KEYSTORE_PASSWORD;
    private char[] myTrustStorePassword = HttpConstants.DEFAULT_KEYSTORE_PASSWORD;
    private HttpConstants.Protocol myProtocol = HttpConstants.Protocol.TLS;
    private String myDirectory = String.valueOf(System.getProperty("java.io.tmpdir")) + FS;
    private boolean myEncodeFileName = true;
    private Map<String, FileFetcher> myFileNameToFetcher;
    private ProgressTimerListener myProgressListener;
    private long myGetBytes;
    private TimerService myTimerService;
    private long myRequestedFileLength;
    private boolean myPrintStack = true;

    public void setPrintStack(boolean on) {
        this.myPrintStack = on;
    }

    public HttpClient(String host, int port) {
        this.myPort = port;
        this.myHost = host.toLowerCase();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myListeners = new CopyOnWriteArraySet<TransferListener>();
        this.myFileNameToFetcher = new ConcurrentHashMap<String, FileFetcher>();
        this.myTimerService = TimerService.getInstance();
        this.myProgressListener = new ProgressTimerListener();
    }

    public void addFileTransferListener(TransferListener listener) {
        this.myListeners.add(listener);
    }

    public void removeFileTransferListener(TransferListener listener) {
        this.myListeners.remove(listener);
    }

    public Set<TransferListener> getFileTransferListeners() {
        return this.myListeners;
    }

    public void setAuthentication(HttpConstants.Authentication authentication) {
        this.myAuthentication = authentication;
    }

    public HttpConstants.Authentication getAuthetication() {
        return this.myAuthentication;
    }

    public void setUserName(String user) {
        this.myUsername = user;
    }

    public void setClientDirectory(String dir) {
        this.myDirectory = dir.lastIndexOf(FS) == dir.length() - 1 ? dir : String.valueOf(dir) + FS;
    }

    public String getClientDirectory() {
        return this.myDirectory;
    }

    public void setUsedProtocol(HttpConstants.Protocol protocol) {
        this.myProtocol = protocol;
    }

    public HttpConstants.Protocol getUsedProtocol() {
        return this.myProtocol;
    }

    public void setPassword(String pass) {
        this.myPassword = pass;
    }

    public void setSecure(boolean secure) {
        this.myUseSecure = secure;
    }

    public boolean getUseSecure() {
        return this.myUseSecure;
    }

    public void setUseUrlEncoding(boolean encode) {
        this.myEncodeFileName = encode;
    }

    public boolean getUseUrlEncoding() {
        return this.myEncodeFileName;
    }

    public void setUseClientMode(boolean clientMode) {
        this.myUseClientMode = clientMode;
    }

    public boolean getUseClientMode() {
        return this.myUseClientMode;
    }

    public void setSocketTimeOut(int timeOut) {
        this.mySocketTimeOut = timeOut * 1000;
    }

    public int getSocketTimeOut() {
        return this.mySocketTimeOut;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.myEnabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledCipherSuites() {
        return this.myEnabledCipherSuites;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.myTrustStoreFile = keyStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.myTrustStoreFile = trustStoreFile;
    }

    public void setKeyStorePassword(char[] password) {
        this.myTrustStorePassword = password;
    }

    public void setTrustStorePassword(char[] password) {
        this.myTrustStorePassword = password;
    }

    public void setClientKeyStoreFile(String clientKeyStoreFile) {
        this.myClientKeyStoreFile = clientKeyStoreFile;
    }

    public void setClientKeyStorePassword(char[] password) {
        this.myClientKeyStorePassword = password;
    }

    public String getUserName() {
        return this.myUsername;
    }

    public void setTrustManager(X509TrustManager trustManager) {
        this.myTrustManager = trustManager;
    }

    public X509TrustManager getTrustManager() {
        return this.myTrustManager;
    }

    public void getFile(String serverFileName, String localFileName) {
        this.myLocalFileName = localFileName;
        this.getFile(serverFileName);
    }

    public void getFile(final String serverFileName) {
        Thread t = new Thread("Thread " + this){

            @Override
            public void run() {
                HttpClient.this.doGetFile(serverFileName);
            }
        };
        t.start();
    }

    public File getFileSynchronously(String serverFileName, String localFileName) {
        this.myLocalFileName = localFileName;
        return this.doGetFile(serverFileName);
    }

    public File getFileSynchronously(String serverFileName) {
        return this.doGetFile(serverFileName);
    }

    public void getByteArray(final String serverFileName) {
        Thread t = new Thread("Thread " + this){

            @Override
            public void run() {
                HttpClient.this.getByteArraySynchronously(serverFileName);
            }
        };
        t.start();
    }

    public byte[] getByteArraySynchronously(String serverFileName) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        if (!this.doGet(serverFileName, bao, bao)) {
            return null;
        }
        return bao.toByteArray();
    }

    public void cancel() {
        for (FileFetcher ff : this.myFileNameToFetcher.values()) {
            ff.cancel();
        }
    }

    public void cancel(String serverFileName) {
        FileFetcher ff = this.myFileNameToFetcher.get(serverFileName);
        if (ff != null) {
            ff.cancel();
        }
    }

    protected File doGetFile(String serverFileName) {
        File transferredFile = null;
        boolean tmpFileCreated = false;
        File tmpFile = null;
        try {
            if (this.myLocalFileName == null) {
                tmpFileCreated = true;
                tmpFile = File.createTempFile("tmp", null);
                tmpFile.deleteOnExit();
                this.myLocalFileName = tmpFile.getName();
            }
            if (tmpFileCreated) {
                transferredFile = tmpFile;
            } else {
                int index = this.myLocalFileName.lastIndexOf(FS);
                transferredFile = new File(String.valueOf(this.myDirectory) + (index < 0 ? this.myLocalFileName : this.myLocalFileName.substring(index)));
            }
            PFileOutputStream fileOutPutStream = new PFileOutputStream(transferredFile);
            if (!this.doGet(serverFileName, fileOutPutStream, transferredFile)) {
                IOUtils.deleteFile(transferredFile);
                transferredFile = null;
            }
        }
        catch (Exception e) {
            TransferInfo failedTransferInfo = new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, transferredFile, this.myUsername, null, e.getMessage());
            failedTransferInfo.setErrorData(e);
            this.notifyListeners(failedTransferInfo);
            this.myLogger.error("HTTP client failed local file operation for transfer", e);
        }
        return transferredFile;
    }

    protected boolean doGet(String serverFileName, OutputStream target, Object transferTarget) {
        FileFetcher ff = new FileFetcher();
        this.myFileNameToFetcher.put(serverFileName, ff);
        boolean returnValue = ff.get(serverFileName, target, transferTarget);
        this.myFileNameToFetcher.remove(serverFileName);
        return returnValue;
    }

    protected HttpURLConnection createUrlConnection(String serverFile) throws IOException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException {
        String encodedFilePath = this.myEncodeFileName ? TextUtils.encodeHTML(serverFile) : serverFile;
        HttpURLConnection myConnection = null;
        if (!this.myUseSecure) {
            URL elementAddress = this.getURL("http", encodedFilePath);
            myConnection = (HttpURLConnection)elementAddress.openConnection();
            this.myLogger.debug("HTTP client connecting to: " + elementAddress.toString());
        } else {
            URL elementAddress = this.getURL("https", encodedFilePath);
            this.myLogger.debug("HTTP client connecting to: " + elementAddress.toString());
            SSLContext sslctx = this.getSSLContext();
            if (this.myTrustManager == null) {
                this.myTrustManager = new DefaultTrustManager(this.myTrustStoreFile, this.myTrustStorePassword);
            }
            this.configureEnabledCipherSuites();
            KeyManager[] keyManagers = null;
            if (!this.myUseClientMode) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(Tools.loadKeyStoreFromFile(this.myClientKeyStoreFile, this.myClientKeyStorePassword), this.myClientKeyStorePassword);
                keyManagers = keyManagerFactory.getKeyManagers();
            }
            sslctx.init(keyManagers, new X509TrustManager[]{this.myTrustManager}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslctx.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostname, SSLSession session) {
                    return true;
                }
            });
            myConnection = (HttpsURLConnection)elementAddress.openConnection();
        }
        return myConnection;
    }

    protected URL getURL(String protocol, String encodedFilePath) throws MalformedURLException {
        String host = this.removeHttpStarter(protocol);
        URL elementAddress = new URL(protocol, host, this.myPort, encodedFilePath);
        return elementAddress;
    }

    private String removeHttpStarter(String protocol) {
        String host = this.myHost;
        String httpStarter = String.valueOf(protocol) + "://";
        if (this.myHost.startsWith(httpStarter)) {
            host = this.myHost.replace(httpStarter, "");
        }
        return host;
    }

    private SSLContext getSSLContext() throws NoSuchAlgorithmException {
        SSLContext sc = null;
        sc = this.myProtocol.equals((Object)HttpConstants.Protocol.SSL) ? SSLContext.getInstance("SSL") : Tools.getSSLContextWithStrongestTLSVersion();
        return sc;
    }

    protected void configureEnabledCipherSuites() {
        if (this.myEnabledCipherSuites != null && this.myEnabledCipherSuites.length > 0) {
            this.myTempStoredSystemCiphersSuites = System.getProperty("https.cipherSuites");
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < this.myEnabledCipherSuites.length) {
                builder.append(String.valueOf(this.myEnabledCipherSuites[i]) + ",");
                ++i;
            }
            String temp = builder.substring(0, builder.length() - 1);
            System.setProperty("https.cipherSuites", temp);
        }
    }

    protected void initializeConnection(HttpURLConnection connection) throws ProtocolException {
        connection.setConnectTimeout(this.mySocketTimeOut);
        connection.setReadTimeout(this.mySocketTimeOut);
        connection.setRequestMethod("GET");
        if (!this.myAuthentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_OFF)) {
            connection.setRequestProperty("Authorization", String.valueOf(this.getAuthenticationText()) + " " + Base64.encodeToString(String.valueOf(this.myUsername) + ":" + this.myPassword, false));
        }
        if (this.myAuthentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_DIGEST)) {
            connection.setRequestProperty("response", Base64.encodeToString(String.valueOf(this.myUsername) + ":" + this.myPassword, false));
        }
    }

    protected String getAuthenticationText() {
        if (this.myAuthentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_BASIC)) {
            return "Basic";
        }
        if (this.myAuthentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_DIGEST)) {
            return "Digest";
        }
        return "";
    }

    protected void notifyListeners(TransferInfo info) {
        for (TransferListener listener : this.myListeners) {
            try {
                listener.transferUpdated(info);
            }
            catch (Exception e) {
                this.myLogger.error("Http client listener " + listener + " thrown exception ", e);
            }
        }
    }

    private void startProgressTimer() {
        if (this.myProgressListener != null) {
            this.myTimerService.startTimer(System.currentTimeMillis(), this.myProgressListener, 1000L, false, 0, true);
        }
    }

    private void stopProgressTimer() {
        if (this.myProgressListener != null) {
            this.myTimerService.stopTimer(this.myProgressListener);
        }
    }

    private class FileFetcher {
        private HttpURLConnection myConnection = null;
        private InputStream myIn = null;
        private BufferedOutputStream myOut = null;
        private OutputStream myTarget = null;
        private boolean myCancelled;
        private String myServerFileName;

        private FileFetcher() {
        }

        public void cancel() {
            this.myCancelled = true;
            this.closeAll();
            this.restoreSystemCipherSuites();
            HttpClient.this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_CANCELLED, null, HttpClient.this.myUsername));
            HttpClient.this.myLogger.debug("Cancelled file transfer with server filename: " + this.myServerFileName);
        }

        public boolean get(String serverFileName, OutputStream target, Object transferTarget) {
            boolean success;
            block12: {
                success = true;
                this.myServerFileName = serverFileName;
                this.myTarget = target;
                try {
                    try {
                        String fileSeparator = serverFileName.indexOf("/") == 0 ? "" : "/";
                        this.myConnection = HttpClient.this.createUrlConnection(String.valueOf(fileSeparator) + serverFileName);
                        HttpClient.this.initializeConnection(this.myConnection);
                        this.createConnection();
                        success = this.handleResponseCode(this.myConnection.getResponseCode(), this.refreshTarget(transferTarget));
                        if (success) {
                            int c;
                            this.myIn = this.myConnection.getInputStream();
                            this.myOut = new BufferedOutputStream(target);
                            HttpClient.this.myRequestedFileLength = this.myConnection.getContentLength();
                            this.checkDiskSpace(serverFileName);
                            HttpClient.this.startProgressTimer();
                            HttpClient.this.myGetBytes = 0L;
                            while ((c = this.myIn.read()) >= 0 && !this.myCancelled) {
                                this.myOut.write(c);
                                HttpClient httpClient = HttpClient.this;
                                httpClient.myGetBytes = httpClient.myGetBytes + 1L;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!this.myCancelled) {
                            TransferInfo failedTransferInfo = new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, this.refreshTarget(transferTarget), HttpClient.this.myUsername, null, e.getMessage());
                            failedTransferInfo.setErrorData(e);
                            HttpClient.this.notifyListeners(failedTransferInfo);
                            if (HttpClient.this.myPrintStack) {
                                HttpClient.this.myLogger.error("HTTP client failed to connect to " + HttpClient.this.myHost + ":" + HttpClient.this.myPort, e);
                            } else {
                                HttpClient.this.myLogger.error("HTTP client failed to connect to " + HttpClient.this.myHost + ":" + HttpClient.this.myPort);
                            }
                        }
                        success = false;
                        HttpClient.this.stopProgressTimer();
                        this.closeAll();
                        this.restoreSystemCipherSuites();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    HttpClient.this.stopProgressTimer();
                    this.closeAll();
                    this.restoreSystemCipherSuites();
                    throw throwable;
                }
                HttpClient.this.stopProgressTimer();
                this.closeAll();
                this.restoreSystemCipherSuites();
            }
            if (success && !this.myCancelled) {
                HttpClient.this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_COMPLETED, this.refreshTarget(transferTarget), HttpClient.this.myUsername));
                HttpClient.this.myLogger.debug("HTTP data fetched from " + HttpClient.this.myHost);
                if (transferTarget instanceof File) {
                    HttpClient.this.myLogger.debug("Server file: " + serverFileName + ", transfer target: " + transferTarget.toString() + ", file size: " + ((File)transferTarget).length() + " bytes.");
                }
            }
            return success && !this.myCancelled;
        }

        private void checkDiskSpace(String transferFileName) throws DiskSpaceException {
            if (this.myTarget instanceof PFileOutputStream) {
                File target = ((PFileOutputStream)this.myTarget).getDestinationFile();
                String serverFile = String.valueOf(HttpClient.this.myHost) + ":" + HttpClient.this.myPort + "/" + transferFileName;
                DiskSpaceChecker.checkDiskSpaceException(target, serverFile, HttpClient.this.myRequestedFileLength);
            }
        }

        private void restoreSystemCipherSuites() {
            if (HttpClient.this.myEnabledCipherSuites != null && HttpClient.this.myEnabledCipherSuites.length > 0 && HttpClient.this.myTempStoredSystemCiphersSuites != null) {
                System.setProperty("https.cipherSuites", HttpClient.this.myTempStoredSystemCiphersSuites.toString());
            }
        }

        private void createConnection() throws Exception {
            int i = 0;
            while (i < 10) {
                try {
                    this.myConnection.connect();
                    break;
                }
                catch (SocketException e) {
                    if (e.getMessage() != null && e.getMessage().contains("No buffer space available") && i < 9) {
                        HttpClient.this.myLogger.debug("No buffer space available exception thrown. Try reconnection after 2000 milliseconds.");
                        Thread.sleep(2000L);
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
                ++i;
            }
        }

        private Object refreshTarget(Object target) {
            if (target instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)target).toByteArray();
            }
            return target;
        }

        private boolean handleResponseCode(int code, Object transferTarget) {
            boolean returnValue;
            TransferInfo.TransferStatus status = TransferInfo.TransferStatus.TRANSFER_ERROR;
            String message = null;
            switch (code) {
                case 200: {
                    status = TransferInfo.TransferStatus.TRANSFER_INITIALIZING;
                    message = "HTTP URL connection OK";
                    returnValue = true;
                    HttpClient.this.myLogger.debug("HTTP Server accepted request. Response code: " + code);
                    break;
                }
                case 401: {
                    message = "HTTP URL connection: unauthorized";
                    returnValue = false;
                    HttpClient.this.myLogger.error("Client request was unauthorized. Response code: " + code);
                    break;
                }
                case 404: {
                    message = "HTTP URL connection: not found";
                    returnValue = false;
                    HttpClient.this.myLogger.error("HTTP Server doesn't have requested file. Response code: " + code);
                    break;
                }
                case 500: {
                    message = "HTTP URL connection: internal error";
                    returnValue = false;
                    HttpClient.this.myLogger.error("Internal error in the HTTP Server. Response code: " + code);
                    break;
                }
                case 403: {
                    message = "HTTP URL connection: forbidden";
                    returnValue = false;
                    HttpClient.this.myLogger.error("HTTP client was denied to connect to " + HttpClient.this.myHost + " Response code: " + code);
                    break;
                }
                case 400: {
                    message = "HTTP URL connection: bad request";
                    returnValue = false;
                    HttpClient.this.myLogger.error("Bad request response get from " + HttpClient.this.myHost + " Response code: " + code);
                    break;
                }
                default: {
                    message = "HTTP URL connection: unrecognized response code";
                    returnValue = false;
                    HttpClient.this.myLogger.error("Received a unrecognized response code: " + code);
                }
            }
            HttpClient.this.notifyListeners(new TransferInfo(-1L, -1.0, status, transferTarget, HttpClient.this.myUsername, code, message));
            return returnValue;
        }

        private void closeAll() {
            try {
                if (this.myIn != null) {
                    this.myIn.close();
                }
            }
            catch (IOException e) {
                HttpClient.this.myLogger.error("Failed to close the HTTPClient input stream." + e);
            }
            try {
                if (this.myOut != null) {
                    this.myOut.close();
                }
            }
            catch (IOException e) {
                HttpClient.this.myLogger.error("Failed to close the HTTPClient output stream." + e);
            }
            try {
                if (this.myTarget != null) {
                    this.myTarget.close();
                }
            }
            catch (IOException e) {
                HttpClient.this.myLogger.error("Failed to close the HTTPClient target output stream." + e);
            }
            if (this.myConnection != null) {
                this.myConnection.disconnect();
            }
        }
    }

    private class ProgressTimerListener
    implements ActionListener {
        private ProgressTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            HttpClient.this.notifyListeners(new TransferInfo(HttpClient.this.myRequestedFileLength, HttpClient.this.myGetBytes * 100L / HttpClient.this.myRequestedFileLength, TransferInfo.TransferStatus.TRANSFER_ONGOING, null, null));
        }
    }
}

