/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.http.server.Handler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public abstract class AbstractHandler
extends Thread
implements Handler,
Cloneable {
    protected String myName;
    protected Logger myLogger;
    protected Socket mySocket;
    protected BufferedReader myInputStream = null;
    protected BufferedOutputStream myOutputStream = null;
    protected Set<TransferListener> myListeners = new CopyOnWriteArraySet<TransferListener>();
    protected int myResponseCode;

    @Override
    public String getHandlerName() {
        return this.myName;
    }

    @Override
    public boolean handle(Socket socket) {
        this.mySocket = socket;
        try {
            this.myInputStream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            this.myOutputStream = new BufferedOutputStream(socket.getOutputStream());
            this.run();
        }
        catch (IOException e) {
            this.myLogger.error(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean initialize(String handlerName) {
        this.myName = handlerName;
        return true;
    }

    @Override
    public void addFileTransferListener(TransferListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeFileTransferListener(TransferListener listener) {
        this.myListeners.remove(listener);
    }

    protected String receive() {
        this.myLogger.debug("Received HTTP message. ");
        StringBuffer sb = new StringBuffer();
        try {
            String s = "";
            while (!"".equalsIgnoreCase((s = this.myInputStream.readLine()) == null ? "" : s)) {
                sb.append(s).append("\n");
            }
            this.myLogger.trace("Received HTTP message: " + this.parseHTTPMessage(sb.toString()));
            return sb.toString();
        }
        catch (Exception e) {
            this.myLogger.error("Failed to receive HTTP message: ", e);
            return "";
        }
    }

    protected void readInputStream() {
        this.myLogger.debug("keep reading input stream.");
        Thread receiverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        AbstractHandler.this.myInputStream.readLine();
                    }
                }
                catch (Exception e) {
                    AbstractHandler.this.myLogger.debug("Failed to receive input stream, " + e.getMessage());
                    return;
                }
            }
        });
        receiverThread.start();
    }

    protected void notifyListeners(TransferInfo info) {
        for (TransferListener listener : this.myListeners) {
            try {
                listener.transferUpdated(info);
            }
            catch (Exception e) {
                this.myLogger.error("HTTP server listener " + listener + " thrown exception ", e);
            }
        }
    }

    protected String parseHTTPMessage(String message) {
        try {
            return message.substring(0, message.indexOf("Authorization"));
        }
        catch (IndexOutOfBoundsException e) {
            return message;
        }
    }

    @Override
    public Handler clone() {
        try {
            AbstractHandler handler = (AbstractHandler)this.getClass().newInstance();
            handler.myListeners = new CopyOnWriteArraySet<TransferListener>(this.myListeners);
            return handler;
        }
        catch (InstantiationException e) {
            this.myLogger.error("AbstractHandler cloning failed. " + e);
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            this.myLogger.error("AbstractHandler cloning failed. " + e);
            throw new AssertionError((Object)e);
        }
    }
}

