/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.comm.http.server.FileHandler;
import com.nokia.em.poseidon.util.security.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class AuthFileHandler
extends FileHandler {
    protected String myCurrentClientName = "";
    private Map<String, String> myUserNamesToPasswords = new HashMap<String, String>();
    private Map<String, ValidityTimer> myUserNamesValidityTimes = new HashMap<String, ValidityTimer>();

    @Override
    protected void processHTTPMessage(String message) {
        String tempMessage = message;
        if (tempMessage != null && !"".equalsIgnoreCase(tempMessage)) {
            tempMessage = tempMessage.replaceAll("\r", "").replaceAll("\n", " ").trim();
            this.myLogger.trace("Received " + this.parseHTTPMessage(tempMessage));
            this.checkRequestType(tempMessage);
        } else {
            this.myLogger.error("The client request to the server used improper syntax. Send HTTP Bad Request 400: Bad Request.");
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, null, null, 400, "HTTP not implemented"));
            this.send(this.createResponse("HTTP/1.1 400 Bad Request"));
        }
    }

    private void checkRequestType(String message) {
        if (message.startsWith("GET") || message.startsWith("HEAD")) {
            boolean head = message.startsWith("HEAD");
            if (message.startsWith("GET") || this.myAuthentication != HttpConstants.Authentication.AUTHENTICATION_OFF) {
                this.checkAuthentication(message);
            } else {
                this.sendFile(head, message.substring(5, message.indexOf("HTTP/1.1")).trim());
            }
        } else {
            this.myLogger.error("The server does not have the feature that is needed to fulfill this request. Send HTTP Status-Code 501: Not Implemented.");
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, null, null, 501, "HTTP not implemented"));
            this.send(this.createResponse("HTTP/1.1 501 Not Implemented"));
        }
    }

    private void checkAuthentication(String message) {
        if (message.indexOf("Authorization") < 0 && message.indexOf("Authorization".toLowerCase()) < 0) {
            String s = this.createUnauthorizedResponse();
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, null, null, 401, "HTTP URL connection unauthorized"));
            this.send(s);
            this.myLogger.debug("Sent " + s);
        } else {
            String response = Tools.getHTTPParameter(message, "response");
            List<String> digest = this.getDigest(message);
            if (this.myAuthentication == HttpConstants.Authentication.AUTHENTICATION_BASIC) {
                response = message.indexOf("Authorization") > 0 ? message.substring(message.indexOf("Authorization: Basic") + 21).trim() : message.substring(message.indexOf("authorization: Basic") + 21).trim();
                if (response.indexOf(" ") > 0) {
                    response = response.substring(0, response.indexOf(" "));
                }
                String decoded = Base64.decodeToString(response);
                this.myCurrentClientName = decoded.substring(0, decoded.indexOf(":"));
            }
            if (digest.contains(response)) {
                super.processHTTPMessage(message);
            } else {
                String s = this.createUnauthorizedResponse();
                this.myLogger.error("HTTP authentication failed, " + response + " doesn't match " + digest);
                this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, null, null, 401, "HTTP URL connection unauthorized"));
                this.send(s);
                this.myLogger.debug("Sent " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDigest(String message) {
        String digest = null;
        ArrayList<String> digests = new ArrayList<String>();
        if (this.myAuthentication == HttpConstants.Authentication.AUTHENTICATION_DIGEST) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                Map<String, String> map = this.myUserNamesToPasswords;
                synchronized (map) {
                    for (String userName : this.myUserNamesToPasswords.keySet()) {
                        digest = Tools.bytesToString(messageDigest.digest(Tools.stringToBytes(String.valueOf(Tools.bytesToString(messageDigest.digest(Tools.stringToBytes(String.valueOf(userName) + ":" + Tools.getHTTPParameter(message, "realm") + ":" + this.myUserNamesToPasswords.get(userName).toString())))) + ":" + Tools.getHTTPParameter(message, "nonce") + ":" + Tools.getHTTPParameter(message, "nc") + ":" + Tools.getHTTPParameter(message, "cnonce") + ":" + Tools.getHTTPParameter(message, "qop") + ":" + Tools.bytesToString(messageDigest.digest(Tools.stringToBytes("GET:" + Tools.getHTTPParameter(message, "uri")))))));
                        digests.add(digest);
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                this.myLogger.error(e);
            }
        } else {
            Map<String, String> map = this.myUserNamesToPasswords;
            synchronized (map) {
                for (String userName : this.myUserNamesToPasswords.keySet()) {
                    digests.add(Base64.encodeToString(String.valueOf(userName) + ":" + this.myUserNamesToPasswords.get(userName).toString(), false));
                }
            }
        }
        return digests;
    }

    private String createUnauthorizedResponse() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP/1.1 401 Unauthorized");
        builder.append("\r\n");
        builder.append("Connection:");
        builder.append(" Keep-Alive");
        builder.append("\r\n");
        builder.append("Content-Type:");
        builder.append(" ");
        builder.append("text/html");
        builder.append("\r\n");
        builder.append("Server:");
        builder.append("\"Poseidon\"");
        builder.append("\r\n");
        if (this.myAuthentication == HttpConstants.Authentication.AUTHENTICATION_DIGEST) {
            String nonce = String.valueOf(String.valueOf(this.hashCode())) + String.valueOf(System.currentTimeMillis());
            builder.append("WWW-Authenticate:");
            builder.append(" ");
            builder.append("Digest");
            builder.append("\r\n");
            builder.append("realm");
            builder.append("=");
            builder.append("\"Poseidon\"");
            builder.append(",");
            builder.append("\r\n");
            builder.append("domain=");
            builder.append("\"/PoseidonHTTP\"");
            builder.append(",");
            builder.append("\r\n");
            builder.append("nonce");
            builder.append("=");
            builder.append("\"");
            builder.append(nonce);
            builder.append("\",");
            builder.append("\r\n");
            builder.append("algorithm=");
            builder.append("\"");
            builder.append("MD5");
            builder.append("\",");
            builder.append("\r\n");
            builder.append("qop");
            builder.append("=\"auth, auth-int\"");
        } else if (this.myAuthentication == HttpConstants.Authentication.AUTHENTICATION_BASIC) {
            builder.append("WWW-Authenticate:");
            builder.append(" ");
            builder.append("Basic");
            builder.append("\r\n");
            builder.append("realm");
            builder.append("=");
            builder.append("\"Poseidon\"");
        }
        return builder.toString();
    }

    public void setAuthentication(HttpConstants.Authentication authentication) {
        this.myAuthentication = authentication;
    }

    public HttpConstants.Authentication getAuthentication() {
        return this.myAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String userName, String password) {
        Map<String, String> map = this.myUserNamesToPasswords;
        synchronized (map) {
            this.myUserNamesToPasswords.put(userName, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String userName) {
        Map<String, String> map = this.myUserNamesToPasswords;
        synchronized (map) {
            if (this.myUserNamesValidityTimes.containsKey(userName)) {
                this.myUserNamesValidityTimes.get(userName).cancel();
                this.myUserNamesValidityTimes.remove(userName);
            }
            this.myUserNamesToPasswords.remove(userName);
        }
    }

    public void setUserNameValidityTime(String userName, int validityTime) {
        if (validityTime > 0) {
            ValidityTimer timer = new ValidityTimer();
            timer.initTimer(userName, validityTime);
        } else if (this.myUserNamesValidityTimes.containsKey(userName)) {
            this.myUserNamesValidityTimes.get(userName).cancel();
            this.myUserNamesValidityTimes.remove(userName);
        }
    }

    @Override
    public boolean shutdown() {
        for (ValidityTimer timer : this.myUserNamesValidityTimes.values()) {
            timer.cancel();
        }
        this.myUserNamesToPasswords.clear();
        this.myUserNamesValidityTimes.clear();
        return super.shutdown();
    }

    @Override
    protected void notifyListeners(TransferInfo info) {
        if (info.getFile() == null || info.getUserName() == null || "".equals(info.getUserName())) {
            TransferInfo newInfo = new TransferInfo(info.getContentLength(), info.getTransferPercentage(), info.getTransferStatus(), this.myRequestedFile, this.myCurrentClientName, info.getProtocolResponseCode(), info.getInfoMessage());
            super.notifyListeners(newInfo);
        } else {
            super.notifyListeners(info);
        }
    }

    @Override
    public AuthFileHandler clone() {
        AuthFileHandler newObject = (AuthFileHandler)super.clone();
        newObject.myUserNamesToPasswords = new HashMap<String, String>(this.myUserNamesToPasswords);
        newObject.myUserNamesValidityTimes = new HashMap<String, ValidityTimer>(this.myUserNamesValidityTimes);
        return newObject;
    }

    private class ValidityTimer
    extends Timer {
        private String myUser = "";
        private int myAccountValidityTime = -1;

        private ValidityTimer() {
        }

        private void initTimer(String userName, int validityTime) {
            this.myUser = userName;
            this.myAccountValidityTime = validityTime;
            AuthFileHandler.this.myUserNamesValidityTimes.put(this.myUser, this);
            this.schedule(new TimerTask(){

                @Override
                public void run() {
                    AuthFileHandler.this.myUserNamesToPasswords.remove(ValidityTimer.this.myUser);
                }
            }, this.myAccountValidityTime * 1000);
        }
    }
}

