/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.server.AbstractHandler;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class FileHandler
extends AbstractHandler {
    protected static final String FS = System.getProperty("file.separator");
    protected static final String ROW_CHANGE = "\r\n";
    protected static final String FILE_TYPE_HTM = ".htm";
    protected static final String FILE_TYPE_HTML = ".html";
    protected static final String FILE_TYPE_TXT = ".txt";
    protected static final String FILE_TYPE_JPG = ".jpg";
    protected static final String FILE_TYPE_JPEG = ".jpeg";
    protected static final String FILE_TYPE_GIF = ".gif";
    protected static final String FILE_TYPE_JNLP = ".jnlp";
    protected static final String FILE_TYPE_JAR = ".jar";
    protected static final String FILE_TYPE_DESCRIPTION_HTML = "text/html";
    protected static final String FILE_TYPE_DESCRIPTION_GIF = "image/gif";
    protected static final String FILE_TYPE_DESCRIPTION_JPEG = "image/jpeg";
    protected static final String FILE_TYPE_DESCRIPTION_JNLP = "application/x-java-jnlp-file";
    protected static final String FILE_TYPE_DESCRIPTION_JAR = "application/java-archive";
    protected static final String FILE_TYPE_DESCRIPTION_STREAM = "application/octet-stream";
    protected List<byte[]> myMessageBuffer = new ArrayList<byte[]>();
    protected HttpConstants.Authentication myAuthentication = HttpConstants.Authentication.AUTHENTICATION_OFF;
    protected String myDirectory = System.getProperty("user.home");
    protected String myCurrentRequestedFile;
    protected int myRequestedFileLength;
    protected InputStream myRequestedFileInputStream;
    protected File myRequestedFile;
    private boolean myDecodeFileName = true;
    private ProgressTimerListener myProgressListener;
    private long mySendBytes;
    private TimerService myTimerService;

    public FileHandler() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("Created file handler for HTTP server.");
        this.myTimerService = TimerService.getInstance();
        this.myProgressListener = new ProgressTimerListener();
    }

    @Override
    public void setServerHomeDirectory(String directory) {
        this.myDirectory = directory;
    }

    public String getServerDirectory() {
        return this.myDirectory;
    }

    public void setUseUrlDecoding(boolean decode) {
        this.myDecodeFileName = decode;
    }

    public boolean getUseUrlDecoding() {
        return this.myDecodeFileName;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        try {
            this.processHTTPMessage(this.receive());
        }
        catch (Exception e) {
            this.myLogger.debug("Failed to receive HTTP message: ", e);
        }
        try {
            try {
                this.myLogger.trace("Write HTTP header to socket outputStream ");
                byte[] messageHeaderArray = this.myMessageBuffer.remove(0);
                this.startProgressTimer();
                this.myOutputStream.write(messageHeaderArray, 0, messageHeaderArray.length);
                this.mySendBytes = messageHeaderArray.length;
                this.myLogger.debug(new String(messageHeaderArray));
                this.myLogger.trace("Start writing message to socket outputStream ");
                if (this.myRequestedFileInputStream != null) {
                    this.readInputStream();
                    byte[] buf = new byte[4096];
                    int length = 0;
                    while ((length = this.myRequestedFileInputStream.read(buf)) > 0) {
                        this.myOutputStream.write(buf, 0, length);
                        this.mySendBytes += (long)length;
                    }
                }
                this.myOutputStream.flush();
                this.myLogger.debug("File transfer completed.");
                this.stopProgressTimer();
                this.notifyListeners(new TransferInfo(messageHeaderArray.length, 1.0, TransferInfo.TransferStatus.TRANSFER_COMPLETED, this.myRequestedFile, ""));
            }
            catch (NullPointerException npe) {
                this.myLogger.error("HTTP server is not started yet. " + npe);
                this.myLogger.trace("Close fileInputStream, outputStream and socket.");
                if (this.myRequestedFileInputStream != null) {
                    try {
                        this.myRequestedFileInputStream.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Requested file input stream closing failed. " + e);
                    }
                    this.myRequestedFileInputStream = null;
                }
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Socket output stream closing failed. " + e);
                    }
                    this.myOutputStream = null;
                }
                if (this.mySocket != null) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Socket closing failed. " + e);
                    }
                    this.mySocket = null;
                }
                this.myTimerService.stopTimer(this.myProgressListener);
                this.myTimerService = null;
            }
            catch (SocketException se) {
                block54: {
                    this.myLogger.error("Socket exception when server is writing to socket. Client has probably closed socket. " + se);
                    this.myLogger.trace("Close fileInputStream, outputStream and socket.");
                    if (this.myRequestedFileInputStream == null) break block54;
                    try {
                        this.myRequestedFileInputStream.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Requested file input stream closing failed. " + e);
                    }
                    this.myRequestedFileInputStream = null;
                }
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Socket output stream closing failed. " + e);
                    }
                    this.myOutputStream = null;
                }
                if (this.mySocket != null) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException e) {
                        this.myLogger.error("Socket closing failed. " + e);
                    }
                    this.mySocket = null;
                }
                this.myTimerService.stopTimer(this.myProgressListener);
                this.myTimerService = null;
            }
            catch (Exception e) {
                block55: {
                    this.myLogger.error(e);
                    this.myLogger.trace("Close fileInputStream, outputStream and socket.");
                    if (this.myRequestedFileInputStream == null) break block55;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        this.myRequestedFileInputStream.close();
                    }
                    catch (IOException e2) {
                        this.myLogger.error("Requested file input stream closing failed. " + e2);
                    }
                    this.myRequestedFileInputStream = null;
                }
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e3) {
                        this.myLogger.error("Socket output stream closing failed. " + e3);
                    }
                    this.myOutputStream = null;
                }
                if (this.mySocket != null) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException e4) {
                        this.myLogger.error("Socket closing failed. " + e4);
                    }
                    this.mySocket = null;
                }
                this.myTimerService.stopTimer(this.myProgressListener);
                this.myTimerService = null;
            }
        }
        finally {
            this.myLogger.trace("Close fileInputStream, outputStream and socket.");
            if (this.myRequestedFileInputStream != null) {
                try {
                    this.myRequestedFileInputStream.close();
                }
                catch (IOException e) {
                    this.myLogger.error("Requested file input stream closing failed. " + e);
                }
                this.myRequestedFileInputStream = null;
            }
            if (this.myOutputStream != null) {
                try {
                    this.myOutputStream.close();
                }
                catch (IOException e) {
                    this.myLogger.error("Socket output stream closing failed. " + e);
                }
                this.myOutputStream = null;
            }
            if (this.mySocket != null) {
                try {
                    this.mySocket.close();
                }
                catch (IOException e) {
                    this.myLogger.error("Socket closing failed. " + e);
                }
                this.mySocket = null;
            }
            this.myTimerService.stopTimer(this.myProgressListener);
            this.myTimerService = null;
        }
    }

    protected void processHTTPMessage(String message) {
        String tempMessage = message;
        if (tempMessage != null && !"".equalsIgnoreCase(tempMessage)) {
            if ((tempMessage = tempMessage.replaceAll("\r", "").replaceAll("\n", " ").trim()).startsWith("GET /") || tempMessage.startsWith("HEAD")) {
                boolean head = tempMessage.startsWith("HEAD");
                this.sendFile(head, tempMessage.substring(tempMessage.indexOf(" "), tempMessage.indexOf("HTTP/1.1")).trim());
            } else {
                this.send(this.createResponse("HTTP/1.1 501 Not Implemented"));
            }
        } else {
            this.myLogger.error("The client request to the server used improper syntax. Send HTTP Bad Request 400: Not Implemented.");
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, null, null, 400, "HTTP not implemented"));
            this.send(this.createResponse("HTTP/1.1 400 Bad Request"));
        }
    }

    protected void sendFile(boolean head, String fileName) {
        String decodedFileName = this.myDecodeFileName ? TextUtils.decodeHTML(fileName) : fileName;
        String content = this.getContent(decodedFileName);
        this.myCurrentRequestedFile = decodedFileName;
        this.myRequestedFile = new File(String.valueOf(this.myDirectory) + FS + decodedFileName);
        boolean doesExist = this.myRequestedFile.exists();
        boolean isReadable = this.myRequestedFile.canRead();
        boolean hasTwoDots = decodedFileName.indexOf("..") >= 0;
        boolean hasColon = decodedFileName.indexOf(":") >= 0;
        boolean isDirectory = this.myRequestedFile.isDirectory();
        if (doesExist && isReadable && !hasTwoDots && !hasColon && !isDirectory) {
            if (!head) {
                this.myRequestedFileInputStream = this.loadText(this.myRequestedFile);
            }
            this.notifyListeners(new TransferInfo(this.myRequestedFileLength, 0.0, TransferInfo.TransferStatus.TRANSFER_INITIALIZING, this.myRequestedFile, null, 200, "HTTP URL connection OK"));
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.1 200 OK");
            builder.append(content);
            builder.append(ROW_CHANGE);
            builder.append("Content-Length: ");
            builder.append(this.myRequestedFileLength);
            builder.append(ROW_CHANGE);
            builder.append(ROW_CHANGE);
            this.send(builder.toString());
            this.myResponseCode = 200;
            this.myLogger.debug("Created header");
        } else if (doesExist && isDirectory) {
            this.myLogger.error("Client requests directory" + this.myRequestedFile.getPath() + ". Directory requests are not supported.");
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, this.myRequestedFile, null, 501, "HTTP not implemented"));
            this.send(this.createResponse("HTTP/1.1 501 Not Implemented"));
        } else {
            String properties = String.format("exists:%s, canRead:%s, no2Dots:%s, noColon:%s, notDir:%s", doesExist, isReadable, !hasTwoDots, !hasColon, !isDirectory);
            this.myLogger.error("File " + this.myRequestedFile.getPath() + " not found. Flags: " + properties);
            this.notifyListeners(new TransferInfo(-1L, -1.0, TransferInfo.TransferStatus.TRANSFER_ERROR, this.myRequestedFile, null, null, "HTTP URL connection not found"));
            this.send(this.createResponse("HTTP/1.1 404 Not Found"));
        }
    }

    protected String getContent(String filename) {
        StringBuffer c = new StringBuffer("\r\nContent-Type: ");
        if (filename.endsWith(FILE_TYPE_HTM) || filename.endsWith(FILE_TYPE_HTML) || filename.endsWith(FILE_TYPE_TXT)) {
            c.append(FILE_TYPE_DESCRIPTION_HTML);
        } else if (filename.endsWith(FILE_TYPE_JPG) || filename.endsWith(FILE_TYPE_JPEG)) {
            c.append(FILE_TYPE_DESCRIPTION_JPEG);
        } else if (filename.endsWith(FILE_TYPE_GIF)) {
            c.append(FILE_TYPE_DESCRIPTION_GIF);
        } else if (filename.endsWith(FILE_TYPE_JNLP)) {
            c.append(FILE_TYPE_DESCRIPTION_JNLP);
        } else if (filename.endsWith(FILE_TYPE_JAR)) {
            c.append(FILE_TYPE_DESCRIPTION_JAR);
        } else {
            c.append(FILE_TYPE_DESCRIPTION_STREAM);
        }
        return c.toString();
    }

    protected synchronized BufferedInputStream loadText(File file) {
        this.myLogger.debug("Read file " + file.getName() + " content");
        this.myRequestedFileLength = Long.valueOf(file.length()).intValue();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.myLogger.error("Http Server file handler cannot read requested file. " + e);
        }
        return in;
    }

    protected void send(String message) {
        this.myMessageBuffer.add(message.getBytes());
    }

    protected String createResponse(String statusCode) {
        StringBuilder builder = new StringBuilder();
        builder.append(statusCode);
        builder.append(ROW_CHANGE);
        builder.append("Content-Length:");
        builder.append(" 0");
        builder.append(ROW_CHANGE);
        builder.append(ROW_CHANGE);
        return builder.toString();
    }

    protected void close() {
        try {
            this.mySocket.close();
        }
        catch (Exception e) {
            this.myLogger.trace("Exception when closing socket in HTTP server. " + e);
        }
        this.mySocket = null;
        this.myTimerService = null;
    }

    @Override
    public boolean shutdown() {
        this.close();
        return true;
    }

    @Override
    public FileHandler clone() {
        FileHandler handler = (FileHandler)super.clone();
        handler.myAuthentication = this.myAuthentication;
        handler.myDirectory = new String(this.myDirectory);
        return handler;
    }

    private void startProgressTimer() {
        if (this.myProgressListener != null) {
            this.myTimerService.startTimer(System.currentTimeMillis(), this.myProgressListener, 1000L, false, 0, true);
        }
    }

    private void stopProgressTimer() {
        if (this.myProgressListener != null) {
            this.myTimerService.stopTimer(this.myProgressListener);
        }
    }

    private class ProgressTimerListener
    implements ActionListener {
        private ProgressTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (FileHandler.this.myRequestedFileLength != 0) {
                FileHandler.this.notifyListeners(new TransferInfo(FileHandler.this.myRequestedFileLength, FileHandler.this.mySendBytes * 100L / (long)FileHandler.this.myRequestedFileLength, TransferInfo.TransferStatus.TRANSFER_ONGOING, FileHandler.this.myRequestedFile, null));
            } else {
                FileHandler.this.myLogger.error("The length of http Server file handler requested file is zero. Probably due to broken connection ");
                FileHandler.this.notifyListeners(new TransferInfo(FileHandler.this.myRequestedFileLength, 0.0, TransferInfo.TransferStatus.TRANSFER_ERROR, FileHandler.this.myRequestedFile, null));
            }
        }
    }
}

