/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.http.server.EndPoint;
import com.nokia.em.poseidon.comm.http.server.Handler;
import java.net.BindException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class HttpServer {
    private Logger myLogger;
    private ConcurrentHashMap<String, EndPoint> myEndPoints = new ConcurrentHashMap();
    private ConcurrentHashMap<EndPoint, List<Handler>> myEndPointsToHanlers = new ConcurrentHashMap();
    private CopyOnWriteArrayList<Handler> myHandlers = new CopyOnWriteArrayList();
    private boolean myIsRunning;
    private boolean myIsDestroyed;

    public HttpServer() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("HTTP server created.");
    }

    public void addEndPoint(String name, EndPoint endPoint) throws IllegalArgumentException {
        if (this.isPortInUseAlready(endPoint.getPort())) {
            throw new IllegalArgumentException("Server uses already defined port " + endPoint.getPort() + "." + " Use existing EndPoint or change port of your EndPoint.");
        }
        this.myEndPoints.put(name, endPoint);
        this.myLogger.trace("Added end point " + name + " to HTTP server.");
    }

    public void removeEndPoint(String name) {
        if (this.myEndPoints.containsKey(name)) {
            this.myEndPointsToHanlers.remove(this.myEndPoints.get(name));
            this.myEndPoints.remove(name);
            this.myLogger.trace("Removed end point " + name + " from HTTP server.");
        } else {
            this.myLogger.trace("Tried to remove non existing end point " + name + " from HTTP server.");
        }
    }

    public Map<String, EndPoint> getEndPoints() {
        return this.myEndPoints;
    }

    public void addHandler(Handler handler) {
        this.myHandlers.add(handler);
        this.myLogger.trace("Added handler to HTTP server.");
    }

    public void removeHandler(Handler handler) {
        this.myHandlers.remove(handler);
        for (EndPoint endPoint : this.myEndPointsToHanlers.keySet()) {
            List<Handler> handlers = this.myEndPointsToHanlers.get(endPoint);
            if (handlers == null) continue;
            handlers.remove(handler);
        }
        this.myLogger.trace("Removed handler from HTTP server.");
    }

    public List<Handler> getHandlers() {
        return this.myHandlers;
    }

    public boolean isDestroyed() {
        return this.myIsDestroyed;
    }

    public boolean isRunning() {
        return this.myIsRunning;
    }

    public void bindEndPointToHandler(EndPoint endPoint, Handler handler) {
        List<Handler> handlers = this.myEndPointsToHanlers.get(endPoint);
        if (handlers != null) {
            handlers.add(handler);
        } else {
            handlers = new ArrayList<Handler>();
            handlers.add(handler);
            this.myEndPointsToHanlers.put(endPoint, handlers);
        }
        if (!this.myEndPoints.containsValue(endPoint)) {
            this.myEndPoints.put(endPoint.getName(), endPoint);
        }
        if (!this.myHandlers.contains(handler)) {
            this.myHandlers.add(handler);
        }
    }

    public void unbindEndPointFromHandler(EndPoint endPoint, Handler handler) {
        List<Handler> handlers = this.myEndPointsToHanlers.get(endPoint);
        if (handlers != null) {
            handlers.remove(handler);
        }
    }

    public List<Handler> getBindedHandlers(EndPoint endpoint) {
        return this.myEndPointsToHanlers.get(endpoint);
    }

    public void start() throws RuntimeException {
        boolean leastOnePortListening = false;
        for (EndPoint endPoint : this.myEndPoints.values()) {
            try {
                endPoint.start();
                leastOnePortListening = true;
            }
            catch (BindException e) {
                this.myLogger.trace("End point " + endPoint + " starting fails. No free port found. " + e);
            }
        }
        if (!leastOnePortListening) {
            this.myLogger.error("HTTP server starting fails. No free port found");
            throw new RuntimeException("End point starting fails. No free port found.");
        }
        this.myIsRunning = true;
        this.myLogger.debug("HTTP server started.");
    }

    public void stop() {
        for (EndPoint endpoint : this.myEndPoints.values()) {
            endpoint.shutdown(this);
        }
        for (Handler handler : this.myHandlers) {
            handler.shutdown();
        }
        this.myIsRunning = false;
        this.myLogger.debug("HTTP server stopped.");
    }

    public void destroy() {
        this.stop();
        this.myHandlers.clear();
        this.myEndPoints.clear();
        this.myIsRunning = false;
        this.myIsDestroyed = true;
        this.myLogger.debug("HTTP server destroyed.");
    }

    protected void post(Socket client, EndPoint endpoint) {
        List<Handler> handlers = this.myEndPointsToHanlers.get(endpoint);
        if (handlers != null) {
            this.post(client, handlers);
        } else {
            this.post(client, this.myHandlers);
        }
    }

    private void post(Socket client, List<Handler> handlers) {
        for (Handler handler : handlers) {
            if (!handler.clone().handle(client)) continue;
            return;
        }
    }

    private boolean isPortInUseAlready(int port) {
        for (EndPoint endPoint : this.myEndPoints.values()) {
            if (endPoint.getPort() != port) continue;
            return true;
        }
        return false;
    }
}

