/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.server.AuthFileHandler;
import com.nokia.em.poseidon.comm.http.server.EndPoint;
import com.nokia.em.poseidon.comm.http.server.FileHandler;
import com.nokia.em.poseidon.comm.http.server.Handler;
import com.nokia.em.poseidon.comm.http.server.HttpServer;
import com.nokia.em.poseidon.comm.http.server.SSLServerSocketEndPoint;
import com.nokia.em.poseidon.comm.http.server.ServerSocketEndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HttpServerFactory {
    private static List<HttpServer> myServers;

    public static HttpServer createHttpServer() {
        HttpServer server = new HttpServer();
        if (myServers == null) {
            myServers = new ArrayList<HttpServer>();
        }
        myServers.add(server);
        return server;
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication) {
        return HttpServerFactory.createHttpServer(secure, authentication, null);
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication, int[] portRange) {
        int port = -1;
        if (portRange != null && portRange.length > 0) {
            port = portRange[0];
        }
        return HttpServerFactory.createHttpServer(secure, authentication, null, null, null, port, null, null, portRange);
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication, String serverDirectory, String userName, String password, int port, String keyStorePath, String keyStorePassword) {
        return HttpServerFactory.createHttpServer(secure, authentication, serverDirectory, userName, password, port, keyStorePath, keyStorePassword, null);
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication, String serverDirectory, String userName, String password, int port, String keyStorePath, String keyStorePassword, String clientKeyStorePath, String clientKeyStorePassword) {
        return HttpServerFactory.createHttpServer(secure, authentication, serverDirectory, userName, password, port, keyStorePath, keyStorePassword, clientKeyStorePath, clientKeyStorePassword, null);
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication, String serverDirectory, String userName, String password, int port, String keyStorePath, String keyStorePassword, int[] portRange) {
        return HttpServerFactory.createHttpServer(secure, authentication, serverDirectory, userName, password, port, keyStorePath, keyStorePassword, null, null, portRange);
    }

    public static HttpServer createHttpServer(boolean secure, HttpConstants.Authentication authentication, String serverDirectory, String userName, String password, int port, String keyStorePath, String keyStorePassword, String clientKeyStorePath, String clientKeyStorePassword, int[] portRange) {
        HttpServer server = HttpServerFactory.createHttpServer();
        EndPoint endPoint = HttpServerFactory.createEndPoint(secure);
        endPoint.setPortRange(portRange);
        server.addEndPoint(endPoint.getName(), endPoint);
        Handler handler = HttpServerFactory.createHandler(authentication);
        server.addHandler(handler);
        HttpServerFactory.configureEndPoints(server.getEndPoints().values(), port, keyStorePath, keyStorePassword, clientKeyStorePath, clientKeyStorePassword, portRange);
        HttpServerFactory.configureHandlers(server.getHandlers(), serverDirectory, userName, password);
        server.bindEndPointToHandler(endPoint, handler);
        endPoint.initialize(server);
        handler.initialize(handler.getClass().toString());
        return server;
    }

    public static List<HttpServer> getExistingServers() {
        ArrayList<HttpServer> servers = new ArrayList<HttpServer>();
        for (HttpServer server : myServers) {
            if (server.isDestroyed()) continue;
            servers.add(server);
        }
        myServers.clear();
        myServers.addAll(servers);
        return myServers;
    }

    private static EndPoint createEndPoint(boolean secure) {
        ServerSocketEndPoint endPoint = secure ? new SSLServerSocketEndPoint(SSLServerSocketEndPoint.class.getName()) : new ServerSocketEndPoint(ServerSocketEndPoint.class.getName());
        return endPoint;
    }

    private static Handler createHandler(HttpConstants.Authentication authentication) {
        FileHandler handler;
        if (authentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_BASIC) || authentication.equals((Object)HttpConstants.Authentication.AUTHENTICATION_DIGEST)) {
            handler = new AuthFileHandler();
            handler.setAuthentication(authentication);
        } else {
            handler = new FileHandler();
        }
        return handler;
    }

    private static void configureEndPoints(Collection<EndPoint> endPoints, int port, String keyStorePath, String keyStorePassword, String clientKeyStorePath, String clientKeyStorePassword, int[] portRange) {
        for (EndPoint endPoint : endPoints) {
            if (port != -1) {
                endPoint.setPort(port);
            }
            if (portRange != null) {
                endPoint.setPortRange(portRange);
            }
            if (!(endPoint instanceof SSLServerSocketEndPoint)) continue;
            if (keyStorePath != null) {
                ((SSLServerSocketEndPoint)endPoint).setKeyStorePath(keyStorePath);
            }
            if (keyStorePassword != null) {
                ((SSLServerSocketEndPoint)endPoint).setKeyStorePassword(keyStorePassword);
                ((SSLServerSocketEndPoint)endPoint).setKeyPassword(keyStorePassword);
            }
            if (clientKeyStorePath == null) continue;
            ((SSLServerSocketEndPoint)endPoint).setNeedClientAuthentication(true);
            ((SSLServerSocketEndPoint)endPoint).setClientKeyStorePath(clientKeyStorePath);
            ((SSLServerSocketEndPoint)endPoint).setClientKeyStorePassword(clientKeyStorePassword.toCharArray());
        }
    }

    private static void configureHandlers(List<Handler> handlers, String dir, String userName, String password) {
        for (Handler handler : handlers) {
            if (handler instanceof AuthFileHandler) {
                if (dir != null) {
                    ((AuthFileHandler)handler).setServerHomeDirectory(dir);
                }
                if (userName == null) continue;
                ((AuthFileHandler)handler).addUser(userName, password);
                continue;
            }
            if (!(handler instanceof FileHandler) || dir == null) continue;
            ((FileHandler)handler).setServerHomeDirectory(dir);
        }
    }
}

