/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.Tools;
import com.nokia.em.poseidon.comm.http.server.HttpServer;
import com.nokia.em.poseidon.comm.http.server.ServerSocketEndPoint;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class SSLServerSocketEndPoint
extends ServerSocketEndPoint {
    private String myKeyStorePath = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
    private char[] myKeyStorePassword = HttpConstants.DEFAULT_KEYSTORE_PASSWORD;
    private String myClientKeyStorePath = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
    private char[] myClientKeyStorePassword = HttpConstants.DEFAULT_KEYSTORE_PASSWORD;
    private char[] myKeyPassword = new char[]{'p', 'o', 's', 'e', 'i', 'd', 'o', 'n'};
    private HttpConstants.Protocol myProtocol = HttpConstants.Protocol.SSL;
    private String[] myCipherSuites;
    private boolean myNeedClientAuthentication = false;
    private String myAliasName;
    private String[] myEnabledProtocolVersions = new String[]{"TLSv1.2", "TLSv1"};

    public SSLServerSocketEndPoint(String name) {
        super(name);
    }

    @Override
    public void initialize(HttpServer server) {
        super.initialize(server);
        try {
            URL keystoreUrl = PFileUtils.parseToURL(this.myKeyStorePath);
            if (keystoreUrl == null) {
                this.myLogger.error("Could not find the keystore file from path: " + this.myKeyStorePath);
                return;
            }
            this.myKeyPassword = this.myKeyPassword == null ? this.myKeyStorePassword : this.myKeyPassword;
            KeyStore keystore = this.loadKeystoreFromURL(keystoreUrl, this.myKeyStorePassword);
            String protocol = this.myProtocol.equals((Object)HttpConstants.Protocol.SSL) ? "SSL" : "TLS";
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(this.getKeyManagers(keystore, this.myKeyPassword, this.myAliasName), this.getTrustManagers(), null);
            this.myFactory = context.getServerSocketFactory();
        }
        catch (GeneralSecurityException e) {
            this.myLogger.error(e);
        }
        catch (IOException ex) {
            this.myLogger.error(ex);
        }
    }

    public void setKeyStorePath(String path) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set keystore path because EndPoint is already started.");
        }
        this.myKeyStorePath = path;
    }

    public void setKeyStorePassword(String password) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set keystore password because EndPoint is already started.");
        }
        this.myKeyStorePassword = password.toCharArray();
    }

    public void setKeyPassword(String password) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set keystore password because EndPoint is already started.");
        }
        this.myKeyPassword = password.toCharArray();
    }

    public void setClientKeyStorePath(String clientKeyStorePath) {
        this.myClientKeyStorePath = clientKeyStorePath;
    }

    public void setClientKeyStorePassword(char[] clientKeyStorePassword) {
        this.myClientKeyStorePassword = clientKeyStorePassword;
    }

    public void setAlias(String alias) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set keystore password because EndPoint is already started.");
        }
        this.myAliasName = alias;
    }

    public void setUsedProtocol(HttpConstants.Protocol protocol) {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set protocol because EndPoint is already started.");
        }
        this.myProtocol = protocol;
    }

    public HttpConstants.Protocol getUsedProtocol() {
        return this.myProtocol;
    }

    public void setEnabledCipherSuites(String[] cipherSuites) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set chipher suites because EndPoint is already started.");
        }
        this.myCipherSuites = cipherSuites;
    }

    public void setNeedClientAuthentication(boolean needClientAuth) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set client mode because EndPoint is already started.");
        }
        this.myNeedClientAuthentication = needClientAuth;
    }

    public void setEnabledProtocolVersions(String[] supportedProtocolVersions) {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set supported protocol versions because EndPoint is already started.");
        }
        this.myEnabledProtocolVersions = supportedProtocolVersions;
    }

    public String[] getEnabledProtocolVersions() {
        return this.myEnabledProtocolVersions;
    }

    @Override
    protected ServerSocket createSocket() throws IOException, BindException {
        SSLServerSocket serverSocket = (SSLServerSocket)super.createSocket();
        if (this.myEnabledProtocolVersions != null) {
            serverSocket.setEnabledProtocols(this.myEnabledProtocolVersions);
        }
        if (this.myCipherSuites != null) {
            serverSocket.setEnabledCipherSuites(this.myCipherSuites);
        }
        serverSocket.setNeedClientAuth(this.myNeedClientAuthentication);
        return serverSocket;
    }

    private KeyStore loadKeystoreFromURL(URL url, char[] password) throws IOException, GeneralSecurityException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        InputStream stream = url.openStream();
        keystore.load(stream, password);
        stream.close();
        return keystore;
    }

    private KeyManager[] getKeyManagers(KeyStore keystore, char[] pwd, String alias) throws GeneralSecurityException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance("SunX509");
        factory.init(keystore, pwd);
        KeyManager[] kms = factory.getKeyManagers();
        if (alias != null) {
            int i = 0;
            while (i < kms.length) {
                if (kms[i] instanceof X509KeyManager) {
                    kms[i] = new AliasForcingKeyManager((X509KeyManager)kms[i], alias);
                }
                ++i;
            }
        }
        return kms;
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManager[] trustManagers = null;
        KeyStore keyStore = Tools.loadKeyStoreFromFile(this.myClientKeyStorePath, this.myClientKeyStorePassword);
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        if (keyStore != null) {
            factory.init(keyStore);
            trustManagers = factory.getTrustManagers();
        }
        return trustManagers;
    }

    private static class AliasForcingKeyManager
    implements X509KeyManager {
        X509KeyManager myBaseKeyManager = null;
        String myAlias = null;

        public AliasForcingKeyManager(X509KeyManager keyManager, String alias) {
            this.myBaseKeyManager = keyManager;
            this.myAlias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.myBaseKeyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] validAliases = this.myBaseKeyManager.getServerAliases(keyType, issuers);
            if (validAliases != null) {
                int j = 0;
                while (j < validAliases.length) {
                    if (validAliases[j].equals(this.myAlias)) {
                        return this.myAlias;
                    }
                    ++j;
                }
            }
            return this.myBaseKeyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.myBaseKeyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.myBaseKeyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.myBaseKeyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.myBaseKeyManager.getServerAliases(keyType, issuers);
        }
    }
}

