/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.comm.http.server;

import com.nokia.em.poseidon.comm.http.server.EndPoint;
import com.nokia.em.poseidon.comm.http.server.HttpServer;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;
import org.apache.log4j.Logger;

public class ServerSocketEndPoint
implements EndPoint,
Runnable {
    protected Logger myLogger;
    protected ServerSocket myServerSocket;
    protected int myPort = 80;
    protected boolean myPortModified;
    protected int[] myPortRange;
    protected HttpServer myServer;
    protected String myName;
    protected ServerSocketFactory myFactory;
    protected boolean myIsRunning = false;

    public ServerSocketEndPoint(String name) {
        this.myName = name;
        this.myFactory = ServerSocketFactory.getDefault();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLogger.debug("Created server socket end point.");
    }

    protected ServerSocket createSocket() throws IOException, BindException {
        ServerSocket socket = null;
        if (this.myPortModified) {
            try {
                socket = this.createSocket(this.myPort);
                return socket;
            }
            catch (BindException ex) {
                this.myLogger.trace("HTTP server failed to open port " + this.myPort + ex);
            }
        }
        if (this.myPortRange != null && this.myPortRange.length == 2) {
            int direction = this.myPortRange[0] < this.myPortRange[1] ? 1 : -1;
            int i = this.myPortRange[0];
            while (i != this.myPortRange[1] + direction) {
                try {
                    socket = this.createSocket(i);
                    this.myPort = i;
                    return socket;
                }
                catch (BindException ex) {
                    this.myLogger.trace("HTTP server failed to open port " + i + ex);
                    i += direction;
                }
            }
        }
        socket = this.createSocket(this.myPort);
        return socket;
    }

    protected ServerSocket createSocket(int port) throws IOException, BindException {
        return this.myFactory.createServerSocket(port);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setPort(int port) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set port because EndPoint is already started and listening pre-defined port.");
        }
        this.myPortModified = true;
        this.myPort = port;
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public int[] getPortRange() {
        return this.myPortRange;
    }

    @Override
    public void setPortRange(int[] portRange) throws IllegalStateException {
        if (this.myIsRunning) {
            throw new IllegalStateException("Cannot set port range because EndPoint is already started and listening port.");
        }
        this.myPortRange = portRange;
    }

    @Override
    public void initialize(HttpServer server) {
        this.myServer = server;
        this.myLogger.trace("Endpoint " + this.myName + " initialized.");
    }

    @Override
    public void shutdown(HttpServer server) {
        try {
            this.myIsRunning = false;
            this.myServerSocket.close();
            this.myServerSocket = null;
            this.myLogger.debug("HTTP server endpoint " + this.myName + " stopped from port " + this.myPort);
        }
        catch (NullPointerException npe) {
            this.myLogger.error("End point was not started yet when stopping it.");
        }
        catch (Exception e) {
            this.myLogger.error("Couldn't stop HTTP server: ", e);
        }
    }

    @Override
    public void start() throws BindException {
        try {
            this.myLogger.debug("HTTP server starts to create server socket");
            this.myServerSocket = this.createSocket();
            this.myIsRunning = true;
            Thread thread = new Thread((Runnable)this, String.valueOf(this.myName) + "[" + this.myServerSocket.getLocalPort() + "] end point");
            thread.setDaemon(true);
            thread.start();
        }
        catch (BindException e) {
            this.myLogger.error("End point starting failed. Cannot open server socket to defined ports because those are reserved.");
            throw e;
        }
        catch (IOException e) {
            this.myLogger.error("Exception in end point running method. Most probably end point just stopped. " + e);
        }
        catch (Exception e) {
            this.myLogger.error("Exception when receiving HTTP message. Most probably HTTP server is stopped improperly. " + e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.myIsRunning;
    }

    @Override
    public void run() {
        try {
            this.myLogger.debug("HTTP server end point " + this.myName + " started to listen port " + this.myPort);
            while (this.myIsRunning) {
                this.myLogger.trace("HTTP server ready to accept client requests");
                final Socket client = this.myServerSocket.accept();
                this.myLogger.debug("HTTP Server end point " + this.myName + " connection from " + client.getInetAddress() + ":" + client.getPort());
                Thread th = new Thread(){

                    @Override
                    public void run() {
                        ServerSocketEndPoint.this.myLogger.trace("HTTP server starts to process client request from " + client.getInetAddress() + ":" + client.getPort());
                        ServerSocketEndPoint.this.myServer.post(client, ServerSocketEndPoint.this);
                    }
                };
                ThreadPool.getInstance().execute(th);
            }
        }
        catch (IOException e) {
            this.myLogger.debug("Exception in end point running method. Most probably end point just stopped. " + e);
        }
        catch (Exception e) {
            this.myLogger.error("Exception when receiving HTTP message. Most probably HTTP server is stopped improperly. " + e);
        }
    }
}

