/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos;

import com.nokia.em.poseidon.PoseidonStarter;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.PropertiesBundle;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.plugin.conf.ConfigurationException;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleStatus;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.laf.NetLookAndFeel;
import com.nokia.laf.NetTheme;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class DemoStarter
extends JFrame {
    private int myInsideX = 0;
    private int myInsideY = 0;
    private int myX = 0;
    private int myY = 0;
    private Action myServicesAction;
    private Action myReferenceAction;
    private Action myTransferAction;
    private FadingLabel myTipTextArea;
    private ResourceBundle myResourceBundle;
    private boolean isDemoRunning = false;

    public DemoStarter() throws HeadlessException {
        I18n.getI18n().addResourceBundle(new PropertiesBundle("DemoStarter", "/com/nokia/em/poseidon/demos/res/DemoStarter", Locale.getDefault()), I18n.getI18n().getBaseBundle());
        this.myResourceBundle = I18n.getI18n().getBundle("DemoStarter");
        this.setDefaultCloseOperation(3);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setSize(600, 350);
        this.setTitle("Poseidon Demo Launcher");
        this.setLocationRelativeTo(null);
        this.buildUI();
        this.myX = this.getLocation().x;
        this.myY = this.getLocation().y;
        this.addMouseListener(new MyMouseListenerAdapter());
        this.addMouseMotionListener(new MyMouseMotionAdapter());
    }

    private void buildUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.setBorder(PBorderFactory.getBasicNetBorder(NetTheme.COLOR_BLUE_5));
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.setTopInset(36);
        gbc.anchor = 23;
        gbc.fillBoth();
        gbc.setLeftInset(64);
        JLabel label = new JLabel("Poseidon Demo Launcher");
        label.setForeground(NetTheme.COLOR_GRAY_3);
        label.setFont(new Font("Dialog", 1, 18));
        panel.add((Component)label, gbc);
        gbc.setTopInset(14);
        gbc.setRightInset(45);
        gbc.setLeftInset(0);
        gbc.fillNone();
        gbc.anchor = 12;
        gbc.nextColumn();
        JLabel logoLabel = new JLabel(new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/nsn.png")));
        panel.add((Component)logoLabel, gbc);
        gbc.setRightInset(10);
        gbc.setTopInset(8);
        JButton exitButton = new JButton();
        exitButton.setContentAreaFilled(false);
        exitButton.setFocusable(false);
        exitButton.setBorder(BorderFactory.createEmptyBorder());
        exitButton.setRolloverEnabled(false);
        exitButton.setIcon(new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/Exit_Normal.gif")));
        exitButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/Exit_Pressed.gif")));
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        panel.add((Component)exitButton, gbc);
        gbc.fillBoth();
        gbc.setBottomInset(6);
        gbc.setRightInset(220);
        gbc.setLeftInset(64);
        gbc.nextRow();
        gbc.setColumnWidth(2);
        this.myReferenceAction = new AbstractAction(this.myResourceBundle.getString("ReferenceText"), new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/reference.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoStarter.this.startDemo(new String[]{"-conffile", "com/nokia/em/poseidon/demos/referenceapp/conf.xml"});
            }
        };
        panel.add((Component)this.createButton(this.myReferenceAction, this.myResourceBundle.getString("ReferenceTip"), 112), gbc);
        gbc.nextRow();
        this.myServicesAction = new AbstractAction(this.myResourceBundle.getString("ServicesText"), new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/service.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoStarter.this.startDemo(new String[]{"-application", "com.nokia.em.poseidon.demos.components.ComponentsDemo", "-modules", "./src/com/nokia/em/poseidon/demos/module/jar"});
            }
        };
        panel.add((Component)this.createButton(this.myServicesAction, this.myResourceBundle.getString("ServicesTip"), 114), gbc);
        gbc.nextRow();
        gbc.setBottomInset(32);
        this.myTransferAction = new AbstractAction(this.myResourceBundle.getString("TransferText"), new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/transfer.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoStarter.this.startDemo(new String[]{"-application", "com.nokia.em.poseidon.demos.transfer.FileTransferDemo"});
            }
        };
        panel.add((Component)this.createButton(this.myTransferAction, this.myResourceBundle.getString("TransferTip"), 115), gbc);
        JPanel root = new JPanel(new GridBagLayout());
        GridBagConstraints rootGbc = new GridBagConstraints();
        rootGbc.gridx = 0;
        rootGbc.gridy = 0;
        rootGbc.weightx = 1.0;
        rootGbc.weighty = 1.0;
        rootGbc.fill = 1;
        rootGbc.anchor = 18;
        JPanel background = new JPanel(new BorderLayout());
        background.add((Component)new JLabel(new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/nsn_texture.png")), 4), "South");
        background.setBackground(Color.WHITE);
        root.add((Component)panel, rootGbc);
        root.add((Component)background, rootGbc);
        this.add((Component)root, "Center");
        TexturePanel texturePanel = new TexturePanel();
        texturePanel.setSize(this.getSize());
        this.setGlassPane(texturePanel);
        texturePanel.setVisible(true);
    }

    private JButton createButton(final Action action, final String tipText, final int hotKey) {
        JButton button = new JButton(action);
        button.setIconTextGap(6);
        button.setText(button.getText());
        button.setBackground(Color.WHITE);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DemoStarter.this.myTipTextArea.setText(tipText);
                DemoStarter.this.myTipTextArea.fadeIn();
                DemoStarter.this.myTipTextArea.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DemoStarter.this.myTipTextArea.fadeOut();
            }
        });
        this.getToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == hotKey && !DemoStarter.this.isDemoRunning) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        }, 8L);
        return button;
    }

    private void startDemo(final String[] cmdlineParams) {
        this.startProgress();
        LifecycleManager.getInstance().setCloseOperation(LifecycleManager.CloseOperation.DO_NOTHING_AFTER_CLOSE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PoseidonStarter.init(new PCmdLineParams(cmdlineParams));
                }
                catch (ConfigurationException ex) {
                    Logger.getLogger(DemoStarter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void startProgress() {
        this.setCursor(new Cursor(3));
        this.setEnabled(false);
        LifecycleManager.getInstance().addLifecycleListener(new LifecycleListener(){

            @Override
            public void lifecycleUpdated(LifecycleStatus status) {
                if (status == LifecycleStatus.RUNNING) {
                    DemoStarter.this.isDemoRunning = true;
                    DemoStarter.this.setVisible(false);
                } else if (status == LifecycleStatus.CLOSED) {
                    DemoStarter.this.isDemoRunning = false;
                    DemoStarter.this.setVisible(true);
                    DemoStarter.this.setEnabled(true);
                    DemoStarter.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(new NetLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        new DemoStarter().setVisible(true);
    }

    private class FadingLabel
    extends JTextArea {
        private Timer timer;
        private boolean fadeIn = true;

        public FadingLabel() {
            this.addMouseListener(new MyMouseListenerAdapter());
            this.addMouseMotionListener(new MyMouseMotionAdapter());
            this.setEditable(false);
            this.setBorder(null);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setFocusable(false);
            this.setOpaque(false);
            Color foreGroudColor = UIManager.getColor("Label.systemForeground");
            super.setForeground(new Color(foreGroudColor.getRed(), foreGroudColor.getGreen(), foreGroudColor.getBlue(), 0));
            this.timer = new Timer(45, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = FadingLabel.this.getForeground();
                    int alpha = c.getAlpha();
                    if (FadingLabel.this.fadeIn) {
                        if (alpha <= 225) {
                            alpha += 25;
                        } else {
                            FadingLabel.this.timer.stop();
                            alpha = 255;
                        }
                    } else if (alpha >= 25) {
                        alpha -= 25;
                    } else {
                        FadingLabel.this.timer.stop();
                        alpha = 0;
                    }
                    FadingLabel.this.setForeground(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                }
            });
        }

        public void fadeIn() {
            this.fadeIn = true;
            Color c = this.getForeground();
            super.setForeground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 0));
            this.timer.start();
        }

        public void fadeOut() {
            this.fadeIn = false;
            this.timer.start();
        }
    }

    private class MyMouseListenerAdapter
    extends MouseAdapter {
        private MyMouseListenerAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DemoStarter.this.myInsideX = e.getX();
            DemoStarter.this.myInsideY = e.getY();
        }
    }

    private class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        private MyMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DemoStarter.this.myX = DemoStarter.this.myX + e.getX() - DemoStarter.this.myInsideX;
            DemoStarter.this.myY = DemoStarter.this.myY + e.getY() - DemoStarter.this.myInsideY;
            DemoStarter.this.setLocation(DemoStarter.this.myX, DemoStarter.this.myY);
            DemoStarter.this.setMaximizedBounds(new Rectangle(DemoStarter.this.myX, DemoStarter.this.myY, DemoStarter.this.getWidth(), DemoStarter.this.getHeight()));
        }
    }

    class TexturePanel
    extends JPanel {
        TexturePanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 14;
            gbc.insets = new Insets(128, 0, 0, 30);
            DemoStarter.this.myTipTextArea = new FadingLabel();
            DemoStarter.this.myTipTextArea.setMinimumSize(new Dimension(200, 100));
            DemoStarter.this.myTipTextArea.setPreferredSize(new Dimension(200, 100));
            DemoStarter.this.myTipTextArea.setMaximumSize(new Dimension(200, 100));
            DemoStarter.this.myTipTextArea.setEditable(false);
            DemoStarter.this.myTipTextArea.setPreferredSize(new Dimension(150, 110));
            this.add((Component)DemoStarter.this.myTipTextArea, gbc);
            JLabel label = new JLabel();
            gbc.gridy = 1;
            gbc.anchor = 14;
            gbc.insets = new Insets(100, 0, 2, 2);
            this.add((Component)label, gbc);
        }
    }
}

