/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.components.DecreaseFontSizeAction;
import com.nokia.em.poseidon.demos.components.DemoSnapshotMediator;
import com.nokia.em.poseidon.demos.components.DemoUserAuthenticationMediator;
import com.nokia.em.poseidon.demos.components.DemoWidgetView;
import com.nokia.em.poseidon.demos.components.ExtensionModuleAction;
import com.nokia.em.poseidon.demos.components.IncreaseFontSizeAction;
import com.nokia.em.poseidon.demos.components.PrintDemo;
import com.nokia.em.poseidon.demos.components.TimerPanel;
import com.nokia.em.poseidon.demos.components.actions.DemoAboutDialogAction;
import com.nokia.em.poseidon.demos.components.actions.DemoExitAction;
import com.nokia.em.poseidon.demos.components.actions.DemoLicenceAction;
import com.nokia.em.poseidon.demos.components.actions.DemoMvcAction;
import com.nokia.em.poseidon.demos.components.actions.DemoSnapshotAction;
import com.nokia.em.poseidon.demos.components.actions.DemoUserAuthenticationAction;
import com.nokia.em.poseidon.demos.components.actions.EventsTracker;
import com.nokia.em.poseidon.demos.components.actions.ThreadTracker;
import com.nokia.em.poseidon.demos.components.alarmview.DemoAlarmViewPanel;
import com.nokia.em.poseidon.demos.components.edittable.EditTablePanel;
import com.nokia.em.poseidon.demos.components.i18n.DemoI18nView;
import com.nokia.em.poseidon.demos.components.license.DemoLicenseView;
import com.nokia.em.poseidon.demos.components.mvc2.DemoMVCView;
import com.nokia.em.poseidon.demos.components.treeview.TreeViewPanel;
import com.nokia.em.poseidon.demos.components.wizard.WizardPanel;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.PropertiesBundle;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.services.ui.action.ActionRegistry;
import com.nokia.em.poseidon.services.ui.menu.MenuBarService;
import com.nokia.em.poseidon.services.ui.toolbar.ToolBarService;
import com.nokia.em.poseidon.util.SingletonResetter;
import com.nokia.widgets.Statusbar;
import com.nokia.widgets.hyperlink.Hyperlink;
import com.nokia.widgets.navigation.NavigationPanel;
import com.nokia.widgets.navigation.ViewSwitcher;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ComponentsDemo
implements Application {
    private NavigationPanel myNavigationPanel;
    private JFrame myFrame;
    private AppDescription myDescription = new AppDescription("ComponentsDemo", "ComponentsDemo");
    private MenuBarService myMenuService;
    private JScrollPane myWizardView;
    private JScrollPane myTreeView;
    private JScrollPane myEditTableView;
    private JScrollPane myTimerView;
    private JScrollPane myLicenceView;
    private JScrollPane myMVCView;
    private JScrollPane myWidgetView;
    private JScrollPane myI18nView;
    private ToolBarService myToolBarService;
    private UserInterface myUserInterface;
    private DemoSnapshotMediator mySnapshotMediator;
    private DemoUserAuthenticationMediator myDemoUserAuthenticationMediator;
    private ViewSwitcher myViewSwitcher;
    private JScrollPane myAlarmView;
    private URL myWikiUrl = null;

    @Override
    public AppDescription getDescription() {
        return this.myDescription;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void startUp() {
        this.mySnapshotMediator = new DemoSnapshotMediator(this.myDescription);
        PoseidonRuntime.getRuntime().addObject(this.mySnapshotMediator);
        this.myDemoUserAuthenticationMediator = new DemoUserAuthenticationMediator();
        PoseidonRuntime.getRuntime().addObject(this.myDemoUserAuthenticationMediator);
    }

    @Override
    public void ready() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentsDemo.this.buildUI();
                ComponentsDemo.this.myUserInterface = PoseidonRuntime.getRuntime().getService(UserInterface.class);
                ComponentsDemo.this.myUserInterface.setVisible(true);
            }
        });
    }

    @Override
    public void exit() {
        PoseidonRuntime.getRuntime().removeObject(this.mySnapshotMediator);
        PoseidonRuntime.getRuntime().removeObject(this.myDemoUserAuthenticationMediator);
    }

    @Override
    public void shutDown() {
        ActionRegistry.getInstance().removeAll();
        SingletonResetter.reset(I18n.getI18n());
    }

    private void buildUI() {
        I18n.getI18n().addResourceBundle(new PropertiesBundle("DemoBundle", "/com/nokia/em/poseidon/demos/components/res/ComponentsStringBundle", Locale.getDefault()), I18n.getI18n().getBaseBundle());
        this.myFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        this.myFrame.setTitle("Poseidon Demo Application");
        this.myNavigationPanel = new NavigationPanel();
        this.myFrame.add((Component)this.myNavigationPanel, "West");
        this.myViewSwitcher = new ViewSwitcher();
        this.myFrame.add((Component)this.myViewSwitcher.getPanel(), "Center");
        this.myFrame.add((Component)new Statusbar(this.myFrame), "South");
        this.myWizardView = new JScrollPane(new WizardPanel());
        this.myWizardView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myAlarmView = new JScrollPane(new DemoAlarmViewPanel());
        this.myAlarmView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myTreeView = new JScrollPane(new TreeViewPanel());
        this.myTreeView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myEditTableView = new JScrollPane(new EditTablePanel());
        this.myEditTableView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myTimerView = new JScrollPane(new TimerPanel());
        this.myTimerView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myLicenceView = new JScrollPane(new DemoLicenseView());
        this.myLicenceView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myMVCView = new JScrollPane(new DemoMVCView());
        this.myMVCView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myWidgetView = new JScrollPane(new DemoWidgetView());
        this.myWidgetView.setViewportBorder(BorderFactory.createEmptyBorder());
        this.myI18nView = new JScrollPane(new DemoI18nView());
        this.myI18nView.setViewportBorder(BorderFactory.createEmptyBorder());
        ActionRegistry.getInstance().add(new DemoExitAction());
        ActionRegistry.getInstance().add(new DemoLicenceAction());
        ActionRegistry.getInstance().add(new DemoMvcAction());
        ActionRegistry.getInstance().add(new DemoSnapshotAction());
        ActionRegistry.getInstance().add(new DemoUserAuthenticationAction());
        ActionRegistry.getInstance().add(new DemoAboutDialogAction());
        ActionRegistry.getInstance().add(new ThreadTracker());
        ActionRegistry.getInstance().add(new EventsTracker());
        PoseidonRuntime.getRuntime().getService(UserInterface.class).loadUIConfiguration(this.getClass().getResource("/com/nokia/em/poseidon/demos/components/res/componentsmenu.xml"));
        this.createToolbar();
        this.createNavigationItems();
        this.myFrame.getToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 112 && ComponentsDemo.this.myWikiUrl != null) {
                    Hyperlink link = new Hyperlink("Poseidon Wiki", ComponentsDemo.this.myWikiUrl);
                    link.openURL();
                    keyEvent.consume();
                }
            }
        }, 8L);
        this.myFrame.validate();
    }

    private void createToolbar() {
        this.myMenuService = PoseidonRuntime.getRuntime().getService(MenuBarService.class);
        this.myMenuService.getMenuBar().setApplicationIcon(new ImageIcon(ComponentsDemo.class.getResource("/com/nokia/em/poseidon/demos/components/res/poseidon.jpg")));
        this.myToolBarService = PoseidonRuntime.getRuntime().getService(ToolBarService.class);
        this.createToolBarItem((Action)ActionRegistry.getInstance().get("DemoSnapshotAction"), "/resources/graphics/generic/progress/Progress_Done.gif");
        this.createToolBarItem((Action)ActionRegistry.getInstance().get("ThreadTracker"), null);
        this.createToolBarItem((Action)ActionRegistry.getInstance().get("EventsTracker"), null);
        this.createToolBarItem(new IncreaseFontSizeAction(), "/com/nokia/em/poseidon/demos/res/increasefont.gif");
        this.createToolBarItem(new DecreaseFontSizeAction(), "/com/nokia/em/poseidon/demos/res/decreasefont.gif");
        String implVersion = this.getClass().getPackage().getImplementationVersion();
        if (implVersion == null) {
            this.createToolBarItem(new ExtensionModuleAction(), null);
        }
    }

    private void createNavigationItems() {
        Action firstAction = this.createWrappedAction(1, "wizard", "Wizard Framework", this.myWizardView);
        this.myNavigationPanel.add(firstAction, true);
        this.myNavigationPanel.add(this.createWrappedAction(2, "alarmbell", "Alarm View", this.myAlarmView));
        this.myNavigationPanel.add(this.createWrappedAction(3, "TreeView", "treeview", this.myTreeView));
        this.myNavigationPanel.add(this.createWrappedAction(4, "edittable", "Editable Table", this.myEditTableView));
        this.myNavigationPanel.add(this.createWrappedAction(5, "Timer", "timer", this.myTimerView));
        this.myNavigationPanel.add(this.createWrappedAction(7, "Print", "print", new PrintDemo()));
        this.myNavigationPanel.add(this.createWrappedAction(8, "licence", "Licence", this.myLicenceView));
        this.myNavigationPanel.add(this.createWrappedAction(9, "MVC", "mvc", this.myMVCView));
        this.myNavigationPanel.add(this.createWrappedAction(10, "Widget", "widget", this.myWidgetView));
        this.myNavigationPanel.add(this.createWrappedAction(11, "I18n", "i18n", this.myI18nView));
    }

    protected Action createWrappedAction(int i, String imageName, String name, JComponent panel) {
        Action a = this.createNavigationAction(name, imageName, panel);
        WrappedAction w = new WrappedAction(a, i, name, this);
        URL url = ComponentsDemo.class.getResource("/com/nokia/em/poseidon/demos/components/res/" + imageName + ".gif");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            w.putValue("SmallIcon", icon);
        }
        return w;
    }

    protected Action createNavigationAction(String name, String imageName, JComponent panel) {
        Action action = this.myViewSwitcher.createActionFor(panel, name);
        URL url = ComponentsDemo.class.getResource("/com/nokia/em/poseidon/demos/components/res/" + imageName + ".gif");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            action.putValue("SmallIcon", icon);
        }
        return action;
    }

    private void createToolBarItem(Action action, String imgName) {
        String imageName = imgName;
        if (imageName == null || imageName.length() == 0) {
            imageName = "/com/nokia/em/poseidon/demos/components/res/duke.gif";
        }
        URL url = ComponentsDemo.class.getResource(imageName);
        ImageIcon icon = new ImageIcon(url);
        action.putValue("SmallIcon", icon);
        this.myToolBarService.add(action);
    }

    public void setHelpUrl(int tabNumber) {
        try {
            switch (tabNumber) {
                case 1: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/WizardFramework");
                    break;
                }
                case 2: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/AlarmFramework");
                    break;
                }
                case 3: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/TreeviewComponent");
                    break;
                }
                case 4: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/EditableTableWidget");
                    break;
                }
                case 6: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/CertificateManagementService");
                    break;
                }
                case 7: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/PrintingComponent");
                    break;
                }
                case 8: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/LicenceManagementService");
                    break;
                }
                case 9: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/PoseidonMVC");
                    break;
                }
                case 11: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/I18n");
                    break;
                }
                default: {
                    this.myWikiUrl = new URL("https://twiki.inside.nsn.com/bin/view/Poseidon/");
                    break;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    static class WrappedAction
    extends AbstractAction {
        private Action myAction;
        private int myTab;
        private ComponentsDemo myHelpLauncher;

        public WrappedAction(Action action, int tab, String name, ComponentsDemo componentdemo) {
            super(name);
            this.myAction = action;
            this.myTab = tab;
            this.myHelpLauncher = componentdemo;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.myHelpLauncher.setHelpUrl(this.myTab);
            this.myAction.actionPerformed(arg0);
        }
    }
}

