/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components;

import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotChangeListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class DemoSnapshotMediator
implements PSnapshotMediator {
    private AppDescription myDesc;
    private PSnapshotChangeListener myListener;
    private List<PStepProgressTask> myTasks;
    private boolean isCancelled = false;

    public DemoSnapshotMediator(AppDescription desc) {
        this.myDesc = desc;
        this.myTasks = new ArrayList<PStepProgressTask>();
    }

    @Override
    public AppDescription getDescription() {
        return this.myDesc;
    }

    @Override
    public PStepProgressTask getSnapshotSavingTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.isCancelled = false;
        this.myTasks.clear();
        String name = this.myDesc.getStringProperty("publicName");
        PStepProgressTask parentTTask = new PStepProgressTask("Main Task", name);
        this.myTasks.add(parentTTask);
        PStepProgressTask firstTask = new PStepProgressTask("First Task", name);
        parentTTask.addChildTask(firstTask);
        this.myTasks.add(firstTask);
        PStepProgressTask secondTask = new PStepProgressTask("Second Task", name);
        parentTTask.addChildTask(secondTask);
        this.myTasks.add(secondTask);
        PStepProgressTask thirdTask = new PStepProgressTask("Third Task", name);
        parentTTask.addChildTask(thirdTask);
        this.myTasks.add(thirdTask);
        PStepProgressTask fourthTask = new PStepProgressTask("Fourth Task", name);
        parentTTask.addChildTask(fourthTask);
        this.myTasks.add(fourthTask);
        return parentTTask;
    }

    @Override
    public void addSnapshotChangeListener(PSnapshotChangeListener listener) {
        this.myListener = listener;
    }

    @Override
    public void removeSnapshotChangeListener(PSnapshotChangeListener listener) {
        this.myListener = null;
    }

    @Override
    public void cancelSnapshotSaving() {
        this.isCancelled = true;
    }

    @Override
    public void saveSnapshot(URL snapshotURL, PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.startTask(this.myTasks.get(0));
        this.startTask(this.myTasks.get(1));
        this.finishTask(this.myTasks.get(1));
        this.startTask(this.myTasks.get(2));
        this.finishTask(this.myTasks.get(2));
        this.startTask(this.myTasks.get(3));
        this.finishTask(this.myTasks.get(3));
        this.startTask(this.myTasks.get(4));
        this.finishTask(this.myTasks.get(4));
        this.finishTask(this.myTasks.get(0));
        if (!this.isCancelled) {
            this.myListener.savingCompleted(this);
        } else {
            this.myListener.savingCancelled(this);
        }
    }

    @Override
    public boolean stillAlive() {
        return true;
    }

    private void startTask(PStepProgressTask task) {
        if (!this.isCancelled) {
            task.setState(PStepProgressTask.State.STARTED);
            this.myListener.taskStarted(new PStepProgressEvent(task), 30000);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void finishTask(PStepProgressTask task) {
        if (!this.isCancelled) {
            task.setState(PStepProgressTask.State.COMPLETED);
            this.myListener.taskUpdated(new PStepProgressEvent(task));
        }
    }

    @Override
    public List<PSaveSnapshotModules> getModules() {
        return null;
    }
}

