/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.components.DemoUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.print.PPrintImage;
import com.nokia.em.poseidon.frameworks.print.PPrintLine;
import com.nokia.em.poseidon.frameworks.print.PPrintTable;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.gui.print.PPrintControl;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.widgets.labels.PLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class PrintDemo
extends JPanel {
    private JTextArea myPrintArea;
    private JTextArea myPrintHeader;
    private JTextArea myPrintFooter;
    private JCheckBox myPageNumber;

    public PrintDemo() {
        JPanel printPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipadx = 20;
        c.anchor = 23;
        c.insets = new Insets(6, 12, 6, 12);
        c.gridx = 1;
        c.gridy = 1;
        printPanel.add((Component)PLabel.createTitle("Header"), c);
        ++c.gridy;
        printPanel.add((Component)PLabel.createTitle("Content"), c);
        ++c.gridy;
        printPanel.add((Component)PLabel.createTitle("Footer"), c);
        this.myPrintHeader = new JTextArea();
        JScrollPane printHeaderPane = new JScrollPane(this.myPrintHeader);
        printHeaderPane.setPreferredSize(new Dimension(400, 35));
        this.myPrintHeader.setWrapStyleWord(true);
        this.myPrintHeader.setLineWrap(true);
        this.myPrintHeader.setText("Lorem ipsum dolor sit amet");
        ++c.gridx;
        c.gridy = 1;
        printPanel.add((Component)printHeaderPane, c);
        this.myPrintArea = new JTextArea();
        JScrollPane printAreaPane = new JScrollPane(this.myPrintArea);
        printAreaPane.setPreferredSize(new Dimension(400, 80));
        this.myPrintArea.setWrapStyleWord(true);
        this.myPrintArea.setLineWrap(true);
        this.myPrintArea.setText("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        ++c.gridy;
        printPanel.add((Component)printAreaPane, c);
        this.myPrintFooter = new JTextArea();
        JScrollPane printFooterPane = new JScrollPane(this.myPrintFooter);
        printFooterPane.setPreferredSize(new Dimension(400, 35));
        this.myPrintFooter.setWrapStyleWord(true);
        this.myPrintFooter.setLineWrap(true);
        this.myPrintFooter.setText("Lorem ipsum dolor sit amet");
        ++c.gridy;
        printPanel.add((Component)printFooterPane, c);
        ++c.gridy;
        this.myPageNumber = new JCheckBox("Print page number");
        this.myPageNumber.setSelected(true);
        printPanel.add((Component)this.myPageNumber, c);
        JButton printButton = new JButton(new AbstractAction("Print Dialog"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<String, JFrame> properties = new HashMap<String, JFrame>();
                properties.put("parentfame", PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
                MyPrintableDoc doc = new MyPrintableDoc();
                doc.doPrinting();
                new PPrintControl(doc, properties);
            }
        });
        ++c.gridy;
        printPanel.add((Component)printButton, c);
        this.add(DemoUtils.createDemoPanel("Print Dialog", printPanel));
    }

    private class MyPrintableDoc
    extends PPrintableDoc {
        public MyPrintableDoc() {
            if (PrintDemo.this.myPageNumber.isSelected()) {
                this.setHeaderPageNumberVisible(true);
            } else {
                this.setHeaderPageNumberVisible(false);
            }
            PPrintableArea header = this.createHeader();
            this.setPageHeader(header);
            PPrintableArea footer = this.createFooter();
            this.setPageFooter(footer);
        }

        @Override
        protected void doPrinting() {
            PPrintText textObject = new PPrintText(PrintDemo.this.myPrintArea.getText(), this);
            this.add(textObject);
            PPrintText emptyRow = new PPrintText("", this);
            this.add(emptyRow);
            ImageIcon imageIcon = I18n.getI18n().getBundle(this.getClass()).getImageIcon("CompanyLogo_Icon");
            BufferedImage bufferedImage = (BufferedImage)PrintDemo.this.createImage(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            Graphics2D g2d = bufferedImage.createGraphics();
            g2d.drawImage(imageIcon.getImage(), 0, 0, PrintDemo.this);
            PPrintImage imageObject = new PPrintImage(bufferedImage, this);
            this.add(imageObject);
            Object[] columnNames = new String[]{"First Column", "Second Column"};
            Object[][] data = new Object[][]{{"Lorem ipsum dolor sit amet", "Consectetur adipisicing elit"}, {"Di laoreet dolore magna", "Aliquam erat volupat"}};
            JTable table = new JTable(data, columnNames);
            PPrintTable tableObject = new PPrintTable(table.getModel(), (PPrintableArea)this);
            this.add(tableObject);
        }

        private PPrintableArea createHeader() {
            PPrintableArea header = new PPrintableArea(this);
            PPrintLine line1 = new PPrintLine(0.0, 1.0, 0.0, 0.0, header);
            PPrintLine line2 = new PPrintLine(0.0, 1.0, 0.0, 0.0, header);
            header.add(line1);
            header.add(new PPrintText(PrintDemo.this.myPrintHeader.getText(), header));
            header.add(line2);
            return header;
        }

        private PPrintableArea createFooter() {
            PPrintableArea footer = new PPrintableArea(this);
            PPrintLine line1 = new PPrintLine(0.0, 1.0, 0.0, 0.0, footer);
            PPrintLine line2 = new PPrintLine(0.0, 1.0, 0.0, 0.0, footer);
            footer.add(line1);
            footer.add(new PPrintText(PrintDemo.this.myPrintFooter.getText(), footer));
            footer.add(line2);
            return footer;
        }
    }
}

