/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components;

import com.nokia.em.poseidon.gui.common.edittable.PEditTable;
import com.nokia.em.poseidon.gui.common.edittable.PEditTableModel;
import com.nokia.em.poseidon.util.timer.TimerService;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.spinner.PSpinner;
import com.nokia.widgets.text.PFixedLengthDocument;
import com.nokia.widgets.text.PTextField;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class TimerServiceDemo
extends JPanel {
    private final PLabel myCountdownLabel = new PLabel("9");
    private final FakeGraphPane myGraphPane = new FakeGraphPane();
    private PSpinner myIntervalSpinner = new PSpinner(new SpinnerNumberModel(2000, 100, 5000, 100));
    private final RefreshTimer myRefreshTimer = new RefreshTimer();
    private PSpinner myRepeatsSpinner = new PSpinner(new SpinnerNumberModel(10, 1, 50, 1));
    private JButton myStartButton = new JButton("Schedule");
    private final TaskTableModel myTableModel = new TaskTableModel();
    private PTextField myTaskNameField = new PTextField(new PFixedLengthDocument(8), "Task", 8);
    private int myTaskCounter = 0;

    public TimerServiceDemo() {
        super(new GridBagLayout(), true);
        TimerService.getInstance().setDaemon(true);
        PLabel label = PLabel.createTitle("Timer Service");
        this.add((Component)label, new GridBagConstraints(0, 0, 10, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 6, 12), 0, 0));
        label = PLabel.createSystemText("<html>The Timer Service is useful for periodic tasks, animation and for scheduling single run tasks without cluttering the system with new threads by using <code>Thread.sleep()</code> or <code>Object.wait()</code> methods. The Timer Service uses a <i>single</i> thread for all timers.</html>");
        label.setHorizontalAlignment(0);
        label.setPreferredSize(new Dimension(5, 70));
        this.add((Component)label, new GridBagConstraints(0, 1, 10, 1, 1.0, 0.0, 18, 1, new Insets(6, 24, 0, 12), 0, 0));
        label = PLabel.createTitle("Example I: Refreshing and Animation");
        this.add((Component)label, new GridBagConstraints(0, 5, 10, 1, 0.0, 0.0, 17, 0, new Insets(12, 24, 6, 12), 0, 0));
        label = new PLabel("Next refresh in");
        this.add((Component)label, new GridBagConstraints(0, 10, 9, 1, 1.0, 0.0, 13, 0, new Insets(6, 24, 0, 0), 0, 0));
        this.add((Component)this.myCountdownLabel, new GridBagConstraints(9, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)this.myGraphPane, new GridBagConstraints(0, 20, 10, 1, 0.0, 0.0, 17, 0, new Insets(6, 24, 0, 12), 0, 0));
        label = PLabel.createTitle("Example II: Scheduling Tasks");
        this.add((Component)label, new GridBagConstraints(0, 30, 10, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 6, 12), 0, 0));
        label = PLabel.createSystemText("Task Name");
        this.add((Component)label, new GridBagConstraints(0, 39, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 24, 0, 0), 0, 0));
        this.add((Component)this.myTaskNameField, new GridBagConstraints(0, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 24, 0, 0), 0, 0));
        label = PLabel.createSystemText("Repeats");
        this.add((Component)label, new GridBagConstraints(1, 39, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.add((Component)this.myRepeatsSpinner, new GridBagConstraints(1, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        label = PLabel.createSystemText("Interval (ms)");
        this.add((Component)label, new GridBagConstraints(2, 39, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 12), 0, 0));
        this.add((Component)this.myIntervalSpinner, new GridBagConstraints(2, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.myStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String s = TimerServiceDemo.this.myTaskNameField.getText();
                TimerServiceDemo timerServiceDemo = TimerServiceDemo.this;
                timerServiceDemo.myTaskCounter = timerServiceDemo.myTaskCounter + 1;
                s = String.valueOf(s) + " " + String.valueOf(TimerServiceDemo.this.myTaskCounter);
                TimerServiceDemo.this.myTableModel.newTask(s, ((Number)TimerServiceDemo.this.myIntervalSpinner.getValue()).longValue(), ((Number)TimerServiceDemo.this.myRepeatsSpinner.getValue()).intValue());
            }
        });
        this.add((Component)this.myStartButton, new GridBagConstraints(3, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 12), 0, 0));
        PPanel tablePane = new PPanel(new BorderLayout(), true);
        PEditTable table = new PEditTable(this.myTableModel);
        tablePane.add((Component)table.getTableHeader(), "North");
        tablePane.add((Component)table, "Center");
        this.add((Component)tablePane, new GridBagConstraints(0, 60, 10, 1, 0.0, 0.0, 17, 1, new Insets(12, 24, 12, 12), 0, 0));
        this.notifyShow();
    }

    public void notifyHide() {
        TimerService.getInstance().stopTimer(this.myRefreshTimer);
    }

    public void notifyShow() {
        TimerService.getInstance().startTimer((ActionListener)this.myRefreshTimer, 1000L, true);
    }

    private static final class FakeGraphPane
    extends PPanel
    implements ActionListener {
        private final BufferedImage myAnimBar;
        private int myAnimY;
        private final BufferedImage myBuffer;
        private Image myData;
        private Image myOldData;
        private final Random myRandom = new Random();
        private final Dimension mySize = new Dimension(400, 180);

        FakeGraphPane() {
            super(null, true);
            this.myData = this.createFakeData();
            this.myAnimBar = new BufferedImage(this.mySize.width, 20, 2);
            Graphics2D g = this.myAnimBar.createGraphics();
            g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255, 0), 0.0f, 20.0f, new Color(255, 255, 255)));
            g.fillRect(1, 0, this.mySize.width - 2, 20);
            g.dispose();
            this.myBuffer = new BufferedImage(this.mySize.width, this.mySize.height + 20, 1);
            g = this.myBuffer.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, this.mySize.height, this.mySize.width, 20);
            g.dispose();
            this.setToolTipText("Timers are used to update the countdown, trigger the refresh and time the animation");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.myAnimY += 8;
            if (this.myAnimY > this.mySize.height) {
                this.myOldData = null;
                TimerService.getInstance().stopTimer(this);
            }
            this.repaint();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.mySize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        @Override
        public void paint(Graphics g) {
            if (this.myOldData == null) {
                g.drawImage(this.myData, 0, 0, null);
            } else {
                g.drawImage(this.myData, 0, 0, null);
                Graphics2D buf = this.myBuffer.createGraphics();
                buf.drawImage(this.myOldData, 0, -this.myAnimY - 20, null);
                buf.dispose();
                g.drawImage(this.myBuffer, 0, this.myAnimY + 20, null);
                g.drawImage(this.myAnimBar, 0, this.myAnimY, null);
            }
        }

        private Image createFakeData() {
            BufferedImage data = new BufferedImage(this.mySize.width, this.mySize.height, 1);
            Graphics2D g = data.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, this.mySize.width, this.mySize.height);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.BLUE);
            this.paintChartLine(g, 0);
            g.setColor(Color.RED);
            this.paintChartLine(g, this.mySize.height / 2);
            g.setColor(Color.GRAY);
            this.paintChartLine(g, this.mySize.height);
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(1.0f));
            g.drawRect(0, 0, this.mySize.width - 1, this.mySize.height - 1);
            g.dispose();
            return data;
        }

        private void paintChartLine(Graphics2D g, int start) {
            int step = this.mySize.width / 40;
            int x = 40 * (step + 1);
            int y = start;
            while (x > 0) {
                int newValue;
                int oldX = x;
                int oldY = y;
                x -= step;
                while ((newValue = 10 + this.myRandom.nextInt(this.mySize.height - 20)) > y + 20 || newValue < y - 20) {
                }
                y = newValue;
                g.drawLine(oldX, oldY, x, y);
            }
        }

        private void startRefresh() {
            this.myAnimY = -40;
            int y = this.mySize.height;
            while (--y >= 0) {
                int x = this.mySize.width;
                while (--x >= 0) {
                    this.myBuffer.setRGB(x, y, 0);
                }
            }
            this.myOldData = this.myData;
            this.myData = this.createFakeData();
            TimerService.getInstance().startTimer((ActionListener)this, 40L, true);
        }
    }

    public class RefreshTimer
    implements ActionListener {
        private int myCountdown = 6;

        @Override
        public void actionPerformed(ActionEvent event) {
            if (--this.myCountdown < 8) {
                TimerServiceDemo.this.myCountdownLabel.setText(String.valueOf(Integer.toString(this.myCountdown)) + " seconds");
            }
            if (this.myCountdown == 0) {
                TimerServiceDemo.this.myCountdownLabel.setText("-- seconds");
                this.myCountdown = 10;
                TimerServiceDemo.this.myGraphPane.startRefresh();
            }
        }
    }

    private static final class TaskTableModel
    extends AbstractTableModel
    implements PEditTableModel {
        private final TableColumn[] myColumns = new TableColumn[4];
        private final List<ScheduledTask> myTasks = new ArrayList<ScheduledTask>(10);

        TaskTableModel() {
            this.myColumns[0] = new TableColumn(0);
            this.myColumns[0].setHeaderValue("Task Name");
            this.myColumns[1] = new TableColumn(1);
            this.myColumns[1].setHeaderValue("Repeats");
            this.myColumns[2] = new TableColumn(2);
            this.myColumns[2].setHeaderValue("Interval (ms)");
            this.myColumns[3] = new TableColumn(3);
            this.myColumns[3].setHeaderValue("Status");
        }

        @Override
        public Class getCellClass(int row, int column) {
            return null;
        }

        @Override
        public String getCellToolTipText(int row, int column) {
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.myColumns.length;
        }

        @Override
        public String getColumnName(int column) {
            return (String)this.myColumns[column].getHeaderValue();
        }

        @Override
        public int getRowCount() {
            return this.myTasks.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ScheduledTask task = this.myTasks.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return task.getName();
                }
                case 1: {
                    return task.getRepeats();
                }
                case 2: {
                    return task.getInterval();
                }
                case 3: {
                    return task.getStatus();
                }
            }
            return null;
        }

        @Override
        public boolean isCellDeleted(int row, int column) {
            return false;
        }

        @Override
        public boolean isCellDisabled(int row, int column) {
            return false;
        }

        @Override
        public boolean isCellModified(int row, int column) {
            return false;
        }

        public synchronized void newTask(String name, long interval, int repeats) {
            String tmp = name.trim();
            ScheduledTask task = new ScheduledTask(tmp, interval, repeats);
            int index = this.myTasks.size();
            while (--index >= 0) {
                if (tmp.equals(this.myTasks.get(index).getName())) break;
            }
            if (index >= 0) {
                this.myTasks.set(index, task);
            } else {
                this.myTasks.add(task);
            }
            this.fireTableDataChanged();
            TimerService.getInstance().startTimer(task, interval, true, repeats);
        }

        private final class ScheduledTask
        implements ActionListener {
            private final long myInterval;
            private final String myName;
            private int myRepeats;

            ScheduledTask(String name, long interval, int repeats) {
                this.myName = name;
                this.myInterval = interval;
                this.myRepeats = repeats;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void actionPerformed(ActionEvent event) {
                TaskTableModel taskTableModel = TaskTableModel.this;
                synchronized (taskTableModel) {
                    if (TaskTableModel.this.myTasks.indexOf(this) == -1) {
                        TimerService.getInstance().stopTimer(this);
                        return;
                    }
                }
                if (--this.myRepeats == 0) {
                    TimerService.getInstance().stopTimer(this);
                }
                TaskTableModel.this.fireTableDataChanged();
            }

            long getInterval() {
                return this.myInterval;
            }

            String getName() {
                return this.myName;
            }

            synchronized int getRepeats() {
                return this.myRepeats;
            }

            synchronized String getStatus() {
                return this.myRepeats == 0 ? "Task Dead" : "Running";
            }
        }
    }
}

