/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.alarmview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.components.alarmview.DemoAlarmDetailsView;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.services.alarms.PAlarmBroadcastListener;
import com.nokia.em.poseidon.services.alarms.PAlarmService;
import com.nokia.em.poseidon.services.alarmsview.PAlarmGuiListener;
import com.nokia.em.poseidon.services.alarmsview.PAlarmView;
import com.nokia.em.poseidon.services.alarmsview.PAlarmViewService;
import com.nokia.em.poseidon.services.alarmsview.PFilteringCriteria;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.text.TextFieldFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DemoAlarmViewPanel
extends JPanel
implements PAlarmBroadcastListener,
PAlarmGuiListener {
    private JSplitPane mySplitPane;
    private PAlarmService myAlarmService;
    private PAlarmViewService myAlarmViewService;
    private boolean mySourceVisible;
    private boolean mySourceEnabled;
    private boolean myViewEnabled;
    private JButton myRaiseCritical;
    private JButton myRaiseMajor;
    private JButton myRaiseMinor;
    private JButton myRaiseWarning;
    private Timer myTimer;
    private PAlarmEntry myLatestAlarm;

    public DemoAlarmViewPanel() {
        this.setLayout(new BorderLayout());
        this.mySplitPane = new JSplitPane(0);
        this.mySplitPane.setResizeWeight(0.5);
        this.mySplitPane.setDividerLocation(0.5);
        this.add((Component)this.mySplitPane, "Center");
        this.myRaiseCritical = new JButton(new AbstractAction("Raise Critical"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(3, 1001L, Calendar.getInstance(), "My Critical Alarm", "My Network Element", "MyApplication", true);
                alarm.setHelpRequestId("MY_CRITICAL_ALARM");
                alarm.setAlarmScope("CRITICAL ALARM");
                DemoAlarmViewPanel.this.myAlarmService.raiseAlarm(alarm);
            }
        });
        this.myRaiseMajor = new JButton(new AbstractAction("Raise Major"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(2, 1002L, Calendar.getInstance(), "My Major Alarm", "My Network Element", "MyApplication", true);
                alarm.setHelpRequestId("MY_MAJOR_ALARM");
                alarm.setAlarmScope("MAJOR ALARM");
                DemoAlarmViewPanel.this.myAlarmService.raiseAlarm(alarm);
            }
        });
        this.myRaiseMinor = new JButton(new AbstractAction("Raise Minor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(1, 1003L, Calendar.getInstance(), "My Minor Alarm", "My Network Element", "MyApplication", true);
                alarm.setHelpRequestId("MY_MINOR_ALARM");
                DemoAlarmViewPanel.this.myAlarmService.raiseAlarm(alarm);
            }
        });
        this.myRaiseWarning = new JButton(new AbstractAction("Raise Warning"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(0, 1004L, Calendar.getInstance(), "My Warning Alarm", "My Network Element", "MyApplication", true);
                alarm.setHelpRequestId("MY_WARNING_ALARM");
                alarm.setAlarmScope("SERIOUS WARINING");
                CustomAction action = new CustomAction();
                action.putValue("Name", "Specific action");
                alarm.addSpecificAction(action);
                CustomAction action2 = new CustomAction();
                action2.putValue("Name", "Second specific action");
                alarm.addSpecificAction(action2);
                alarm.setAlarmToggling(true);
                DemoAlarmViewPanel.this.myAlarmService.raiseAlarm(alarm);
            }
        });
        JButton broadcastAlarm = new JButton(new AbstractAction("Broadcast Alarm"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(0, 1L, Calendar.getInstance(), "My Broadcast Alarm", "My Network Element", "MyApplication", true);
                alarm.setHelpRequestId("MY_BROADCAST_ALARM");
                DemoAlarmViewPanel.this.myAlarmService.broadcastAlarm(alarm);
            }
        });
        JButton clearAllAlarms = new JButton(new AbstractAction("Clear All Alarms"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmService.clearAlarms("MyApplication");
            }
        });
        JButton print = new JButton(new AbstractAction("Print Alarms"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.printAlarms();
            }
        });
        JButton dateFormat = new JButton(new AbstractAction("Get Date Format"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = DemoAlarmViewPanel.this.myAlarmViewService.getAlarmDateFormat().getCalendar().getTime().toString();
                JOptionPane.showMessageDialog(DemoAlarmViewPanel.this.mySplitPane, s);
            }
        });
        JButton save = new JButton(new AbstractAction("Save Alarms"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.saveAlarms();
            }
        });
        JButton filterWarnings = new JButton(new AbstractAction("Filter Warnings"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = !DemoAlarmViewPanel.this.myAlarmViewService.getFilteringCriteria().isWarningsFiltered();
                DemoAlarmViewPanel.this.myAlarmViewService.showWarnings(b);
            }
        });
        JButton filterMinor = new JButton(new AbstractAction("Filter Minor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = !DemoAlarmViewPanel.this.myAlarmViewService.getFilteringCriteria().isMinorAlarmsFiltered();
                DemoAlarmViewPanel.this.myAlarmViewService.showMinorAlarms(b);
            }
        });
        JButton filterMajor = new JButton(new AbstractAction("Filter Major"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = !DemoAlarmViewPanel.this.myAlarmViewService.getFilteringCriteria().isMajorAlarmsFiltered();
                DemoAlarmViewPanel.this.myAlarmViewService.showMajorAlarms(b);
            }
        });
        JButton filterCritical = new JButton(new AbstractAction("Filter Critical"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = !DemoAlarmViewPanel.this.myAlarmViewService.getFilteringCriteria().isCriticalAlarmsFiltered();
                DemoAlarmViewPanel.this.myAlarmViewService.showCriticalAlarms(b);
            }
        });
        JButton filterHistory = new JButton(new AbstractAction("Filter History"){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DemoAlarmViewPanel.this.myAlarmViewService.getFilteringCriteria().isAlarmHistoryFiltered();
                DemoAlarmViewPanel.this.myAlarmViewService.showHistory(b);
            }
        });
        JButton addComponent = new JButton(new AbstractAction("Add Component"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = new JButton(DemoAlarmViewPanel.this.getCustomComponentAction());
                DemoAlarmViewPanel.this.myAlarmViewService.addComponentToHeader(button);
            }
        });
        JButton removeComponent = new JButton(new AbstractAction("Remove Components"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.removeComponentsFromHeader();
            }
        });
        JButton showSource = new JButton(new AbstractAction("Show Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.setShowSourceVisible(DemoAlarmViewPanel.this.mySourceVisible);
                DemoAlarmViewPanel.this.mySourceVisible = !DemoAlarmViewPanel.this.mySourceVisible;
            }
        });
        JButton enableSource = new JButton(new AbstractAction("Enable Source"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.setShowSourceEnabled(DemoAlarmViewPanel.this.mySourceEnabled);
                DemoAlarmViewPanel.this.mySourceEnabled = !DemoAlarmViewPanel.this.mySourceEnabled;
            }
        });
        JButton setDefaultSavingPath = new JButton(new AbstractAction("Default Path"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.setDefaultSavingPath("c:\\temp\\");
                JOptionPane.showMessageDialog(DemoAlarmViewPanel.this.mySplitPane, "Path set to c:\\temp\\");
            }
        });
        JButton enableAlarmView = new JButton(new AbstractAction("Enable Alarm View"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.enableAlarmView(DemoAlarmViewPanel.this.myViewEnabled);
                DemoAlarmViewPanel.this.myViewEnabled = !DemoAlarmViewPanel.this.myViewEnabled;
            }
        });
        JButton clearAlarmSelection = new JButton(new AbstractAction("Clear Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.clearAlarmSelection();
            }
        });
        JButton siteName = new JButton(new AbstractAction("Set Site"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmViewService.setSiteName("TestSite");
                JOptionPane.showMessageDialog(DemoAlarmViewPanel.this.mySplitPane, "Site set to TestSite");
            }
        });
        JToggleButton timer = new JToggleButton(new AbstractAction("Start/Stop alarm generation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DemoAlarmViewPanel.this.myTimer.isRunning()) {
                    DemoAlarmViewPanel.this.myTimer.stop();
                } else {
                    DemoAlarmViewPanel.this.myTimer.start();
                }
            }
        });
        timer.setSelected(true);
        JButton clearLatestAlarm = new JButton(new AbstractAction("Clear Latest Alarm"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoAlarmViewPanel.this.myAlarmService.clearAlarm(DemoAlarmViewPanel.this.myLatestAlarm);
            }
        });
        final JSlider slider = new JSlider(2, 2000, 1000);
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>();
        ht.put(2, new JLabel("0s"));
        ht.put(500, new JLabel("0.5s"));
        ht.put(1000, new JLabel("1s"));
        ht.put(1500, new JLabel("1.5s"));
        ht.put(2000, new JLabel("2s"));
        slider.setLabelTable(ht);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DemoAlarmViewPanel.this.myTimer.setDelay(slider.getValue());
            }
        });
        Object[] severities = new Object[]{"SEVERITY_WARNING", "SEVERITY_MINOR", "SEVERITY_MAJOR", "SEVERITY_CRITICAL"};
        final JComboBox<Object> severity = new JComboBox<Object>(severities);
        final PTextField code = TextFieldFactory.createIntegerTextField(1, 100000);
        code.setText("10000");
        final JTextField desc = new JTextField("My Custom Alarm");
        final JTextField source = new JTextField("My Network Element");
        final JCheckBox active = new JCheckBox("Active");
        active.setSelected(true);
        JButton raiseCustomAlarm = new JButton(new AbstractAction("Raise Alarm"){

            @Override
            public void actionPerformed(ActionEvent e) {
                long c;
                int s = severity.getSelectedIndex();
                try {
                    c = Long.valueOf(code.getText());
                }
                catch (NumberFormatException exception) {
                    c = 10000L;
                }
                DemoAlarmViewPanel.this.raiseCustomAlarm(s, c, Calendar.getInstance(), desc.getText(), source.getText(), "MyApplication", active.isSelected());
            }
        });
        JPanel panel1 = new JPanel(new FlowLayout());
        panel1.add(clearLatestAlarm);
        panel1.add(clearAllAlarms);
        JPanel panel2 = new JPanel(new FlowLayout());
        panel2.add(filterWarnings);
        panel2.add(filterMinor);
        panel2.add(filterMajor);
        panel2.add(filterCritical);
        panel2.add(filterHistory);
        JPanel panel3 = new JPanel(new FlowLayout());
        panel3.add(dateFormat);
        panel3.add(broadcastAlarm);
        panel3.add(siteName);
        JPanel panel4 = new JPanel(new FlowLayout());
        panel4.add(print);
        panel4.add(save);
        JPanel panel5 = new JPanel(new FlowLayout());
        panel5.add(addComponent);
        panel5.add(removeComponent);
        panel5.add(showSource);
        panel5.add(enableSource);
        JPanel panel6 = new JPanel(new FlowLayout());
        panel6.add(setDefaultSavingPath);
        panel6.add(enableAlarmView);
        panel6.add(clearAlarmSelection);
        JPanel panel7 = new JPanel(new FlowLayout());
        panel7.add(slider);
        panel7.add(timer);
        JPanel panel8 = new JPanel(new FlowLayout());
        panel8.add(new JLabel("Severity:"));
        panel8.add(severity);
        panel8.add(new JLabel("Code:"));
        panel8.add(code);
        panel8.add(new JLabel("Description:"));
        panel8.add(desc);
        panel8.add(new JLabel("Source:"));
        panel8.add(source);
        panel8.add(active);
        panel8.add(raiseCustomAlarm);
        JPanel panel = new JPanel(new PVerticalLayout(2, 10, 0, 10));
        panel.add(panel8);
        panel.add(panel1);
        panel.add(panel7);
        panel.add(Box.createVerticalStrut(25));
        panel.add(panel2);
        panel.add(panel3);
        panel.add(panel4);
        panel.add(panel5);
        panel.add(panel6);
        this.mySplitPane.setTopComponent(panel);
        this.init();
    }

    public void init() {
        PAlarmUtils.setResourceBundle(I18n.getI18n().getBundle(this.getClass()));
        this.myAlarmService = PoseidonRuntime.getRuntime().getService(PAlarmService.class);
        this.myAlarmViewService = PoseidonRuntime.getRuntime().getService(PAlarmViewService.class);
        this.myAlarmService.addAlarmChangeListener(this.myAlarmViewService);
        PAlarmView view = this.myAlarmViewService.getAlarmView();
        this.mySplitPane.setBottomComponent(view);
        DemoAlarmDetailsView detailsview = new DemoAlarmDetailsView(null);
        this.myAlarmViewService.setDetailsView("MyApplication", detailsview);
        JButton customButton = new JButton(this.getCustomComponentAction());
        this.myAlarmViewService.addComponentToHeader(customButton);
        this.myAlarmViewService.addAlarmListener(this);
        this.myAlarmService.addAlarmBroadcastListener(this);
        ActionListener al = new ActionListener(){
            private int counter = 1;

            @Override
            public void actionPerformed(ActionEvent e) {
                double d = Math.random();
                if (d > 0.75) {
                    DemoAlarmViewPanel.this.myRaiseCritical.getAction().actionPerformed(null);
                } else if (d > 0.5) {
                    DemoAlarmViewPanel.this.myRaiseMajor.getAction().actionPerformed(null);
                } else if (d > 0.25) {
                    DemoAlarmViewPanel.this.myRaiseMinor.getAction().actionPerformed(null);
                } else {
                    DemoAlarmViewPanel.this.myRaiseWarning.getAction().actionPerformed(null);
                }
                ++this.counter;
                if (this.counter == 1000) {
                    DemoAlarmViewPanel.this.myTimer.stop();
                }
            }
        };
        this.myTimer = new Timer(1000, al);
    }

    private void raiseCustomAlarm(int severity, long code, Calendar activeTime, String description, String source, String application, boolean activeState) {
        this.myLatestAlarm = new PAlarmEntry(severity, code, activeTime, description, source, application, activeState);
        this.myLatestAlarm.setHelpRequestId("MY_CUSTOM_ALARM");
        this.myAlarmService.raiseAlarm(this.myLatestAlarm);
    }

    private Action getCustomComponentAction() {
        AbstractAction a = new AbstractAction(null, new ImageIcon(DemoAlarmViewPanel.class.getResource("/com/nokia/em/poseidon/demos/res/Exit_Normal.gif"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                PAlarmEntry alarm = new PAlarmEntry(0, 1L, Calendar.getInstance(), Calendar.getInstance(), "My Custom Button Alarm", "My Custom Button", "CUSTOM_ALARM", "MyApplication", true, 1, 1);
                DemoAlarmViewPanel.this.myAlarmService.raiseAlarm(alarm);
            }
        };
        return a;
    }

    @Override
    public void alarmReceived(Object alarm) {
        if ("Real Network Element".equals(((PAlarmEntry)alarm).getSource())) {
            this.myAlarmService.raiseAlarm((PAlarmEntry)alarm);
        } else {
            JOptionPane.showMessageDialog(this.mySplitPane, "Broadcast alarm received '" + ((PAlarmEntry)alarm).getDescription() + "' but it's not for this app. Ignoring it.");
        }
    }

    public void alarmsReceived(List alarms) {
    }

    @Override
    public void alarmSelectedNotify(PAlarmEntry alarm) {
        if (alarm == null) {
            System.out.println("alarmSelectedNotify");
        } else {
            System.out.println("alarmSelectedNotify: " + alarm.getDescription());
        }
    }

    @Override
    public void alarmDeselectedNotify(PAlarmEntry alarm) {
        if (alarm == null) {
            System.out.println("alarmDeselectedNotify");
        } else {
            System.out.println("alarmDeselectedNotify: " + alarm.getDescription());
        }
    }

    @Override
    public void showAlarmHistory(boolean show) {
        System.out.println("showAlarmHistory: " + show);
    }

    public String getSiteName() {
        return "My Site";
    }

    @Override
    public void switchAndHighlightSource(PAlarmEntry alarm) {
        System.out.println("switchAndHighlightSource " + alarm.getDescription());
    }

    @Override
    public void filteringCriteriaChangedNofity(PFilteringCriteria criteria) {
        System.out.println("filteringCriteriaChangedNofity");
    }

    private static class CustomAction
    extends AbstractAction {
        private CustomAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("Alarm specific custom action performed");
        }
    }
}

