/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.i18n;

import com.nokia.em.poseidon.frameworks.i18n.ConfigurationFileParsingException;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.I18nConfigurator;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.gui.common.file.AccessoryFileChooser;
import com.nokia.em.poseidon.gui.common.file.FileChooserBase;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DemoI18nView
extends PPanel {
    private final Locale[] myLocaleList = new Locale[]{new Locale("en", "US"), new Locale("fi", "FI"), Locale.CANADA_FRENCH, new Locale("sp", "SP")};
    private Localizer myLocalizer;
    private PPanel myContentPanel;
    private final PLabel myConfigIconLabel;
    private final PLabel myConfigLabel = new PLabel();
    private PComboBox myConfigCombo;
    private JTextArea myTextArea;
    private JButton myDialogButton;
    private JButton myFileChooserButton;
    private JDialog myDialog;
    private FileChooserBase myFileChooser;

    public DemoI18nView() {
        this.myConfigIconLabel = new PLabel();
        this.myTextArea = new JTextArea();
        this.myConfigLabel.setName("ConfigLabel");
        this.myConfigIconLabel.setName("ConfigIcon");
        this.myLocalizer = LocalizerRegistry.lookup("swing");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.createContentPanel(), gbc);
        Locale loc = this.myLocaleList[0];
        ResourceBundle cc = I18n.getI18n().getBundle("App", loc);
        this.myLocalizer.setResourceBundle(cc);
        this.myLocalizer.localizeObject(this.myConfigIconLabel);
        this.myLocalizer.localizeObject(this.myConfigLabel);
        this.myLocalizer.localizeObject(this.myTextArea);
        this.myLocalizer.localizeObject(this.myFileChooserButton);
        this.myLocalizer.localizeObject(this.myDialogButton);
    }

    private Component createContentPanel() {
        ExtendedGridBagConstraints gbc = new ExtendedGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 0.1;
        gbc.insets = new Insets(5, 20, 5, 20);
        gbc.anchor = 16;
        this.myContentPanel = new PPanel();
        this.myContentPanel.setLayout(new GridBagLayout());
        this.myContentPanel.add((Component)new PLabel("Configuration file locale data:"), gbc);
        ++gbc.gridx;
        this.myConfigCombo = new PComboBox(this.myLocaleList);
        this.myConfigCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                DemoI18nView.this.updateToLocale();
            }
        });
        this.myContentPanel.add((Component)this.myConfigCombo, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.myContentPanel.add((Component)this.myConfigLabel, gbc);
        ++gbc.gridx;
        this.myContentPanel.add((Component)this.myConfigIconLabel, gbc);
        gbc.weighty = 0.7;
        this.myTextArea.setName("TextScrollPane");
        this.myTextArea.setLineWrap(true);
        this.myTextArea.setEditable(false);
        JScrollPane pan = new JScrollPane(this.myTextArea);
        pan.setVerticalScrollBarPolicy(20);
        gbc.weightx = 0.1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.fill = 2;
        pan.setPreferredSize(new Dimension(300, 300));
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        this.myContentPanel.add((Component)pan, gbc);
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        this.myDialogButton = new JButton("Show Dialog");
        this.myDialogButton.setName("DialogButton");
        this.myDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DemoI18nView.this.myDialog == null) {
                    DemoI18nView.this.createAndShowDialog();
                } else {
                    DemoI18nView.this.myDialog.setVisible(true);
                }
            }
        });
        this.myFileChooserButton = new JButton("Open File Chooser");
        this.myFileChooserButton.setName("FileChooserButton");
        this.myFileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DemoI18nView.this.createAndShowFileChooser();
            }
        });
        gbc.weighty = 0.1;
        this.myContentPanel.add((Component)this.myDialogButton, gbc);
        ++gbc.gridx;
        this.myContentPanel.add((Component)this.myFileChooserButton, gbc);
        return this.myContentPanel;
    }

    protected void createAndShowDialog() {
        this.myDialog = new JDialog();
        this.myDialog.setName("OkDialog");
        this.myDialog.setLayout(new GridBagLayout());
        JLabel label = new JLabel("");
        label.setName("OkDialogLabel");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.9;
        this.myDialog.add((Component)label, gbc);
        JButton okbutton = new JButton();
        okbutton.setName("CloseButton");
        ++gbc.gridy;
        gbc.weighty = 0.1;
        this.myDialog.add((Component)okbutton, gbc);
        okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DemoI18nView.this.myDialog.dispose();
                DemoI18nView.this.myDialog = null;
            }
        });
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myLocalizer.getResourceBundle());
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this.myDialog));
        this.myDialog.setSize(200, 70);
        this.myDialog.setLocationRelativeTo(this.myDialogButton);
        this.myDialog.setVisible(true);
        this.myDialog.setResizable(false);
    }

    protected void createAndShowFileChooser() {
        this.myFileChooser = new AccessoryFileChooser();
        this.myFileChooser.setName("MyFileChooser");
        this.myFileChooser.setSettingsKey("i18nFileChooser");
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myLocalizer.getResourceBundle());
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this.myFileChooser));
        this.myFileChooser.showOpenDialog(this.myFileChooserButton);
    }

    private void updateToLocale() {
        Locale loc = this.myConfigCombo.getSelectedItem() != null ? this.myLocaleList[this.myConfigCombo.getSelectedIndex()] : Locale.getDefault();
        try {
            I18nConfigurator.getI18nConfigurator().loadConfiguration("/com/nokia/em/poseidon/config/poseidon_i18n.xml");
        }
        catch (ConfigurationFileParsingException e) {
            e.printStackTrace();
        }
        ResourceBundle cc = I18n.getI18n().getBundle("App", loc);
        this.myLocalizer.setResourceBundle(cc);
        this.myLocalizer.localizeObject(this.myConfigIconLabel);
        this.myLocalizer.localizeObject(this.myConfigLabel);
        this.myLocalizer.localizeObject(this.myTextArea);
        this.myLocalizer.localizeObject(this.myFileChooserButton);
        this.myLocalizer.localizeObject(this.myDialogButton);
        this.validate();
    }
}

