/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.license;

import com.nokia.em.poseidon.demos.components.license.DemoLicenseView;
import com.nokia.em.poseidon.gui.licence.PLicenceChangeListener;
import com.nokia.em.poseidon.gui.licence.PLicenceController;
import com.nokia.em.poseidon.gui.licence.PLicenceValidationMessage;
import com.nokia.em.poseidon.gui.licence.PLicenceValidator;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceMediator;
import com.nokia.em.poseidon.services.licence.PLicenceParser;
import com.nokia.widgets.progress.models.ProgressBarModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Timer;

public final class DemoLicenceMediator
implements PLicenceMediator,
ActionListener {
    private static DemoLicenceMediator instance;
    private List myLicences = new ArrayList();
    private Timer myTimer;
    private PLicenceChangeListener myLicenceChangeListener;
    private boolean myIsUploadSupported;
    private boolean myIsDownloadSupported;
    private boolean myIsDeleteSupported;
    private boolean myIsActivateSupported;
    private boolean myIsDeactivateSupported;
    private boolean myIsServerSupported;
    private String myNeName;
    private String myNeId;
    DemoLicenseView myView;

    private DemoLicenceMediator() {
    }

    private void fillLicence(PLicence l, String s) {
        l.setStatus(PLicence.LICENCE_STATUS.ACTIVE);
        l.setCapacity(1000L);
        l.setCustomerId("My Customer ID");
        l.setCustomerName("My Customer");
        l.setElementType("MyElement");
        Calendar starttime_cal = Calendar.getInstance();
        starttime_cal.set(2000, 0, 1, 12, 0, 0);
        l.setStartTime(starttime_cal);
        l.setDownloadTime(starttime_cal);
        Vector<String> v = new Vector<String>();
        v.add(0, "My Target ID");
        l.setElementCodes(v);
        Calendar endtime_calendar = Calendar.getInstance();
        endtime_calendar.set(2020, 0, 1, 1, 0, 0);
        l.setEndTime(endtime_calendar);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(String.valueOf(s) + " Subfeature Code", String.valueOf(s) + " Subfeature");
        m.put(String.valueOf(s) + " Code", s);
        l.setFeatureData(m);
        l.setFileId(String.valueOf(s) + ".xml");
        l.setLicenceCode("A123456");
        l.setLicenceName("My " + s);
        l.setOrderId("#123");
        l.setSerialNumber("ABC123");
    }

    public static DemoLicenceMediator getInstance() {
        if (instance == null) {
            instance = new DemoLicenceMediator();
        }
        return instance;
    }

    public void setVisible() {
        PLicenceController myLicenceController = new PLicenceController();
        this.myTimer = new Timer(1500, this);
        this.myTimer.start();
        myLicenceController.setTargetId(this.myNeId);
        myLicenceController.setManagedElementName(this.myNeName);
        myLicenceController.initView();
    }

    public void setView(DemoLicenseView view) {
        this.myView = view;
    }

    @Override
    public void activateLicences(List<PLicence> licences) {
        this.myView.updateReceiver("Activate Licences");
        this.myLicenceChangeListener.activatingCompleted();
        for (PLicence lic : licences) {
            lic.setStatus(PLicence.LICENCE_STATUS.ACTIVE);
        }
        this.myView.updateTransmitter("Licences activated");
    }

    @Override
    public void addLicenceChangeListener(PLicenceChangeListener listener) {
        this.myLicenceChangeListener = listener;
        this.myLicenceChangeListener.addLicenceFileValidator(new DefaultLicenceFileValidator());
    }

    @Override
    public boolean[] areOperationsSupported() {
        return new boolean[]{this.myIsActivateSupported, this.myIsDeactivateSupported, this.myIsDeleteSupported, this.myIsUploadSupported};
    }

    @Override
    public void deactivateLicences(List<PLicence> licences) {
        this.myView.updateReceiver("Deactivate licences");
        this.myLicenceChangeListener.deactivatingCompleted();
        for (PLicence lic : licences) {
            lic.setStatus(PLicence.LICENCE_STATUS.INACTIVE);
        }
        this.myView.updateTransmitter("Licences Deactivated");
    }

    @Override
    public void deleteLicence(List<PLicence> licences, final ProgressBarModel progressModel) {
        this.myView.updateReceiver("Delete licences");
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoLicenceMediator.this.myLicenceChangeListener.deleteCompleted();
                DemoLicenceMediator.this.myView.updateTransmitter("Licences deleted");
                progressModel.setProperty("progresstext", "Licence Deleted");
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public void downloadLicence(PLicence licence, final ProgressBarModel model) {
        this.myView.updateReceiver("Download licencee " + licence.getFileId());
        Timer timer = new Timer(75, new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.i >= 100) {
                    DemoLicenceMediator.this.myLicenceChangeListener.downloadingCompleted();
                    DemoLicenceMediator.this.myView.updateTransmitter("Licence downloaded");
                    Timer t = (Timer)e.getSource();
                    t.stop();
                    model.setProperty("progresstext", "Licence Downloaded");
                }
                ++this.i;
            }
        });
        timer.setRepeats(true);
        timer.start();
    }

    @Override
    public String getElementId() {
        return this.myNeId;
    }

    @Override
    public String getElementType() {
        return this.myNeName;
    }

    @Override
    public boolean isActivateSupported() {
        return this.myIsActivateSupported;
    }

    @Override
    public boolean isDeactivateSupported() {
        return this.myIsDeactivateSupported;
    }

    @Override
    public boolean isDeleteSupported() {
        return this.myIsDeleteSupported;
    }

    @Override
    public boolean isLicenceRemovedInUpload() {
        return this.myIsUploadSupported;
    }

    @Override
    public boolean isUploadSupported() {
        return this.myIsUploadSupported;
    }

    @Override
    public boolean remoteServerVisible() {
        return this.myIsServerSupported;
    }

    @Override
    public void requestLicences() {
        this.myView.updateReceiver("Licences requested");
        PLicence l1 = new PLicence();
        this.fillLicence(l1, "Feature.X");
        this.myLicences.add(l1);
        PLicence l2 = new PLicence();
        this.fillLicence(l2, "Feature.Y");
        this.myLicences.add(l2);
    }

    @Override
    public void uploadLicences(List<PLicence> licences, ProgressBarModel model) {
        this.myView.updateReceiver("Upload licences");
        this.myLicenceChangeListener.uploadingCompleted(licences);
        model.setProperty("progresstext", "Licence Uploaded");
        this.myView.updateTransmitter("Licences uploaded");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.myTimer.stop();
        this.myLicenceChangeListener.addLicences(this.myLicences);
        this.myView.updateTransmitter("Licences send");
    }

    protected void setUploadSupported(boolean supported) {
        this.myIsUploadSupported = supported;
    }

    protected void setDownloadSupported(boolean supported) {
        this.myIsDownloadSupported = supported;
    }

    public boolean isDownloadSupported() {
        return this.myIsDownloadSupported;
    }

    protected void setDeleteSupported(boolean supported) {
        this.myIsDeleteSupported = supported;
    }

    protected void setActivateSupported(boolean supported) {
        this.myIsActivateSupported = supported;
    }

    protected void setDeactivateSupported(boolean supported) {
        this.myIsDeactivateSupported = supported;
    }

    protected void setServerSupported(boolean supported) {
        this.myIsServerSupported = supported;
    }

    protected void setNeName(String name) {
        this.myNeName = name;
    }

    protected void setNeId(String id) {
        this.myNeId = id;
    }

    private static class DefaultLicenceFileValidator
    implements PLicenceValidator {
        private static final int FILENAME_LENGTH = 8;
        private static final String XML_FILE_SUFFIX = ".XML";

        private DefaultLicenceFileValidator() {
        }

        @Override
        public PLicenceValidationMessage validateLicence(File licenceFile) {
            try {
                PLicence lic = PLicenceParser.parse(licenceFile);
                if (lic.getSupplementaryInfo() != null && lic.getAdditionalInfo() != null) {
                    return new PLicenceValidationMessage("Pool Licence", "You cannot use BTS Site Manager to install pool licences to BTS");
                }
                if (!this.accept(licenceFile)) {
                    return new PLicenceValidationMessage("Invalid name", "Selected file name is not valid for licence files.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private boolean accept(File file) {
            boolean secondCharIsLetterAtoZ;
            boolean firstCharIsLetterAtoZ;
            String fileName = file.getName().toUpperCase();
            if (!fileName.endsWith(XML_FILE_SUFFIX)) {
                return false;
            }
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(XML_FILE_SUFFIX));
            if (fileNameWithoutExtension.length() != 8) {
                return false;
            }
            char firstCharInFileName = fileNameWithoutExtension.charAt(0);
            boolean bl = firstCharIsLetterAtoZ = firstCharInFileName >= 'A' && firstCharInFileName <= 'Z';
            if (!firstCharIsLetterAtoZ) {
                return false;
            }
            char secondCharInFileName = fileNameWithoutExtension.charAt(1);
            boolean bl2 = secondCharIsLetterAtoZ = secondCharInFileName >= 'A' && secondCharInFileName <= 'Z';
            if (secondCharIsLetterAtoZ) {
                int index = 2;
                while (index < fileNameWithoutExtension.length()) {
                    char nextChar = fileNameWithoutExtension.charAt(index);
                    if (!Character.isDigit(nextChar)) {
                        return false;
                    }
                    ++index;
                }
                return true;
            }
            if (Character.isDigit(secondCharInFileName)) {
                String secondPlusThirdCharInFileName = fileNameWithoutExtension.substring(1, 3);
                try {
                    int weekNumber = Integer.parseInt(secondPlusThirdCharInFileName);
                    if (weekNumber >= 1 && weekNumber <= 53) {
                        int index = 3;
                        while (index < fileNameWithoutExtension.length()) {
                            char nextChar = fileNameWithoutExtension.charAt(index);
                            if (!Character.isDigit(nextChar)) {
                                return false;
                            }
                            ++index;
                        }
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        }
    }
}

