/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.license;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.components.license.DemoLicenceMediator;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceListener;
import com.nokia.em.poseidon.services.licence.PLicenceService;
import com.nokia.em.poseidon.util.timer.TimerService;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DemoLicenseView
extends JPanel
implements PLicenceListener {
    private JCheckBox mySupportUpload;
    private JCheckBox mySupportDownload;
    private JCheckBox mySupportDelete;
    private JCheckBox mySupportActivate;
    private JCheckBox mySupportDeactivate;
    private JCheckBox mySupportServer;
    private JTextField myNeName;
    private JTextField myNeId;
    private JComboBox myReceiver;
    private JComboBox myTransmitter;
    private boolean myEnableSWMonitoringFlag = false;

    public DemoLicenseView() {
        this.setLayout(new FlowLayout());
        this.add(this.buildUi());
        final PLicenceService l = PoseidonRuntime.getRuntime().getService(PLicenceService.class);
        TimerService.getInstance().startTimer(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.setSWMonitoringEnabled(DemoLicenseView.this.myEnableSWMonitoringFlag);
                if (DemoLicenseView.this.myEnableSWMonitoringFlag) {
                    DemoLicenseView.this.myEnableSWMonitoringFlag = false;
                } else {
                    DemoLicenseView.this.myEnableSWMonitoringFlag = true;
                }
            }
        }, 10000L, 4);
    }

    private JPanel buildUi() {
        JPanel panel = new JPanel();
        panel.setLayout(new PMatrixLayout(1));
        JButton open = new JButton("Open Licence Management");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DemoLicenceMediator mediator = DemoLicenceMediator.getInstance();
                DemoLicenseView.this.configureMediator(mediator);
                PLicenceService l = PoseidonRuntime.getRuntime().getService(PLicenceService.class);
                l.addLicenceListener(DemoLicenseView.this);
                l.addMediator(DemoLicenceMediator.getInstance());
                DemoLicenceMediator.getInstance().setView(DemoLicenseView.this);
                DemoLicenceMediator.getInstance().setVisible();
            }
        });
        panel.add(PLabel.createTitle("Configure Licence Mediator:"));
        JPanel configPanel = new JPanel();
        configPanel.setLayout(new PMatrixLayout(4));
        JLabel supportUpdate = new JLabel("Support Upload:");
        JLabel supportDownload = new JLabel("Support Download:");
        JLabel supportDelete = new JLabel("Support Delete:");
        JLabel supportActivate = new JLabel("Support Activate:");
        JLabel supportDeactivate = new JLabel("Support Deactivate:");
        JLabel supportServer = new JLabel("Support FTP Server:");
        this.mySupportUpload = new JCheckBox();
        this.mySupportUpload.setSelected(true);
        this.mySupportDownload = new JCheckBox();
        this.mySupportDownload.setSelected(true);
        this.mySupportDelete = new JCheckBox();
        this.mySupportDelete.setSelected(true);
        this.mySupportActivate = new JCheckBox();
        this.mySupportActivate.setSelected(true);
        this.mySupportDeactivate = new JCheckBox();
        this.mySupportDeactivate.setSelected(true);
        this.mySupportServer = new JCheckBox();
        JLabel neName = new JLabel("NE Name:");
        JLabel neId = new JLabel("NE Id:");
        this.myNeName = new JTextField("MyElement");
        this.myNeId = new JTextField("12345");
        configPanel.add(supportUpdate);
        configPanel.add(this.mySupportUpload);
        configPanel.add(supportDownload);
        configPanel.add(this.mySupportDownload);
        configPanel.add(supportDelete);
        configPanel.add(this.mySupportDelete);
        configPanel.add(supportActivate);
        configPanel.add(this.mySupportActivate);
        configPanel.add(supportDeactivate);
        configPanel.add(this.mySupportDeactivate);
        configPanel.add(supportServer);
        configPanel.add(this.mySupportServer);
        configPanel.add(neName);
        configPanel.add(this.myNeName);
        configPanel.add(neId);
        configPanel.add(this.myNeId);
        panel.add(configPanel);
        panel.add(open);
        panel.add(this.createNePanel());
        return panel;
    }

    private JPanel createNePanel() {
        JPanel nePanel = new JPanel();
        nePanel.setLayout(new PMatrixLayout(1));
        nePanel.add(PLabel.createTitle("Simulates element behaviour:"));
        this.myReceiver = new JComboBox();
        this.myReceiver.addItem("Actions arrived to element.");
        this.myTransmitter = new JComboBox();
        this.myTransmitter.addItem("Actions send by element.");
        nePanel.add(PLabel.createSystemText("Actions arrived to element."));
        nePanel.add(this.myReceiver);
        nePanel.add(PLabel.createSystemText("Actions send by element."));
        nePanel.add(this.myTransmitter);
        return nePanel;
    }

    protected void updateTransmitter(String message) {
        this.myTransmitter.insertItemAt(String.valueOf(message) + " " + this.getTime(), 0);
        this.myTransmitter.setSelectedIndex(0);
    }

    protected void updateReceiver(String message) {
        this.myReceiver.insertItemAt(String.valueOf(message) + " " + this.getTime(), 0);
        this.myReceiver.setSelectedIndex(0);
    }

    private String getTime() {
        Calendar calendar = Calendar.getInstance();
        String time = " (Time->" + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + ")";
        return time;
    }

    private void configureMediator(DemoLicenceMediator mediator) {
        mediator.setActivateSupported(this.mySupportActivate.isSelected());
        mediator.setDeactivateSupported(this.mySupportDeactivate.isSelected());
        mediator.setUploadSupported(this.mySupportUpload.isSelected());
        mediator.setDownloadSupported(this.mySupportDownload.isSelected());
        mediator.setDeleteSupported(this.mySupportDelete.isSelected());
        mediator.setNeId(this.myNeId.getText());
        mediator.setNeName(this.myNeName.getText());
        mediator.setServerSupported(this.mySupportServer.isSelected());
    }

    public void licencesUpdated(List licences) {
        this.updateReceiver("Licences updated to service. (Notify)");
        PLicenceService l = PoseidonRuntime.getRuntime().getService(PLicenceService.class);
        System.out.println("SW monitoring enabled = " + l.isSWMonitoringEnabled());
    }

    @Override
    public void licenceDeleted(PLicence licence) {
        this.updateReceiver("Licence " + licence.getFileId() + " deleted. (Notify)");
    }

    @Override
    public void licenceDownloaded(PLicence licence) {
        this.updateReceiver("Licence " + licence.getFileId() + " downloaded. (Notify)");
    }

    @Override
    public void licenceActivated(PLicence licence) {
        this.updateReceiver("Licence " + licence.getFileId() + " activated. (Notify)");
    }

    @Override
    public void licenceDeactivated(PLicence licence) {
        this.updateReceiver("Licence " + licence.getFileId() + " deactivated. (Notify)");
    }
}

