/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.mvc;

import com.nokia.em.poseidon.demos.components.mvc.EController;
import com.nokia.em.poseidon.demos.components.mvc.ESwingModel;
import com.nokia.em.poseidon.frameworks.model.Model;
import com.nokia.em.poseidon.frameworks.model.ModelObserver;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.text.NumberRangeValidator;
import com.nokia.widgets.text.PTextField;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class EView
extends JDialogViewBase
implements ModelObserver {
    private final ESwingModel mySwingModel;
    private PLabel myResultLabel;

    public EView(Controller controller, ESwingModel swingModel) {
        super(controller);
        this.mySwingModel = swingModel;
        this.buildUI();
        this.mySwingModel.addObserver(this);
    }

    private void buildUI() {
        PLabel comboTitle = new PLabel("Repeat:");
        PLabel delayTitle = new PLabel("Delay:");
        PLabel resultTitle = new PLabel("Result:");
        this.myResultLabel = new PLabel();
        PTextField delayField = new PTextField();
        delayField.setDocument(this.mySwingModel.getDelayDoc());
        delayField.addValidationListener(new NumberRangeValidator(0.0, 10.0));
        JButton randomButton = new JButton("Roll");
        randomButton.addActionListener(((EController)this.getController()).getRollAction());
        PComboBox repeatCombo = new PComboBox(this.mySwingModel.getRepeatSelectionModel());
        this.setTitle("MVC Demo");
        PPanel mainPanel = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints c = new ExtendedGridBagConstraints();
        c.ipadx = 75;
        mainPanel.add((Component)delayTitle, c);
        c.nextColumn();
        c.fillHorizontal();
        mainPanel.add((Component)delayField, c);
        c.nextRow();
        mainPanel.add((Component)comboTitle, c);
        c.nextColumn();
        mainPanel.add((Component)repeatCombo, c);
        c.nextRow();
        mainPanel.add((Component)resultTitle, c);
        c.nextColumn();
        mainPanel.add((Component)this.myResultLabel, c);
        c.nextRow();
        c.nextColumn();
        c.weightx = 1.0;
        c.weighty = 1.0;
        mainPanel.add((Component)randomButton, c);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void modelUpdated(Model model) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                EView.this.myResultLabel.setText(EView.this.mySwingModel.getTextValue());
            }
        };
        SwingUtilities.invokeLater(run);
    }
}

