/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.components.treeview;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.gui.treeview.PAbstractNode;
import com.nokia.em.poseidon.gui.treeview.PTableCellWrapper;
import com.nokia.em.poseidon.gui.treeview.PTableLeafNode;
import com.nokia.em.poseidon.gui.treeview.PTitleNode;
import com.nokia.em.poseidon.gui.treeview.PTreeViewModel;
import com.nokia.widgets.ClientProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public class DemoTreeViewModel
implements PTreeViewModel,
ActionListener {
    private PTitleNode[] myNodes = new PTitleNode[5];
    private Timer myTimer;

    public DemoTreeViewModel() {
        PTitleNode firstSubNode = this.buildNode("First level sub node", this.buildNodeContent(), 1);
        PTitleNode secondSubNode = this.buildNode("Second level sub node", this.buildNodeContent(), 1);
        firstSubNode.addChild(secondSubNode);
        this.myNodes[0] = this.buildNode("First node", null, 0);
        this.myNodes[1] = this.buildNode("Second node", this.buildNodeContent(), 0);
        this.myNodes[2] = this.buildNode("Third node", this.buildNodeContent(), 0);
        this.myNodes[2].addChild(firstSubNode);
        this.myNodes[3] = this.buildNode("Fourth node", this.buildEmptyTableNodeContent(), 0);
        this.myNodes[4] = this.buildNode("Fifth node", this.buildEmptyLabelNodeContent(), 0);
        this.myNodes[4].addChild(this.buildEmptyTableNodeContent());
        this.myNodes[4].addChild(this.buildEmptyLabelNodeContent());
        this.myNodes[4].addChild(this.buildEmptyTableNodeContent());
        this.myNodes[4].setDataState(2, "Data unavailable", null, true);
        this.myNodes[3].setDataState(2, "Data unavailable", null, true);
        this.myTimer = new Timer(50000, this);
    }

    private PTitleNode buildNode(String text, PAbstractNode leaf, int level) {
        ImageIcon icon = I18n.getI18n().getBaseBundle().getImageIcon("WarningAlarm_Icon");
        PTitleNode node = new PTitleNode(text, true, level, icon);
        if (leaf != null) {
            node.addChild(leaf);
        }
        node.setPrintable(true);
        node.setSaveAvailability(true);
        return node;
    }

    private PTableLeafNode buildEmptyTableNodeContent() {
        PTableLeafNode leaf = new PTableLeafNode(true);
        Object[] headers = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        leaf.setHeaders(headers);
        return leaf;
    }

    private PTableLeafNode buildEmptyLabelNodeContent() {
        PTableLeafNode leaf = new PTableLeafNode(true);
        Object[][] objectArrayArray = new Object[2][];
        Object[] objectArray = new Object[2];
        objectArray[0] = "BTS IP:";
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "TRS IP:";
        objectArrayArray[1] = objectArray2;
        Object[][] data = objectArrayArray;
        int i = 0;
        while (i < data[0].length) {
            Vector<Object> dataRow = new Vector<Object>();
            int j = 0;
            while (j < data.length) {
                if (j == 0) {
                    dataRow.add(new PTableCellWrapper(data[i][j].toString(), ClientProperties.LABEL_SYSTEM_TEXT));
                } else {
                    dataRow.add(data[i][j]);
                }
                ++j;
            }
            leaf.addRow(dataRow);
            ++i;
        }
        leaf.setShowHeaders(false);
        return leaf;
    }

    private PTableLeafNode buildNodeContent() {
        PTableLeafNode leaf = new PTableLeafNode("Special title for table", true);
        leaf.setShowTitle(true);
        Object[] headers = new String[]{"First Name", "Last Name", "Sport", "# of Years", "Vegetarian"};
        leaf.setHeaders(headers);
        Object[][] data = new Object[][]{{"Mary", "Campione", "Snowboarding", 5, Boolean.FALSE}, {"Alison", "Huml", "Rowing", 3, Boolean.TRUE}, {"Kathy", "Walrath", "Knitting", 2, Boolean.FALSE}, {"Sharon", "Zakhour", "Speed reading", 20, Boolean.TRUE}, {"Philip", "Milne", "Pool", 10, Boolean.FALSE}};
        int i = 0;
        while (i < data[0].length) {
            Vector<String> dataRow = new Vector<String>();
            int j = 0;
            while (j < data.length) {
                dataRow.add(data[i][j].toString());
                ++j;
            }
            leaf.addRow(dataRow);
            ++i;
        }
        return leaf;
    }

    @Override
    public void initialise(Object[] constraints) {
    }

    @Override
    public PAbstractNode[] getMainLevelNodes() {
        return this.myNodes;
    }

    @Override
    public void clearModel() {
        if (this.myTimer != null) {
            this.myTimer.stop();
        }
        this.myTimer = null;
        int i = 0;
        while (i < this.myNodes.length) {
            this.myNodes[i].clear();
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myNodes[0].getDataState() == 1) {
            this.myNodes[0].setDataState(2, "Data ok, parsing", I18n.getI18n().getBaseBundle().getImageIcon("ProgressTask.ongoing"));
        } else if (this.myNodes[0].getDataState() == 2) {
            this.myNodes[0].setDataState(0, "", I18n.getI18n().getBaseBundle().getImageIcon("WarningAlarm_Icon"));
            this.myNodes[0].removeChildren();
            this.myNodes[0].addChild(this.buildNodeContent());
        } else if (this.myNodes[0].getDataState() == 0) {
            this.myNodes[0].removeChildren();
            this.myNodes[0].setDataState(1, "Reading", I18n.getI18n().getBaseBundle().getImageIcon("ProgressTask.ongoing"));
        }
    }
}

