/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.referenceapp;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.referenceapp.DemoAppStatusEvent;
import com.nokia.em.poseidon.demos.referenceapp.ui.MainController;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationStatus;
import com.nokia.em.poseidon.services.event.EventService;
import com.nokia.em.poseidon.util.SingletonResetter;
import javax.swing.SwingUtilities;

public class ReferenceApplication
implements Application {
    protected AppDescription myDescription = new AppDescription("Reference Application", "Reference Application Public Name");
    protected MainController myMainController;
    protected EventService myEventService;

    @Override
    public AppDescription getDescription() {
        return this.myDescription;
    }

    @Override
    public void initialize() {
        this.myEventService = PoseidonRuntime.getRuntime().getService(EventService.class);
        this.myEventService.sendAsynchronousEvent(new DemoAppStatusEvent(this, ApplicationStatus.INITIALIZE));
    }

    @Override
    public void startUp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReferenceApplication.this.myMainController = new MainController();
                ReferenceApplication.this.myEventService.sendAsynchronousEvent(new DemoAppStatusEvent(this, ApplicationStatus.STARTUP));
            }
        });
    }

    @Override
    public void ready() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReferenceApplication.this.myMainController.setVisible(true);
                ReferenceApplication.this.myEventService.sendAsynchronousEvent(new DemoAppStatusEvent(this, ApplicationStatus.READY));
            }
        });
    }

    @Override
    public void exit() {
        this.myMainController.destroy();
        this.myEventService.sendAsynchronousEvent(new DemoAppStatusEvent(this, ApplicationStatus.EXIT));
    }

    @Override
    public void shutDown() {
        SingletonResetter.reset(I18n.getI18n());
        this.myEventService.sendAsynchronousEvent(new DemoAppStatusEvent(this, ApplicationStatus.SHUTDOWN));
    }
}

