/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.referenceapp.service;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.demos.referenceapp.service.DemoService;
import com.nokia.em.poseidon.demos.referenceapp.service.DemoServiceMediator;
import com.nokia.em.poseidon.demos.referenceapp.service.DemoserviceListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class DemoServiceImpl
implements DemoService {
    protected List<DemoserviceListener> myListeners;
    protected Timer myTimer;

    @Override
    public void start() {
        this.myListeners = new CopyOnWriteArrayList<DemoserviceListener>();
        this.myTimer = new Timer();
        this.myTimer.schedule((TimerTask)new Task(), 0L, 5000L);
    }

    @Override
    public void stop() {
        this.myTimer.cancel();
    }

    @Override
    public void addListener(DemoserviceListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(DemoserviceListener listener) {
        this.myListeners.remove(listener);
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        @Override
        public void run() {
            for (DemoServiceMediator mediator : PoseidonRuntime.getRuntime().getObjects(DemoServiceMediator.class)) {
                for (DemoserviceListener listener : DemoServiceImpl.this.myListeners) {
                    listener.dataUpdated(mediator.getDescription());
                }
            }
        }
    }
}

