/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.referenceapp.ui;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.logging.LoggerPanel;
import com.nokia.widgets.navigation.NavigationPanel;
import com.nokia.widgets.navigation.ViewSwitcher;
import java.awt.Component;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

public class MainView
extends JPanelViewBase {
    protected static final String MENU_CONF = "/com/nokia/em/poseidon/demos/referenceapp/menu.xml";
    protected UserInterface myUI;
    protected ResourceBundle myResourceBundle;
    protected ViewSwitcher mySwitcher;
    protected NavigationPanel myNavigationPanel;

    public MainView(Controller ctrl) {
        super(ctrl);
        this.buildUI();
    }

    private void buildUI() {
        this.myUI = PoseidonRuntime.getRuntime().getService(UserInterface.class);
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myUI.getFrame().setTitle(this.myResourceBundle.getString("ReferenceApplication.name"));
        this.myNavigationPanel = new NavigationPanel();
        this.myUI.getFrame().add((Component)this.myNavigationPanel, "West");
        this.mySwitcher = new ViewSwitcher();
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.mySwitcher.getPanel());
        LoggerPanel loggerPanel = new LoggerPanel(new Logger[]{Logger.getRootLogger()});
        loggerPanel.startLogging();
        splitPane.setBottomComponent(loggerPanel);
        splitPane.setDividerLocation((int)((double)this.myUI.getFrame().getSize().height * 0.7));
        this.myUI.getFrame().add((Component)splitPane, "Center");
        this.myUI.getToolBar().setShowToolButtonTexts(true);
        this.myUI.loadUIConfiguration(this.getClass().getResource(MENU_CONF));
    }

    public void setStatusView(Component view) {
        this.myUI.getFrame().add(view, "South");
    }

    public void setSubView(Component view, String name) {
        this.myNavigationPanel.add(this.mySwitcher.createActionFor(view, name), this.myNavigationPanel.getButtons().size() == 0);
        Localizer myLocalizer = LocalizerRegistry.lookup("swing");
        myLocalizer.localizeObject(this.myNavigationPanel.getButton(name));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.myUI.setVisible(visible);
    }
}

