/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.referenceapp.ui;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.swing.JPanelViewBase;
import com.nokia.em.poseidon.plugin.application.ApplicationStatus;
import com.nokia.widgets.Statusbar;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusView
extends JPanelViewBase {
    protected JLabel myInitializeLabel;
    protected JLabel myStartupLabel;
    protected JLabel myReadyLabel;
    protected JLabel myExitLabel;
    protected JLabel myShutDownLabel;
    protected ResourceBundle myBundle;

    public StatusView(Controller controller) {
        super(controller);
        this.buildUI();
    }

    public void buildUI() {
        this.setLayout(new BorderLayout());
        this.myBundle = I18n.getI18n().getBundle(this.getClass());
        Statusbar status = new Statusbar();
        JPanel statusPanel = status.getUserArea();
        statusPanel.add(new JLabel(this.myBundle.getString("StatusController.applicationStatus")));
        this.myInitializeLabel = new JLabel(this.myBundle.getString("StatusController.initialize"), this.myBundle.getImageIcon("ProgressTask.upcoming"), 2);
        statusPanel.add(Box.createHorizontalStrut(10));
        statusPanel.add(this.myInitializeLabel);
        this.myStartupLabel = new JLabel(this.myBundle.getString("StatusController.startup"), this.myBundle.getImageIcon("ProgressTask.upcoming"), 2);
        statusPanel.add(Box.createHorizontalStrut(5));
        statusPanel.add(this.myStartupLabel);
        this.myReadyLabel = new JLabel(this.myBundle.getString("StatusController.ready"), this.myBundle.getImageIcon("ProgressTask.upcoming"), 2);
        statusPanel.add(Box.createHorizontalStrut(5));
        statusPanel.add(this.myReadyLabel);
        this.myExitLabel = new JLabel(this.myBundle.getString("StatusController.exit"), this.myBundle.getImageIcon("ProgressTask.upcoming"), 2);
        statusPanel.add(Box.createHorizontalStrut(5));
        statusPanel.add(this.myExitLabel);
        this.myShutDownLabel = new JLabel(this.myBundle.getString("StatusController.shutdown"), this.myBundle.getImageIcon("ProgressTask.upcoming"), 2);
        statusPanel.add(Box.createHorizontalStrut(5));
        statusPanel.add(this.myShutDownLabel);
        this.add((Component)status, "Center");
    }

    public void showAppStatus(ApplicationStatus status) {
        switch (status) {
            case INITIALIZE: {
                this.myInitializeLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.ongoing"));
                break;
            }
            case STARTUP: {
                this.myInitializeLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myStartupLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.ongoing"));
                break;
            }
            case READY: {
                this.myInitializeLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myStartupLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myReadyLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.ongoing"));
                break;
            }
            case EXIT: {
                this.myInitializeLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myStartupLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myReadyLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myExitLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.ongoing"));
                break;
            }
            case SHUTDOWN: {
                this.myInitializeLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myStartupLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myReadyLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myExitLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.done"));
                this.myShutDownLabel.setIcon(this.myBundle.getImageIcon("ProgressTask.ongoing"));
                break;
            }
        }
    }
}

