/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.transfer;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.gui.common.file.FileChooserBase;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class ConfigPanel
extends PPanel
implements TransferListener {
    protected static final String LS = System.getProperty("line.separator");
    protected static final String TIME_STAMP_FORMAT = "[HH:mm:ss.SSS] [dd.MM.yyyy]";
    protected SimpleAttributeSet myTimeStampAttrSet;
    protected SimpleAttributeSet myBoldAttrSet;
    protected Document myEventLoggerDocument;
    protected static FileChooserBase myFileChooser = new FileChooserBase();
    protected PPanel myEventPanel;

    public ConfigPanel() {
        myFileChooser.setDialogTitle("File browser");
        this.createEventPanel();
    }

    public Component getTransferEventPanel() {
        return this.myEventPanel;
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getConfigurationView(), "Center");
    }

    protected String browseDirectory(String directory, int selectionMode) {
        myFileChooser.setFileSelectionMode(selectionMode);
        myFileChooser.setCurrentDirectory(new File(directory));
        myFileChooser.setSettingsKey("ConfigPanel.BrowseDirectory" + selectionMode);
        int returnVal = myFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            return myFileChooser.getSelectedFile().getAbsolutePath();
        }
        return directory;
    }

    protected void addComponentRow(ExtendedGridBagConstraints constraints, PPanel panel, Component ... components) {
        int origLeftInset = constraints.insets.left;
        constraints.nextRow();
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            panel.add(comp, constraints);
            constraints.setLeftInset(12);
            constraints.nextColumn();
            ++n2;
        }
        constraints.setLeftInset(origLeftInset);
    }

    @Override
    public void transferUpdated(final TransferInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object target = info.getTransferTarget();
                try {
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), new SimpleDateFormat(ConfigPanel.TIME_STAMP_FORMAT).format(new Date(System.currentTimeMillis())), ConfigPanel.this.myTimeStampAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), String.valueOf(info.getTransferStatus().toString()) + "  Target: ", ConfigPanel.this.myBoldAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), target instanceof File ? ((File)target).getName() : (target != null ? target.toString() : "null"), null);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), "  Content length: ", ConfigPanel.this.myBoldAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), String.valueOf(info.getContentLength()), null);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), "  Percentage: ", ConfigPanel.this.myBoldAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), String.valueOf(info.getTransferPercentage()), null);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), "  Protocol response code: ", ConfigPanel.this.myBoldAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), info.getProtocolResponseCode() == null ? "null" : info.getProtocolResponseCode().toString(), null);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), "  Message: ", ConfigPanel.this.myBoldAttrSet);
                    ConfigPanel.this.myEventLoggerDocument.insertString(ConfigPanel.this.myEventLoggerDocument.getLength(), String.valueOf(info.getInfoMessage()) + LS + LS, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected abstract JComponent getConfigurationView();

    private void createEventPanel() {
        this.myTimeStampAttrSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.myTimeStampAttrSet, Color.RED);
        StyleConstants.setBold(this.myTimeStampAttrSet, true);
        this.myBoldAttrSet = new SimpleAttributeSet();
        StyleConstants.setBold(this.myBoldAttrSet, true);
        JTextPane textPanel = new JTextPane();
        textPanel.setOpaque(false);
        this.myEventLoggerDocument = textPanel.getStyledDocument();
        textPanel.setEditable(false);
        JScrollPane scrolPane = new JScrollPane(textPanel);
        this.myEventPanel = new PPanel(new BorderLayout(0, 6));
        this.myEventPanel.setBorder(new EmptyBorder(6, 12, 6, 6));
        JPanel masterHeader = new JPanel(new FlowLayout(0));
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        masterHeader.add(header);
        PLabel eventLabel = new PLabel("Transfer info logging:");
        eventLabel.setLabelType(ClientProperties.LABEL_TITLE);
        header.add(eventLabel);
        header.add(Box.createVerticalStrut(6));
        JButton button = new JButton("Clear");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ConfigPanel.this.myEventLoggerDocument.remove(0, ConfigPanel.this.myEventLoggerDocument.getLength());
                }
                catch (BadLocationException er) {
                    er.printStackTrace();
                }
            }
        });
        header.add(button);
        this.myEventPanel.add((Component)masterHeader, "North");
        this.myEventPanel.add((Component)scrolPane, "Center");
    }
}

