/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.transfer;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.ftp.FileInfo;
import com.nokia.em.poseidon.comm.ftp.FtpClient;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.comm.ftp.FtpServer;
import com.nokia.em.poseidon.comm.ftp.FtpServerFactory;
import com.nokia.em.poseidon.comm.ftp.PortRange;
import com.nokia.em.poseidon.comm.ftp.ServerListener;
import com.nokia.em.poseidon.comm.ftp.ServerSession;
import com.nokia.em.poseidon.comm.ftp.UserProfile;
import com.nokia.em.poseidon.demos.transfer.ConfigPanel;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.PProgressBar;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.text.PPasswordField;
import com.nokia.widgets.text.PTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import org.apache.log4j.Logger;

public class FtpPanel
extends ConfigPanel
implements ActionListener,
ServerListener,
DocumentListener,
TreeWillExpandListener {
    private boolean myIsServer;
    private boolean myIsClientConnected;
    private FtpServer myFtpServer;
    private FtpClient myFtpClient;
    private PTextField myPortfield;
    private PTextField myDirField;
    private PTextField myUserField;
    private PTextField myPutFileField;
    private PPasswordField myPassWordField;
    private PTextField myIpField;
    private JButton myGetFileButton;
    private JButton myPutButton;
    private JButton myFileBrowseButton;
    private JButton myBrowseButton;
    private JButton myStartButton;
    private JTree myDirTree;
    private DefaultMutableTreeNode myRootNode;
    private PLabel myServerConnectLabel;
    private PPanel myFilePanel;
    private PPanel myConfigPanel;
    private PProgressBar myProgressBar;
    private Icon myStartedIcon;
    private Icon myStoppedIcon;
    private String myStartText;
    private String myStopText;
    private String myConnectText;
    private String myDisconnectText;
    private Logger myLogger;

    public FtpPanel(boolean isServer) {
        this.myIsServer = isServer;
        this.myLogger = Logger.getLogger(this.getClass());
        this.initComponents();
        this.buildUI();
    }

    private void initComponents() {
        ResourceBundle resBundle = I18n.getI18n().getBundle(this.getClass());
        this.myStartedIcon = resBundle.getImageIcon("ProgressTask.done");
        this.myStoppedIcon = resBundle.getImageIcon("ProgressTask.upcoming");
        this.myStartText = "Start server";
        this.myStopText = "Stop server";
        this.myConnectText = "Connect";
        this.myDisconnectText = "Disconnect";
        this.myPortfield = new PTextField(5);
        this.myPortfield.setText("5555");
        this.myPortfield.setMandatoryEntry(true);
        this.myPortfield.addDocumentListener(this);
        this.myDirField = new PTextField(20);
        this.myDirField.setText(System.getProperty("user.home"));
        this.myDirField.setMandatoryEntry(true);
        this.myDirField.addDocumentListener(this);
        this.myUserField = new PTextField(20);
        this.myPassWordField = new PPasswordField(19);
        this.myStartButton = new JButton(this.myIsServer ? this.myStartText : this.myConnectText);
        this.myStartButton.addActionListener(this);
        this.myServerConnectLabel = new PLabel();
        this.myServerConnectLabel.setIcon(this.myStoppedIcon);
        this.myServerConnectLabel.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.myBrowseButton = new JButton("Browse");
        this.myBrowseButton.addActionListener(this);
        if (!this.myIsServer) {
            this.myIpField = new PTextField(20);
            this.myIpField.setText("localhost");
            this.myIpField.setMandatoryEntry(true);
            this.myIpField.addDocumentListener(this);
            this.myGetFileButton = new JButton("Get selected file");
            this.myGetFileButton.addActionListener(this);
            this.myPutButton = new JButton("Upload");
            this.myPutButton.addActionListener(this);
            this.myFileBrowseButton = new JButton("Browse");
            this.myFileBrowseButton.addActionListener(this);
            this.myPutFileField = new PTextField(20);
            this.myProgressBar = new PProgressBar(0, 100);
            this.myProgressBar.setEnabled(true);
            this.myProgressBar.setStringPainted(true);
            this.myRootNode = new DefaultMutableTreeNode("Server file structure");
            this.myDirTree = new JTree(this.myRootNode, true);
            this.myDirTree.addTreeWillExpandListener(this);
        }
    }

    private Component createConfigPanel() {
        this.myConfigPanel = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        constraints.setAnchor(18);
        constraints.setBottomInset(3);
        if (!this.myIsServer) {
            this.addComponentRow(constraints, this.myConfigPanel, PLabel.createSystemText("Server IP:"), this.myIpField);
        }
        this.addComponentRow(constraints, this.myConfigPanel, PLabel.createSystemText("Port:"), this.myPortfield);
        this.addComponentRow(constraints, this.myConfigPanel, PLabel.createSystemText("User name:"), this.myUserField);
        this.addComponentRow(constraints, this.myConfigPanel, PLabel.createSystemText("Password:"));
        constraints.fillHorizontal();
        this.myConfigPanel.add((Component)this.myPassWordField, constraints);
        constraints.fillNone();
        this.addComponentRow(constraints, this.myConfigPanel, PLabel.createSystemText(this.myIsServer ? "Server directory:" : "Local directory:"), this.myDirField, this.myBrowseButton);
        PPanel startPanel = new PPanel(new BorderLayout(3, 0));
        startPanel.add((Component)this.myStartButton, "West");
        startPanel.add((Component)this.myServerConnectLabel, "Center");
        constraints.setColumnWidth(2);
        this.addComponentRow(constraints, this.myConfigPanel, startPanel);
        return this.myConfigPanel;
    }

    private Component createFilePanel() {
        this.myFilePanel = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        constraints.setAnchor(18);
        constraints.setBottomInset(3);
        constraints.setColumnWidth(4);
        JScrollPane listScroller = new JScrollPane(this.myDirTree);
        listScroller.setPreferredSize(new Dimension(400, 250));
        this.addComponentRow(constraints, this.myFilePanel, listScroller);
        constraints.setColumnWidth(1);
        constraints.setColumnWidth(2);
        this.addComponentRow(constraints, this.myFilePanel, this.myGetFileButton);
        constraints.setColumnWidth(1);
        this.addComponentRow(constraints, this.myFilePanel, PLabel.createSystemText("Upload file:"), this.myPutFileField, this.myFileBrowseButton, this.myPutButton);
        constraints.setColumnWidth(2);
        this.addComponentRow(constraints, this.myFilePanel, this.myProgressBar);
        this.enableFilePanel(false);
        return this.myFilePanel;
    }

    private void enableFilePanel(boolean enabled) {
        Component[] componentArray = this.myFilePanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c != this.myProgressBar) {
                c.setEnabled(enabled);
            }
            ++n2;
        }
    }

    private void enableConfigPanel(boolean enabled) {
        Component[] componentArray = this.myConfigPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
    }

    private void getFile() {
        if (this.myFtpClient != null) {
            this.myStartButton.setEnabled(false);
            this.enableFilePanel(false);
            this.myProgressBar.setString("Getting file...");
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.myDirTree.getSelectionPath().getLastPathComponent();
            this.myFtpClient.getFile(this.getNodePath(selectedNode), String.valueOf(this.myDirField.getText()) + System.getProperty("file.separator") + selectedNode.getUserObject(), this);
        }
    }

    private void uploadFile() {
        if (this.myFtpClient != null) {
            this.myStartButton.setEnabled(false);
            this.enableFilePanel(false);
            this.myProgressBar.setString("Uploading file to server...");
            String path = this.myPutFileField.getText();
            this.myFtpClient.putFile(path, path.substring(path.lastIndexOf(System.getProperty("file.separator")) + 1), this);
        }
    }

    private void updateServer() {
        if (this.myFtpServer != null && this.myFtpServer.isRunning()) {
            this.myFtpServer.stop();
            this.myFtpServer.removeServerListener(this);
            this.myFtpServer = null;
            this.myStartButton.setText(this.myStartText);
            this.myServerConnectLabel.setIcon(this.myStoppedIcon);
            this.enableConfigPanel(true);
        } else {
            int port = Integer.valueOf(this.myPortfield.getText());
            this.myFtpServer = FtpServerFactory.createFtpServer(new PortRange(port, port), null, this, this.myUserField.getText(), new String(this.myPassWordField.getPassword()), this.myDirField.getText(), this.myDirField.getText(), true, true);
            try {
                this.myFtpServer.start();
                this.myStartButton.setText(this.myStopText);
                this.myServerConnectLabel.setIcon(this.myStartedIcon);
                this.enableConfigPanel(false);
                this.myStartButton.setEnabled(true);
            }
            catch (FtpException e1) {
                this.myLogger.error(e1);
            }
        }
    }

    private void updateClient() {
        if (this.myFtpClient != null && this.myIsClientConnected) {
            try {
                this.myFtpClient.disconnect();
                this.myStartButton.setText(this.myConnectText);
                this.myServerConnectLabel.setIcon(this.myStoppedIcon);
                this.myIsClientConnected = false;
                this.myRootNode.removeAllChildren();
                this.myDirTree.updateUI();
                this.myProgressBar.setString("");
                this.enableFilePanel(false);
                this.enableConfigPanel(true);
            }
            catch (FtpException e) {
                this.myLogger.error(e);
            }
        } else {
            this.myFtpClient = new FtpClient();
            try {
                this.myFtpClient.login(this.myIpField.getText(), Integer.valueOf(this.myPortfield.getText()), this.myUserField.getText(), new String(this.myPassWordField.getPassword()), null);
                this.myStartButton.setText(this.myDisconnectText);
                this.myServerConnectLabel.setIcon(this.myStartedIcon);
                this.myIsClientConnected = true;
                this.enableConfigPanel(false);
                this.myStartButton.setEnabled(false);
                this.myProgressBar.setString("Getting file listing...");
                this.myRootNode.removeAllChildren();
                this.addFileNodes(this.myRootNode);
                this.myDirTree.updateUI();
                this.myProgressBar.setString("");
                this.enableFilePanel(true);
                this.myStartButton.setEnabled(true);
            }
            catch (FtpException e) {
                this.myLogger.error(e);
            }
        }
    }

    private void addFileNodes(DefaultMutableTreeNode node) {
        Collection files;
        try {
            files = this.myFtpClient.getFileList(this.getNodePath(node), null, null);
        }
        catch (FtpException e) {
            this.myLogger.error(e);
            return;
        }
        int dirCounter = 0;
        for (FileInfo f : files) {
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(f.getName(), f.isDirectory());
            if (f.getName().indexOf(46) == 0) continue;
            if (f.isDirectory()) {
                node.insert(treeNode, dirCounter++);
                continue;
            }
            node.add(treeNode);
        }
    }

    private String getNodePath(DefaultMutableTreeNode node) {
        Object[] names = node.getUserObjectPath();
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < names.length) {
            sb.append(String.valueOf(System.getProperty("file.separator")) + names[i]);
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected JComponent getConfigurationView() {
        PPanel configView = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints configConstraints = new ExtendedGridBagConstraints();
        configConstraints.setAnchor(18);
        configConstraints.setTopInset(6);
        configConstraints.setBottomInset(6);
        configView.add((Component)PLabel.createTitle(this.myIsServer ? "FTP Server Configuration" : "FTP Client Configuration"), configConstraints);
        if (!this.myIsServer) {
            configConstraints.nextColumn();
            configView.add((Component)PLabel.createTitle("Server Files"), configConstraints);
        }
        configConstraints.setBottomInset(3);
        configConstraints.setTopInset(0);
        configConstraints.nextRow();
        configView.add(this.createConfigPanel(), configConstraints);
        if (!this.myIsServer) {
            configConstraints.nextColumn();
            configView.add(this.createFilePanel(), configConstraints);
        }
        configConstraints.nextRow();
        configConstraints.setColumnWidth(0);
        configConstraints.setColumnHorizontalWeigth(1.0);
        configConstraints.setColumnVerticalWeigth(1.0);
        configConstraints.setLeftInset(0);
        configView.add((Component)new PLabel(), configConstraints);
        return configView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myStartButton) {
            if (this.myIsServer) {
                this.updateServer();
            } else {
                this.updateClient();
            }
        } else if (e.getSource() == this.myBrowseButton) {
            this.myDirField.setText(this.browseDirectory(this.myDirField.getText(), 1));
        } else if (e.getSource() == this.myFileBrowseButton) {
            this.myPutFileField.setText(this.browseDirectory(this.myPutFileField.getText(), 0));
        } else if (e.getSource() == this.myGetFileButton) {
            this.getFile();
        } else if (e.getSource() == this.myPutButton) {
            this.uploadFile();
        }
    }

    @Override
    public void serverStarted() {
    }

    @Override
    public void serverStopped() {
    }

    @Override
    public void userLoggedIn(ServerSession session) {
        session.addTransferListener(this);
    }

    @Override
    public void userLoggedOut(UserProfile user, InetSocketAddress address) {
        for (Object session : this.myFtpServer.getSession(user.getUserName())) {
            ((ServerSession)session).removeTransferListener(this);
        }
    }

    @Override
    public void transferUpdated(TransferInfo info) {
        super.transferUpdated(info);
        if (this.myIsServer) {
            return;
        }
        try {
            if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_COMPLETED || info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_ERROR) {
                this.myStartButton.setEnabled(true);
                this.myProgressBar.setString(info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_COMPLETED ? "File processed" : "Error in file transfer");
                this.myProgressBar.setValue(0);
                this.enableFilePanel(true);
                this.myRootNode.removeAllChildren();
                this.addFileNodes(this.myRootNode);
                this.myDirTree.updateUI();
            } else if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_ONGOING) {
                this.myProgressBar.setValue((int)info.getTransferPercentage());
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.myStartButton.setEnabled(!this.myPortfield.isRequiredButMissing() && !this.myDirField.isRequiredButMissing() && (this.myIsServer || !this.myIpField.isRequiredButMissing()));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (this.myFtpClient != null && this.myIsClientConnected) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            this.addFileNodes(selectedNode);
        }
    }
}

