/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.transfer;

import com.nokia.em.poseidon.comm.common.TransferInfo;
import com.nokia.em.poseidon.comm.common.TransferListener;
import com.nokia.em.poseidon.comm.http.HttpConstants;
import com.nokia.em.poseidon.comm.http.client.HttpClient;
import com.nokia.em.poseidon.comm.http.server.HttpServer;
import com.nokia.em.poseidon.comm.http.server.HttpServerFactory;
import com.nokia.em.poseidon.comm.http.server.SSLServerSocketEndPoint;
import com.nokia.em.poseidon.demos.transfer.ConfigPanel;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.PProgressBar;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.ExtendedGridBagConstraints;
import com.nokia.widgets.text.PPasswordField;
import com.nokia.widgets.text.PTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class HttpPanel
extends ConfigPanel
implements TransferListener,
ActionListener,
ItemListener,
DocumentListener {
    private boolean myIsServer;
    private HttpServer myHttpServer;
    private HttpClient myHttpClient;
    private PTextField myIpField;
    private PTextField myPortfield;
    private PTextField myDirField;
    private PLabel myPasswordLabel;
    private PTextField myUserField;
    private PPasswordField myPassWordField;
    private PTextField myServerKeyStoreFileField;
    private PTextField myRequestFileField;
    private PPasswordField myServerKeyStorePasswordField;
    private PLabel myUserLabel;
    private PLabel mySslLabel;
    private PLabel myKeyStorePasswordLabel;
    private PLabel myServerConnectLabel;
    private JCheckBox mySecureCheckbox;
    private JCheckBox mySSLCheckbox;
    private JCheckBox myClientAuthCheckBox;
    private JCheckBox mySynchronousGetCheckBox;
    private JCheckBox myToArrayCheckBox;
    private JCheckBox myCancelTransfer;
    private PTextField myLocalFileName;
    private JButton myStartButton;
    private JButton myBrowseButton;
    private JButton mySslFileBrowseButton;
    private String myStartText;
    private String myStopText;
    private String myServerKeyStorePath;
    private String myServerKeyStorePassword;
    private String myClientKeyStorePath;
    private String myClientKeyStorePassword;
    private Icon myStartedIcon;
    private Icon myStoppedIcon;
    private PProgressBar myProgressBar;
    private PPanel myHttpPanel;
    private PLabel myTrustStoreFileLabel;
    private PTextField myClientKeyStoreFileField;
    private JButton myClientKeyStoreFileBrowseButton;
    private PLabel myClientKeyStorePasswordLabel;
    private PPasswordField myClientKeyStorePasswordFiled;
    private JCheckBox myCipherSuitesCheckBox;
    private JList myCipherSuitesList;

    public HttpPanel(boolean isServer) {
        this.myIsServer = isServer;
        this.initComponents();
        this.buildUI();
    }

    private void initComponents() {
        ResourceBundle resBundle = I18n.getI18n().getBundle(this.getClass());
        this.myStartedIcon = resBundle.getImageIcon("ProgressTask.done");
        this.myStoppedIcon = resBundle.getImageIcon("ProgressTask.upcoming");
        this.myStartText = this.myIsServer ? "Start server" : "Get file";
        this.myServerKeyStorePath = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
        this.myServerKeyStorePassword = new String(HttpConstants.DEFAULT_KEYSTORE_PASSWORD);
        this.myClientKeyStorePath = "com/nokia/em/poseidon/comm/http/Poseidon.jks";
        this.myClientKeyStorePassword = new String(HttpConstants.DEFAULT_KEYSTORE_PASSWORD);
        if (this.myIsServer) {
            this.myStopText = "Stop server";
        } else {
            this.myIpField = new PTextField(20);
            this.myIpField.setMandatoryEntry(true);
            this.myIpField.setText("localhost");
            this.myIpField.addDocumentListener(this);
            this.myProgressBar = new PProgressBar(0, 100);
            this.myProgressBar.setEnabled(true);
            this.myRequestFileField = new PTextField(20);
        }
        this.myPortfield = new PTextField(5);
        this.myPortfield.setMandatoryEntry(true);
        this.myPortfield.setText("4444");
        this.myPortfield.addDocumentListener(this);
        this.myDirField = new PTextField(20);
        this.myDirField.setMandatoryEntry(true);
        this.myDirField.setText(System.getProperty("user.home"));
        this.myDirField.addDocumentListener(this);
        this.mySecureCheckbox = new JCheckBox("Use Authentication");
        this.mySecureCheckbox.addItemListener(this);
        boolean enableSec = this.mySecureCheckbox.isSelected();
        this.myUserLabel = new PLabel("User:");
        this.myUserLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myUserLabel.setEnabled(enableSec);
        this.myUserField = new PTextField(20);
        this.myUserField.setEnabled(enableSec);
        this.myPasswordLabel = new PLabel("Password:");
        this.myPasswordLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myPasswordLabel.setEnabled(enableSec);
        this.myPassWordField = new PPasswordField();
        this.myPassWordField.setEnabled(enableSec);
        this.mySSLCheckbox = new JCheckBox("SSL");
        this.mySSLCheckbox.addItemListener(this);
        boolean enableSsl = this.mySSLCheckbox.isSelected();
        this.mySslLabel = new PLabel("Server Key Store:");
        this.mySslLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.mySslLabel.setEnabled(enableSsl);
        this.myKeyStorePasswordLabel = new PLabel("Password:");
        this.myKeyStorePasswordLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myKeyStorePasswordLabel.setEnabled(enableSsl);
        this.myServerKeyStoreFileField = new PTextField(20);
        this.myServerKeyStoreFileField.setText(this.myServerKeyStorePath);
        this.myServerKeyStoreFileField.setEnabled(enableSsl);
        this.myServerKeyStoreFileField.setMandatoryEntry(true);
        this.myServerKeyStoreFileField.addDocumentListener(this);
        this.myServerKeyStorePasswordField = new PPasswordField(20);
        this.myServerKeyStorePasswordField.setText(this.myServerKeyStorePassword);
        this.myServerKeyStorePasswordField.setEnabled(enableSsl);
        this.myClientAuthCheckBox = new JCheckBox("Need Client Authentication");
        this.mySynchronousGetCheckBox = new JCheckBox("Get File Synchronously");
        this.myToArrayCheckBox = new JCheckBox("Get File to byte array");
        this.myToArrayCheckBox.addItemListener(this);
        this.myCancelTransfer = new JCheckBox("Cancel the transfer in the middle");
        this.myLocalFileName = new PTextField(20);
        this.myLocalFileName.setEnabled(!this.myToArrayCheckBox.isSelected());
        this.myClientAuthCheckBox.setEnabled(enableSsl);
        this.myClientAuthCheckBox.addItemListener(this);
        boolean enableClientAuth = this.myClientAuthCheckBox.isSelected();
        this.myTrustStoreFileLabel = new PLabel("Client Key Store:");
        this.myTrustStoreFileLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myTrustStoreFileLabel.setEnabled(enableSsl && enableClientAuth);
        this.myClientKeyStoreFileField = new PTextField(20);
        this.myClientKeyStoreFileField.setText(this.myClientKeyStorePath);
        this.myClientKeyStoreFileField.setEnabled(enableSsl && enableClientAuth);
        this.myClientKeyStoreFileField.addDocumentListener(this);
        this.myClientKeyStoreFileBrowseButton = new JButton("Browse");
        this.myClientKeyStoreFileBrowseButton.addActionListener(this);
        this.myClientKeyStoreFileBrowseButton.setEnabled(enableSsl && enableClientAuth);
        this.myClientKeyStorePasswordLabel = new PLabel("Password");
        this.myClientKeyStorePasswordLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myClientKeyStorePasswordLabel.setEnabled(enableSsl && enableClientAuth);
        this.myClientKeyStorePasswordFiled = new PPasswordField(20);
        this.myClientKeyStorePasswordFiled.setText(this.myClientKeyStorePassword);
        this.myClientKeyStorePasswordFiled.setEnabled(enableSsl && enableClientAuth);
        this.myServerConnectLabel = new PLabel(this.myStoppedIcon);
        this.myServerConnectLabel.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.myStartButton = new JButton(this.myStartText);
        this.myStartButton.addActionListener(this);
        this.myBrowseButton = new JButton("Browse");
        this.myBrowseButton.addActionListener(this);
        this.mySslFileBrowseButton = new JButton("Browse");
        this.mySslFileBrowseButton.addActionListener(this);
        this.mySslFileBrowseButton.setEnabled(enableSsl);
        this.myCipherSuitesCheckBox = new JCheckBox("Enable Cipher Suites Setting");
        this.myCipherSuitesCheckBox.setEnabled(enableSsl);
        this.myCipherSuitesCheckBox.addItemListener(this);
        boolean enableCipherSuites = this.myCipherSuitesCheckBox.isSelected();
        this.myCipherSuitesList = new JList(this.createSupportedCipherSuites());
        this.myCipherSuitesList.setSize(this.myCipherSuitesList.getWidth(), 100);
        this.myCipherSuitesList.setEnabled(enableCipherSuites);
    }

    private DefaultListModel createSupportedCipherSuites() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        try {
            SSLSocket ssl = (SSLSocket)SSLSocketFactory.getDefault().createSocket();
            String[] supported = ssl.getSupportedCipherSuites();
            ssl.close();
            int ix = 0;
            while (ix < supported.length) {
                model.addElement(supported[ix]);
                ++ix;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    private void updateServerStatus() {
        if (this.myHttpServer != null && this.myHttpServer.isRunning()) {
            this.myHttpServer.getHandlers().get(0).removeFileTransferListener(this);
            this.myHttpServer.stop();
            this.myHttpServer.destroy();
            this.enableComponents(true);
        } else {
            if (this.myClientAuthCheckBox.isSelected()) {
                this.myClientKeyStorePath = this.myClientKeyStoreFileField.getText();
                this.myClientKeyStorePassword = new String(this.myClientKeyStorePasswordFiled.getPassword());
            } else {
                this.myClientKeyStorePath = null;
                this.myClientKeyStorePassword = null;
            }
            this.myHttpServer = HttpServerFactory.createHttpServer(this.mySSLCheckbox.isSelected(), this.mySecureCheckbox.isSelected() ? HttpConstants.Authentication.AUTHENTICATION_BASIC : HttpConstants.Authentication.AUTHENTICATION_OFF, this.myDirField.getText(), this.myUserField.getText(), new String(this.myPassWordField.getPassword()), Integer.valueOf(this.myPortfield.getText()), this.myServerKeyStoreFileField.getText(), new String(this.myServerKeyStorePasswordField.getPassword()), this.myClientKeyStorePath, this.myClientKeyStorePassword);
            this.myHttpServer.getHandlers().get(0).addFileTransferListener(this);
            if (this.mySSLCheckbox.isSelected() && this.myCipherSuitesCheckBox.isSelected()) {
                SSLServerSocketEndPoint ep = (SSLServerSocketEndPoint)this.myHttpServer.getEndPoints().values().iterator().next();
                ep.setEnabledCipherSuites(this.getSelectedCipherSuites(this.myCipherSuitesList));
            }
            try {
                this.myHttpServer.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.enableComponents(false);
        }
        boolean isRunning = this.myHttpServer.isRunning();
        this.myStartButton.setText(isRunning ? this.myStopText : this.myStartText);
        this.myServerConnectLabel.setIcon(isRunning ? this.myStartedIcon : this.myStoppedIcon);
    }

    private void startClientFileGet() {
        this.enableComponents(false);
        if (this.myHttpClient != null) {
            this.myHttpClient.removeFileTransferListener(this);
        }
        this.myHttpClient = new HttpClient(this.myIpField.getText(), Integer.valueOf(this.myPortfield.getText()));
        this.myHttpClient.addFileTransferListener(this);
        this.myHttpClient.setClientDirectory(this.myDirField.getText());
        if (this.mySecureCheckbox.isSelected()) {
            this.myHttpClient.setAuthentication(HttpConstants.Authentication.AUTHENTICATION_BASIC);
            this.myHttpClient.setUserName(this.myUserField.getText());
            this.myHttpClient.setPassword(new String(this.myPassWordField.getPassword()));
        }
        this.myHttpClient.setSecure(this.mySSLCheckbox.isSelected());
        if (this.mySSLCheckbox.isSelected()) {
            this.myHttpClient.setKeyStorePassword(this.myServerKeyStorePasswordField.getPassword());
            this.myHttpClient.setKeyStoreFile(this.myServerKeyStoreFileField.getText());
            if (this.myClientAuthCheckBox.isSelected()) {
                this.myHttpClient.setUseClientMode(true);
                this.myHttpClient.setClientKeyStoreFile(this.myClientKeyStoreFileField.getText());
                this.myHttpClient.setClientKeyStorePassword(this.myClientKeyStorePasswordFiled.getPassword());
            }
            this.myHttpClient.setEnabledCipherSuites(this.myCipherSuitesCheckBox.isSelected() ? this.getSelectedCipherSuites(this.myCipherSuitesList) : null);
        }
        this.myProgressBar.setString("Getting file...");
        this.myProgressBar.setStringPainted(true);
        if (this.myToArrayCheckBox.isSelected()) {
            if (this.mySynchronousGetCheckBox.isSelected()) {
                this.myHttpClient.getByteArraySynchronously(this.myRequestFileField.getText());
            } else {
                this.myHttpClient.getByteArray(this.myRequestFileField.getText());
            }
        } else if (this.mySynchronousGetCheckBox.isSelected()) {
            if (this.myLocalFileName.getText() == null || "".equals(this.myLocalFileName.getText())) {
                this.myHttpClient.getFileSynchronously(this.myRequestFileField.getText());
            } else {
                this.myHttpClient.getFileSynchronously(this.myRequestFileField.getText(), this.myLocalFileName.getText());
            }
        } else if (this.myLocalFileName.getText() == null || "".equals(this.myLocalFileName.getText())) {
            this.myHttpClient.getFile(this.myRequestFileField.getText());
        } else {
            this.myHttpClient.getFile(this.myRequestFileField.getText(), this.myLocalFileName.getText());
        }
    }

    private String[] getSelectedCipherSuites(JList list) {
        ArrayList<String> cipherSuites = new ArrayList<String>();
        ListModel model = list.getModel();
        int ix = 0;
        while (ix < model.getSize()) {
            if (list.isSelectedIndex(ix)) {
                cipherSuites.add(model.getElementAt(ix).toString());
            }
            ++ix;
        }
        String[] cs = new String[cipherSuites.size()];
        return cipherSuites.toArray(cs);
    }

    private void enableComponents(boolean enabled) {
        if (!this.myIsServer) {
            this.myIpField.setEnabled(enabled);
            this.myRequestFileField.setEnabled(enabled);
            this.myStartButton.setEnabled(enabled);
            this.mySynchronousGetCheckBox.setEnabled(enabled);
            this.myToArrayCheckBox.setEnabled(enabled);
            this.myCancelTransfer.setEnabled(enabled);
            this.myLocalFileName.setEnabled(enabled && !this.myToArrayCheckBox.isSelected());
        }
        this.myPortfield.setEnabled(enabled);
        this.myDirField.setEnabled(enabled);
        this.myUserField.setEnabled(enabled && this.mySecureCheckbox.isSelected());
        this.myPassWordField.setEnabled(enabled && this.mySecureCheckbox.isSelected());
        this.myServerKeyStoreFileField.setEnabled(enabled && this.mySSLCheckbox.isSelected());
        this.myClientAuthCheckBox.setEnabled(enabled && this.mySSLCheckbox.isSelected());
        this.myServerKeyStorePasswordField.setEnabled(enabled && this.mySSLCheckbox.isSelected());
        this.mySslFileBrowseButton.setEnabled(enabled && this.mySSLCheckbox.isSelected());
        this.myBrowseButton.setEnabled(enabled);
        this.mySecureCheckbox.setEnabled(enabled);
        this.mySSLCheckbox.setEnabled(enabled);
        this.myClientKeyStoreFileField.setEnabled(enabled && this.mySSLCheckbox.isSelected() && this.myClientAuthCheckBox.isSelected());
        this.myClientKeyStoreFileBrowseButton.setEnabled(enabled && this.mySSLCheckbox.isSelected() && this.myClientAuthCheckBox.isSelected());
        this.myClientKeyStorePasswordFiled.setEnabled(enabled && this.mySSLCheckbox.isSelected() && this.myClientAuthCheckBox.isSelected());
        this.myCipherSuitesCheckBox.setEnabled(enabled && this.mySSLCheckbox.isSelected());
        this.myCipherSuitesList.setEnabled(enabled && this.mySSLCheckbox.isSelected() && this.myCipherSuitesCheckBox.isSelected());
    }

    @Override
    public void transferUpdated(TransferInfo info) {
        super.transferUpdated(info);
        if (!this.myIsServer) {
            this.handleClientTransferInfo(info);
        }
    }

    private void handleClientTransferInfo(final TransferInfo info) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_COMPLETED) {
                    try {
                        HttpPanel.this.myEventLoggerDocument.insertString(HttpPanel.this.myEventLoggerDocument.getLength(), new SimpleDateFormat("[HH:mm:ss.SSS] [dd.MM.yyyy]").format(new Date(System.currentTimeMillis())), HttpPanel.this.myTimeStampAttrSet);
                        Object target = info.getTransferTarget();
                        if (target instanceof File) {
                            char[] content = new char[]{};
                            try {
                                FileReader reader = new FileReader((File)target);
                                content = new char[(int)((File)target).length()];
                                reader.read(content);
                                reader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            HttpPanel.this.myEventLoggerDocument.insertString(HttpPanel.this.myEventLoggerDocument.getLength(), " Transfer completed, target: " + LS + new String(content), HttpPanel.this.myBoldAttrSet);
                        } else if (target instanceof byte[]) {
                            HttpPanel.this.myEventLoggerDocument.insertString(HttpPanel.this.myEventLoggerDocument.getLength(), " Transfer completed, target: " + LS + new String((byte[])target), HttpPanel.this.myBoldAttrSet);
                        } else {
                            HttpPanel.this.myEventLoggerDocument.insertString(HttpPanel.this.myEventLoggerDocument.getLength(), " Transfer completed contained no taransfer target", HttpPanel.this.myBoldAttrSet);
                        }
                        HttpPanel.this.myEventLoggerDocument.insertString(HttpPanel.this.myEventLoggerDocument.getLength(), String.valueOf(LS) + LS, null);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    HttpPanel.this.myProgressBar.setString("File received");
                    HttpPanel.this.myProgressBar.setValue(0);
                    HttpPanel.this.enableComponents(true);
                } else if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_ERROR) {
                    HttpPanel.this.myProgressBar.setString("Error in file transfer");
                    HttpPanel.this.myProgressBar.setValue(0);
                    HttpPanel.this.enableComponents(true);
                } else if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_ONGOING) {
                    if (!HttpPanel.this.myProgressBar.isStringPainted()) {
                        HttpPanel.this.myProgressBar.setStringPainted(true);
                    }
                    HttpPanel.this.myProgressBar.setValue((int)info.getTransferPercentage());
                } else if (info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_CANCELLED) {
                    HttpPanel.this.myProgressBar.setString("File transfer cancelled");
                    HttpPanel.this.myProgressBar.setValue(0);
                    HttpPanel.this.enableComponents(true);
                }
            }
        });
        if (this.myCancelTransfer.isSelected() && info.getTransferStatus() == TransferInfo.TransferStatus.TRANSFER_ONGOING && info.getTransferPercentage() > 49.0) {
            this.myHttpClient.cancel();
        }
    }

    @Override
    protected JComponent getConfigurationView() {
        this.myHttpPanel = new PPanel(new GridBagLayout());
        ExtendedGridBagConstraints constraints = new ExtendedGridBagConstraints();
        constraints.setAnchor(18);
        constraints.setColumnWidth(2);
        constraints.setBottomInset(6);
        constraints.setTopInset(6);
        this.myHttpPanel.add((Component)PLabel.createTitle(this.myIsServer ? "HTTP Server Configuration" : "HTTP Client Configuration"), constraints);
        constraints.setTopInset(3);
        constraints.setColumnWidth(1);
        constraints.setBottomInset(3);
        constraints.setLeftInset(24);
        if (!this.myIsServer) {
            this.addComponentRow(constraints, this.myHttpPanel, PLabel.createSystemText("Server IP:"), this.myIpField);
        }
        this.addComponentRow(constraints, this.myHttpPanel, PLabel.createSystemText("Port:"), this.myPortfield);
        this.addComponentRow(constraints, this.myHttpPanel, PLabel.createSystemText(this.myIsServer ? "Server directory:" : "Client directory:"), this.myDirField, this.myBrowseButton);
        constraints.setColumnWidth(2);
        this.addComponentRow(constraints, this.myHttpPanel, this.mySecureCheckbox);
        constraints.setColumnWidth(1);
        constraints.setLeftInset(36);
        this.addComponentRow(constraints, this.myHttpPanel, this.myUserLabel, this.myUserField);
        constraints.fillHorizontal();
        this.addComponentRow(constraints, this.myHttpPanel, this.myPasswordLabel, this.myPassWordField);
        constraints.fillNone();
        constraints.setColumnWidth(2);
        constraints.setLeftInset(24);
        this.addComponentRow(constraints, this.myHttpPanel, this.mySSLCheckbox);
        constraints.setColumnWidth(1);
        constraints.setLeftInset(36);
        this.addComponentRow(constraints, this.myHttpPanel, this.mySslLabel, this.myServerKeyStoreFileField, this.mySslFileBrowseButton);
        this.addComponentRow(constraints, this.myHttpPanel, this.myKeyStorePasswordLabel, this.myServerKeyStorePasswordField);
        this.addComponentRow(constraints, this.myHttpPanel, this.myClientAuthCheckBox);
        constraints.setLeftInset(48);
        this.addComponentRow(constraints, this.myHttpPanel, this.myTrustStoreFileLabel, this.myClientKeyStoreFileField, this.myClientKeyStoreFileBrowseButton);
        this.addComponentRow(constraints, this.myHttpPanel, this.myClientKeyStorePasswordLabel, this.myClientKeyStorePasswordFiled);
        constraints.setLeftInset(36);
        this.addComponentRow(constraints, this.myHttpPanel, this.myCipherSuitesCheckBox);
        constraints.setLeftInset(48);
        constraints.gridwidth = 2;
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(this.myCipherSuitesList);
        this.addComponentRow(constraints, this.myHttpPanel, pane);
        constraints.gridwidth = 1;
        constraints.setLeftInset(24);
        constraints.setColumnWidth(2);
        if (!this.myIsServer) {
            this.addComponentRow(constraints, this.myHttpPanel, this.mySynchronousGetCheckBox);
            this.addComponentRow(constraints, this.myHttpPanel, this.myToArrayCheckBox);
            this.addComponentRow(constraints, this.myHttpPanel, this.myCancelTransfer);
            this.addComponentRow(constraints, this.myHttpPanel, PLabel.createSystemText("File name:"), this.myRequestFileField);
            this.addComponentRow(constraints, this.myHttpPanel, PLabel.createSystemText("Local file name:"), this.myLocalFileName);
            this.addComponentRow(constraints, this.myHttpPanel, this.myStartButton);
            this.addComponentRow(constraints, this.myHttpPanel, this.myProgressBar);
        } else {
            PPanel startPanel = new PPanel(new BorderLayout(3, 0));
            startPanel.add((Component)this.myStartButton, "West");
            startPanel.add((Component)this.myServerConnectLabel, "Center");
            this.addComponentRow(constraints, this.myHttpPanel, startPanel);
        }
        constraints.nextRow();
        constraints.setColumnWidth(0);
        constraints.setColumnHorizontalWeigth(1.0);
        constraints.setColumnVerticalWeigth(1.0);
        this.myHttpPanel.add((Component)new PLabel(), constraints);
        return this.myHttpPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myStartButton) {
            if (this.myIsServer) {
                this.updateServerStatus();
            } else {
                this.startClientFileGet();
            }
        } else if (e.getSource() == this.myBrowseButton) {
            this.myDirField.setText(this.browseDirectory(this.myDirField.getText(), 1));
        } else if (e.getSource() == this.mySslFileBrowseButton) {
            this.myServerKeyStoreFileField.setText(this.browseDirectory(this.myServerKeyStoreFileField.getText(), 2));
        } else if (e.getSource() == this.myClientKeyStoreFileBrowseButton) {
            this.myClientKeyStoreFileField.setText(this.browseDirectory(this.myClientKeyStoreFileField.getText(), 2));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean enabled;
        boolean bl = enabled = e.getStateChange() == 1;
        if (e.getSource() == this.mySecureCheckbox) {
            this.myUserLabel.setEnabled(enabled);
            this.myUserField.setEnabled(enabled);
            this.myPasswordLabel.setEnabled(enabled);
            this.myPassWordField.setEnabled(enabled);
        } else if (e.getSource() == this.mySSLCheckbox) {
            this.mySslLabel.setEnabled(enabled);
            this.myServerKeyStoreFileField.setEnabled(enabled);
            this.mySslFileBrowseButton.setEnabled(enabled);
            this.myKeyStorePasswordLabel.setEnabled(enabled);
            this.myServerKeyStorePasswordField.setEnabled(enabled);
            this.myClientAuthCheckBox.setEnabled(enabled);
            this.myTrustStoreFileLabel.setEnabled(enabled && this.myClientAuthCheckBox.isSelected());
            this.myClientKeyStoreFileField.setEnabled(enabled && this.myClientAuthCheckBox.isSelected());
            this.myClientKeyStoreFileBrowseButton.setEnabled(enabled && this.myClientAuthCheckBox.isSelected());
            this.myClientKeyStorePasswordLabel.setEnabled(enabled && this.myClientAuthCheckBox.isSelected());
            this.myClientKeyStorePasswordFiled.setEnabled(enabled && this.myClientAuthCheckBox.isSelected());
            this.myCipherSuitesCheckBox.setEnabled(enabled);
            this.myCipherSuitesList.setEnabled(this.myCipherSuitesCheckBox.isSelected() && enabled);
        } else if (e.getSource() == this.myClientAuthCheckBox) {
            this.myTrustStoreFileLabel.setEnabled(enabled);
            this.myClientKeyStoreFileField.setEnabled(enabled);
            this.myClientKeyStoreFileBrowseButton.setEnabled(enabled);
            this.myClientKeyStorePasswordLabel.setEnabled(enabled);
            this.myClientKeyStorePasswordFiled.setEnabled(enabled);
        } else if (e.getSource() == this.myCipherSuitesCheckBox) {
            this.myCipherSuitesList.setEnabled(enabled);
        } else if (e.getSource() == this.myToArrayCheckBox) {
            this.myLocalFileName.setEnabled(!enabled);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.myStartButton.setEnabled(!this.myPortfield.isRequiredButMissing() && !this.myDirField.isRequiredButMissing() && (this.myIsServer || !this.myIpField.isRequiredButMissing()));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }
}

