/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.demos.transfer;

import com.nokia.em.poseidon.demos.transfer.ConfigPanel;
import com.nokia.em.poseidon.demos.transfer.FtpPanel;
import com.nokia.em.poseidon.demos.transfer.HttpPanel;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.logging.LoggerPanel;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class TransferMainPanel
extends PPanel {
    private JSplitPane myHorizontalSplitPane;
    private JSplitPane myVerticalSplitPane;
    private ConfigPanel myHttpServerPanel;
    private ConfigPanel myHttpClientPanel;
    private ConfigPanel myFtpServerPanel;
    private ConfigPanel myFtpClientPanel;
    private JScrollPane myConfigScrollPanel;
    private JScrollPane myTransferInfoPanel;
    private ImageIcon myServerIcon;
    private ImageIcon myClientIcon;
    private UserInterface myUI;

    public TransferMainPanel(UserInterface ui) {
        super(new BorderLayout());
        this.myUI = ui;
        this.myServerIcon = new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/server.gif"));
        this.myClientIcon = new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/demos/res/transfer.gif"));
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.myHttpServerPanel = new HttpPanel(true);
        this.myHttpClientPanel = new HttpPanel(false);
        this.myFtpServerPanel = new FtpPanel(true);
        this.myFtpClientPanel = new FtpPanel(false);
        this.myConfigScrollPanel = new JScrollPane();
        this.myTransferInfoPanel = new JScrollPane();
        LoggerPanel loggerPanel = new LoggerPanel(new Logger[]{Logger.getRootLogger()});
        loggerPanel.startLogging();
        PPanel logPanel = new PPanel(new BorderLayout(0, 6));
        logPanel.setBorder(new EmptyBorder(6, 12, 6, 6));
        logPanel.add((Component)PLabel.createTitle("Log4j logging:"), "First");
        logPanel.add((Component)loggerPanel, "Center");
        this.myHorizontalSplitPane = new JSplitPane(1);
        this.myVerticalSplitPane = new JSplitPane(0);
        this.myHorizontalSplitPane.setLeftComponent(logPanel);
        this.myHorizontalSplitPane.setRightComponent(this.myTransferInfoPanel);
        this.myVerticalSplitPane.setBottomComponent(this.myHorizontalSplitPane);
        this.myVerticalSplitPane.setTopComponent(this.myConfigScrollPanel);
        this.myVerticalSplitPane.setDividerLocation((int)((double)this.myUI.getFrame().getSize().height * 0.38));
        this.myHorizontalSplitPane.setDividerLocation((int)((double)this.myUI.getFrame().getSize().width * 0.43));
        this.add((Component)this.myVerticalSplitPane, "Center");
    }

    public Action createHttpServerAcion() {
        return new AbstractAction("HTTP Server", this.myServerIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferMainPanel.this.setPanel(TransferMainPanel.this.myHttpServerPanel, 0.58);
            }
        };
    }

    public Action createHttpClientAcion() {
        return new AbstractAction("HTTP Client", this.myClientIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferMainPanel.this.setPanel(TransferMainPanel.this.myHttpClientPanel, 0.65);
            }
        };
    }

    public Action createFtpServerAcion() {
        return new AbstractAction("FTP Server", this.myServerIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferMainPanel.this.setPanel(TransferMainPanel.this.myFtpServerPanel, 0.2);
            }
        };
    }

    public Action createFtpClientAcion() {
        return new AbstractAction("FTP Client", this.myClientIcon){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferMainPanel.this.setPanel(TransferMainPanel.this.myFtpClientPanel, 0.38);
            }
        };
    }

    private void setPanel(final ConfigPanel configPanel, final double heightPercentage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransferMainPanel.this.myConfigScrollPanel.setViewportView(configPanel);
                TransferMainPanel.this.myHorizontalSplitPane.setRightComponent(configPanel.getTransferEventPanel());
                TransferMainPanel.this.myVerticalSplitPane.setDividerLocation((int)((double)((TransferMainPanel)TransferMainPanel.this).myUI.getFrame().getSize().height * heightPercentage));
                TransferMainPanel.this.myHorizontalSplitPane.setDividerLocation((int)((double)((TransferMainPanel)TransferMainPanel.this).myUI.getFrame().getSize().width * 0.43));
            }
        });
    }
}

