/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.alarm;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmUtils;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;

public class PAlarmEntry {
    public static final int EVENT_TYPE_COMMUNICATION_FAILURE = 22;
    public static final int EVENT_TYPE_QUALITY_OF_SERVICE = 23;
    public static final int EVENT_TYPE_PROCESSING_FAILURE = 24;
    public static final int EVENT_TYPE_EQUIPMENT_FAILURE = 25;
    public static final int EVENT_TYPE_ENVIRONMENT_FAILURE = 26;
    public static final int SEVERITY_WARNING = 0;
    public static final int SEVERITY_MINOR = 1;
    public static final int SEVERITY_MAJOR = 2;
    public static final int SEVERITY_CRITICAL = 3;
    public static final int TIME_SOURCE_NTP = 0;
    public static final int TIME_SOURCE_PC = 1;
    public static final String KEY_DESCRIPTION = "Description";
    public static final String KEY_CODE = "Code";
    public static final String KEY_FAULT_CODE = "FaultCode";
    public static final String KEY_SCOPE = "Scope";
    public static final String KEY_STATE = "AlarmState";
    public static final String KEY_SEVERITY = "Severity";
    public static final String KEY_ACTIVE_TIME = "ActiveTime";
    public static final String KEY_CLEARED_TIME = "ClearedTime";
    public static final String KEY_SOURCE = "Source";
    public static final String KEY_TRANSIENT = "Transient";
    public static final String KEY_TOGGLING = "Toggling";
    public static final String KEY_APPLICATION_NAME = "ApplicationName";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_UNIQUEID = "Identifier";
    public static final String KEY_ACTIVE_TIME_SOURCE = "ActiveTimeSource";
    public static final String KEY_CLEAR_TIME_SOURCE = "ClearTimeSource";
    public static final String KEY_HELP_REQ_ID = "HelpRequestId";
    public static final String KEY_ANT_ID = "AntId";
    public static final String KEY_SELECTED = "Selected";
    public static final String KEY_ADDTIONAL_INFORMATION = "AdditionalInformation";
    protected static final Boolean VALUE_STATE_CLEARED = Boolean.FALSE;
    protected static final Boolean VALUE_STATE_ACTIVE = Boolean.TRUE;
    protected static final Boolean VALUE_TYPE_TRANSIENT = Boolean.TRUE;
    protected static final Boolean VALUE_TYPE_NORMAL = Boolean.FALSE;
    private Map<String, Object> myDetails;
    private Map<String, String> myAdditionalInformation;
    private Map<String, String> myAdditionalAttributes;
    private LinkedHashMap<String, String> myPrintableValues;
    private List<Action> myCustomizedActions;
    private ResourceBundle myResourceBundle;
    private Set<PropertyChangeListener> myListeners = new HashSet<PropertyChangeListener>();
    private boolean myInlineFilterActive;

    public PAlarmEntry(int severity, long code, Calendar activeTime, String description, String source, Object application, boolean activeState) {
        this(severity, code, activeTime, null, description, source, null, application, activeState, 0, 0);
    }

    public PAlarmEntry(int severity, long code, Calendar activeTime, Calendar clearTime, String description, String source, String helpRequestId, Object application, boolean activeState, int activeTimeSource, int clearTimeSource) {
        this();
        this.setSeverity(severity);
        this.setAlarmCode(code);
        this.setTime(activeTime);
        this.setClearTime(clearTime);
        this.setDescription(description);
        this.setSource(source);
        this.setHelpRequestId(helpRequestId);
        this.setApplication(application);
        this.setIsActive(activeState);
        this.setTimingSource(activeTimeSource);
        this.setClearTimingSource(clearTimeSource);
    }

    public PAlarmEntry() {
        this.myDetails = new HashMap<String, Object>();
        this.myAdditionalInformation = new HashMap<String, String>();
        this.myAdditionalAttributes = new HashMap<String, String>();
        this.myPrintableValues = new LinkedHashMap();
        this.myCustomizedActions = new ArrayList<Action>();
        this.setStateActive(true);
        this.setTime(Calendar.getInstance());
        this.setDescription("");
        this.setSource("");
        this.setAlarmCode(0L);
        this.myResourceBundle = I18n.getI18n().getBundle(PAlarmEntry.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public boolean isActive() {
        return this.get(KEY_STATE) == null ? true : (Boolean)this.get(KEY_STATE);
    }

    public Map<String, Object> getDetails() {
        return this.myDetails;
    }

    public int getSeverity() {
        return this.get(KEY_SEVERITY) == null ? 3 : (Integer)this.get(KEY_SEVERITY);
    }

    public Calendar getTime() {
        return this.get(KEY_ACTIVE_TIME) == null ? null : (Calendar)this.get(KEY_ACTIVE_TIME);
    }

    public Calendar getClearTime() {
        return this.get(KEY_CLEARED_TIME) == null ? null : (Calendar)this.get(KEY_CLEARED_TIME);
    }

    public String getDescription() {
        return this.get(KEY_DESCRIPTION) == null ? null : (String)this.get(KEY_DESCRIPTION);
    }

    public String getSource() {
        return this.get(KEY_SOURCE) == null ? null : (String)this.get(KEY_SOURCE);
    }

    public String getAntId() {
        return this.get(KEY_ANT_ID) == null ? null : (String)this.get(KEY_ANT_ID);
    }

    public Object get(String key) {
        return this.myDetails.get(key);
    }

    public void put(String key, Object value) {
        Object oldValue = this.myDetails.get(key);
        this.myDetails.put(key, value);
        this.propertyChanged(key, value, oldValue);
    }

    public long getAlarmCode() {
        return this.get(KEY_CODE) == null ? -1L : (Long)this.get(KEY_CODE);
    }

    public long getFaultCode() {
        return this.get(KEY_FAULT_CODE) == null ? -1L : (Long)this.get(KEY_FAULT_CODE);
    }

    public String getAlarmScope() {
        return this.get(KEY_SCOPE) == null ? "" : (String)this.get(KEY_SCOPE);
    }

    public boolean isAlarmTransient() {
        return this.get(KEY_TRANSIENT) == null ? false : (Boolean)this.get(KEY_TRANSIENT);
    }

    public void setAlarmToggling(boolean isToggling) {
        Boolean oldValue = this.isAlarmToggling();
        this.put(KEY_TOGGLING, isToggling);
        this.propertyChanged(KEY_TOGGLING, isToggling, oldValue);
    }

    public boolean isAlarmToggling() {
        return this.get(KEY_TOGGLING) == null ? false : (Boolean)this.get(KEY_TOGGLING);
    }

    public void setAlarmTransient(boolean isTransient) {
        Boolean oldValue = this.isAlarmTransient();
        this.put(KEY_TRANSIENT, isTransient);
        this.propertyChanged(KEY_TRANSIENT, isTransient, oldValue);
    }

    public String getUniqueId() {
        StringBuffer uniqueId = new StringBuffer();
        uniqueId.append(this.getSource());
        uniqueId.append("_");
        uniqueId.append(this.getAlarmCode());
        uniqueId.append("_");
        uniqueId.append(this.getTime() == null ? "" : Long.valueOf(this.getTime().getTime().getTime()));
        return uniqueId.toString();
    }

    public int getTimingSource() {
        return this.get(KEY_ACTIVE_TIME_SOURCE) == null ? 0 : (Integer)this.get(KEY_ACTIVE_TIME_SOURCE);
    }

    public int getClearTimingSource() {
        return this.get(KEY_CLEAR_TIME_SOURCE) == null ? 0 : (Integer)this.get(KEY_CLEAR_TIME_SOURCE);
    }

    public LinkedHashMap<String, String> getPrintableValues() {
        return this.myPrintableValues;
    }

    public Object getApplication() {
        return this.get(KEY_APPLICATION);
    }

    public String getHelpId() {
        return this.get(KEY_HELP_REQ_ID) == null ? null : (String)this.get(KEY_HELP_REQ_ID);
    }

    public boolean equals(Object value) {
        if (this == value) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (this.getClass() != value.getClass()) {
            return false;
        }
        PAlarmEntry entry = (PAlarmEntry)value;
        return this.getUniqueId().equalsIgnoreCase(entry.getUniqueId()) && this.getDescription().equalsIgnoreCase(entry.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getUniqueId().hashCode() + this.getDescription().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Severity_Text")) + ": ");
        builder.append(String.valueOf(this.serverityToString()) + "\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Time_Text")) + ": ");
        builder.append(this.get(KEY_ACTIVE_TIME) != null ? PAlarmUtils.localiseTime((Calendar)this.get(KEY_ACTIVE_TIME)) : "");
        if (this.get(KEY_ACTIVE_TIME_SOURCE) != null) {
            builder.append((Integer)this.get(KEY_ACTIVE_TIME_SOURCE) == 0 ? "" : " " + this.myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text"));
        }
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Description_Text")) + ": ");
        builder.append(this.get(KEY_DESCRIPTION) != null ? this.get(KEY_DESCRIPTION) : "");
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Source_Text")) + ": ");
        builder.append(this.get(KEY_SOURCE) != null ? this.get(KEY_SOURCE) : "");
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.Code_Text")) + ": ");
        builder.append(this.get(KEY_CODE) != null ? this.get(KEY_CODE) : "");
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.FaultCode_Text")) + ": ");
        builder.append(this.get(KEY_FAULT_CODE) != null ? this.get(KEY_FAULT_CODE) : "");
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PDefaultAlarmFileWriter.Scope_Text")) + ": ");
        builder.append(this.get(KEY_SCOPE) != null ? this.get(KEY_SCOPE) : "");
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PDefaultAlarmFileWriter.Status_Text")) + ": ");
        if (this.get(KEY_TRANSIENT) != null && ((Boolean)this.get(KEY_TRANSIENT)).booleanValue()) {
            builder.append(this.myResourceBundle.getString("PAlarmView.Transient_Text"));
        } else if ((Boolean)this.get(KEY_STATE) != null) {
            builder.append((Boolean)this.get(KEY_STATE) != false ? this.myResourceBundle.getString("Common.Active_Text") : this.myResourceBundle.getString("PDefaultAlarmFileWriter.Cleared_Text"));
        }
        if (this.get(KEY_TOGGLING) != null && ((Boolean)this.get(KEY_TOGGLING)).booleanValue()) {
            builder.append(this.myResourceBundle.getString("PAlarmView.Toggling_Text"));
        }
        builder.append("\n");
        builder.append(String.valueOf(this.myResourceBundle.getString("PAlarmView.Column.ClearTime_Text")) + ": ");
        builder.append(this.get(KEY_CLEARED_TIME) != null ? PAlarmUtils.localiseTime((Calendar)this.get(KEY_CLEARED_TIME)) : "");
        if (this.get(KEY_CLEAR_TIME_SOURCE) != null) {
            builder.append((Integer)this.get(KEY_CLEAR_TIME_SOURCE) == 0 ? "" : " " + this.myResourceBundle.getString("PAlarmView.TimeStamp_PcTime_Text"));
        }
        builder.append(this.subunitNumToString());
        builder.append(this.additionalInfoToString());
        if (!this.myPrintableValues.isEmpty()) {
            for (String key : this.myPrintableValues.keySet()) {
                builder.append("\n");
                builder.append(key);
                builder.append(": ");
                builder.append(this.myPrintableValues.get(key));
            }
        }
        return builder.toString();
    }

    protected String subunitNumToString() {
        return "";
    }

    protected String additionalInfoToString() {
        StringBuilder infos = new StringBuilder();
        String literalValue = this.getAdditionalInformation();
        if (literalValue != null) {
            infos.append("\n").append(this.myResourceBundle.getString("PAlarmDetailsView.Addtional_Information")).append(": ").append(literalValue);
        }
        return infos.toString();
    }

    protected String additionalAttributeToString() {
        StringBuilder infos = new StringBuilder();
        Map<String, String> attributes = this.getAdditionalAttributes();
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                infos.append("\n").append(key).append(": ").append(attributes.get(key));
            }
        }
        return infos.toString();
    }

    public void setHelpRequestId(String helpRequestId) {
        String oldValue = this.getHelpId();
        this.myDetails.put(KEY_HELP_REQ_ID, helpRequestId);
        this.propertyChanged(KEY_HELP_REQ_ID, helpRequestId, oldValue);
    }

    public void setSeverity(int severity) {
        Integer oldValue = this.getSeverity();
        this.myDetails.put(KEY_SEVERITY, severity);
        this.propertyChanged(KEY_SEVERITY, severity, oldValue);
    }

    public void setTime(Calendar activeTime) {
        Calendar oldValue = this.getTime();
        this.myDetails.put(KEY_ACTIVE_TIME, activeTime);
        this.propertyChanged(KEY_ACTIVE_TIME, activeTime, oldValue);
    }

    public void setClearTime(Calendar clearTime) {
        Calendar oldValue = this.getClearTime();
        this.myDetails.put(KEY_CLEARED_TIME, clearTime);
        this.propertyChanged(KEY_CLEARED_TIME, clearTime, oldValue);
    }

    public void setDescription(String description) {
        String oldValue = this.getDescription();
        this.myDetails.put(KEY_DESCRIPTION, description);
        this.propertyChanged(KEY_DESCRIPTION, description, oldValue);
    }

    public void setStateActive(boolean active) {
        Boolean oldValue = this.isActive();
        this.myDetails.put(KEY_STATE, active ? VALUE_STATE_ACTIVE : VALUE_STATE_CLEARED);
        this.propertyChanged(KEY_STATE, active, oldValue);
    }

    public void setSource(String source) {
        String oldValue = this.getSource();
        this.myDetails.put(KEY_SOURCE, source);
        this.propertyChanged(KEY_SOURCE, source, oldValue);
    }

    public void setAlarmCode(long alarmCode) {
        Long oldValue = this.getAlarmCode();
        this.myDetails.put(KEY_CODE, alarmCode);
        this.propertyChanged(KEY_CODE, alarmCode, oldValue);
    }

    public void setFaultCode(long faultCode) {
        Long oldValue = this.getFaultCode();
        this.myDetails.put(KEY_FAULT_CODE, faultCode);
        this.propertyChanged(KEY_FAULT_CODE, faultCode, oldValue);
    }

    public void setAlarmScope(String alarmScope) {
        String oldValue = this.getAlarmScope();
        this.myDetails.put(KEY_SCOPE, alarmScope);
        this.propertyChanged(KEY_SCOPE, alarmScope, oldValue);
    }

    public void setApplication(Object application) {
        Object oldValue = this.getApplication();
        this.myDetails.put(KEY_APPLICATION, application);
        this.propertyChanged(KEY_APPLICATION, application, oldValue);
    }

    public void setIsActive(boolean active) {
        Boolean oldValue = this.isActive();
        if (active) {
            this.myDetails.put(KEY_STATE, VALUE_STATE_ACTIVE);
        } else {
            this.myDetails.put(KEY_STATE, VALUE_STATE_CLEARED);
        }
        this.propertyChanged(KEY_STATE, active, oldValue);
    }

    public void setTimingSource(int source) {
        Integer oldValue = this.getTimingSource();
        this.myDetails.put(KEY_ACTIVE_TIME_SOURCE, source);
        this.propertyChanged(KEY_ACTIVE_TIME_SOURCE, source, oldValue);
    }

    public void setClearTimingSource(int source) {
        Integer oldValue = this.getClearTimingSource();
        this.myDetails.put(KEY_CLEAR_TIME_SOURCE, source);
        this.propertyChanged(KEY_CLEAR_TIME_SOURCE, source, oldValue);
    }

    public void setAdditionalInformation(String info) {
        this.addAdditionalInfo(KEY_ADDTIONAL_INFORMATION, info);
    }

    public void addAdditionalInfo(String key, String value) {
        LinkedHashMap<String, String> oldValue = new LinkedHashMap<String, String>();
        oldValue.putAll(this.myAdditionalInformation);
        this.myAdditionalInformation.put(key, value);
        this.propertyChanged(KEY_ADDTIONAL_INFORMATION, this.myAdditionalInformation, oldValue);
    }

    public boolean hasAdditionalInfo() {
        return !this.myAdditionalInformation.isEmpty();
    }

    public String getAdditionalInformation() {
        return this.getAdditionalInfo(KEY_ADDTIONAL_INFORMATION);
    }

    public String getAdditionalInformationPrintValue() {
        return this.getAdditionalInformation();
    }

    public String getAdditionalInfo(String key) {
        return this.myAdditionalInformation.get(key);
    }

    public Map<String, String> getAdditionalAttributes() {
        return this.myAdditionalAttributes;
    }

    public void setAdditionalAttributes(Map additionalAttributes) {
        this.myAdditionalAttributes = additionalAttributes;
    }

    public boolean hasAdditionalAttributes() {
        return !this.myAdditionalAttributes.isEmpty();
    }

    public void addPrintableValue(String key, String value) {
        this.myPrintableValues.put(key, value);
        this.propertyChanged(key, value, null);
    }

    public void addSpecificAction(Action action) {
        if (!this.myCustomizedActions.contains(action)) {
            this.myCustomizedActions.add(action);
        }
    }

    public List<Action> getSpecificActions() {
        return this.myCustomizedActions;
    }

    public String serverityToString() {
        switch ((Integer)this.get(KEY_SEVERITY)) {
            case 3: {
                return this.myResourceBundle.getString("Common.CriticalError_Text");
            }
            case 2: {
                return this.myResourceBundle.getString("Common.MajorError_Text");
            }
            case 1: {
                return this.myResourceBundle.getString("Common.MinorError_Text");
            }
            case 0: {
                return this.myResourceBundle.getString("Common.WarningError_Text");
            }
        }
        return "";
    }

    protected void propertyChanged(String key, Object newValue, Object oldValue) {
        for (PropertyChangeListener listener : this.myListeners) {
            listener.propertyChange(new PropertyChangeEvent(this, key, oldValue, newValue));
        }
    }

    public boolean isHiddenByFilter() {
        return this.myInlineFilterActive;
    }

    public boolean setIsHiddenByFilter(boolean value) {
        this.myInlineFilterActive = value;
        return this.myInlineFilterActive;
    }
}

