/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.alarm;

import com.nokia.em.poseidon.frameworks.alarm.PAlarmEntry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class PAlarmModel {
    private List<PAlarmEntry> myCurrentAlarms = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PAlarmEntry> removeAlarms(Object application, String source) {
        if (application != null) {
            ArrayList<PAlarmEntry> alarmsCopy;
            ArrayList<PAlarmEntry> removedAlarms = new ArrayList<PAlarmEntry>();
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                alarmsCopy = new ArrayList<PAlarmEntry>(this.myCurrentAlarms);
            }
            for (PAlarmEntry entry : alarmsCopy) {
                List<PAlarmEntry> list2;
                if (!application.equals(entry.getApplication())) continue;
                if (source != null) {
                    if (!source.equalsIgnoreCase(entry.getSource())) continue;
                    list2 = this.myCurrentAlarms;
                    synchronized (list2) {
                        removedAlarms.add(entry);
                        this.myCurrentAlarms.remove(entry);
                        continue;
                    }
                }
                list2 = this.myCurrentAlarms;
                synchronized (list2) {
                    removedAlarms.add(entry);
                    this.myCurrentAlarms.remove(entry);
                }
            }
            return removedAlarms;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlarm(PAlarmEntry alarm) {
        if (alarm != null) {
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                this.myCurrentAlarms.add(alarm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlarms(List<PAlarmEntry> alarms) {
        if (alarms != null) {
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                this.myCurrentAlarms.addAll(alarms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlarm(PAlarmEntry alarm) {
        if (alarm != null) {
            PAlarmEntry modelEntry = null;
            int index = 0;
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                index = this.myCurrentAlarms.indexOf(alarm);
                if (-1 != index) {
                    modelEntry = this.myCurrentAlarms.get(index);
                    modelEntry.setStateActive(false);
                    modelEntry.setClearTime(alarm.getClearTime());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlarm(PAlarmEntry alarm) {
        if (alarm != null) {
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                this.myCurrentAlarms.remove(alarm);
            }
        }
    }

    public void clearAlarms(List<PAlarmEntry> alarms) {
        if (alarms != null) {
            for (PAlarmEntry entry : alarms) {
                this.clearAlarm(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PAlarmEntry> clearAlarms(Object application, String source) {
        if (application != null) {
            ArrayList<PAlarmEntry> removedAlarms = new ArrayList<PAlarmEntry>();
            List<PAlarmEntry> list = this.myCurrentAlarms;
            synchronized (list) {
                for (PAlarmEntry entry : this.myCurrentAlarms) {
                    if (!application.equals(entry.getApplication())) continue;
                    if (source != null) {
                        String entrySource = entry.getSource();
                        if (!source.equalsIgnoreCase(entrySource)) continue;
                        this.clearAlarmInModel(null, entry);
                        removedAlarms.add(entry);
                        continue;
                    }
                    this.clearAlarmInModel(null, entry);
                    removedAlarms.add(entry);
                }
            }
            return removedAlarms;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModel() {
        List<PAlarmEntry> list = this.myCurrentAlarms;
        synchronized (list) {
            this.myCurrentAlarms.clear();
        }
    }

    public List<PAlarmEntry> getUnfilteredAlarms() {
        return Collections.unmodifiableList(this.myCurrentAlarms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PAlarmEntry getAlarmInstance(PAlarmEntry alarm) {
        List<PAlarmEntry> list = this.myCurrentAlarms;
        synchronized (list) {
            for (PAlarmEntry entry : this.myCurrentAlarms) {
                if (!alarm.equals(entry)) continue;
                return entry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PAlarmEntry> getAllActiveAlarms() {
        ArrayList<PAlarmEntry> activeAlarms = new ArrayList<PAlarmEntry>();
        List<PAlarmEntry> list = this.myCurrentAlarms;
        synchronized (list) {
            for (PAlarmEntry alarm : this.myCurrentAlarms) {
                if (!alarm.isActive()) continue;
                activeAlarms.add(alarm);
            }
        }
        return activeAlarms;
    }

    private void clearAlarmInModel(Calendar clearTime, PAlarmEntry entry) {
        Calendar cal = clearTime;
        if (clearTime == null) {
            TimeZone tz = entry.getTime().getTimeZone();
            cal = Calendar.getInstance(tz);
            cal.setTime(new Date());
            entry.setClearTimingSource(1);
        }
        entry.setStateActive(false);
        entry.setClearTime(cal);
    }
}

