/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.alarm;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.widgets.text.TimestampFormatter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class PAlarmUtils {
    private static DateFormat myDateFormat = TimestampFormatter.getLongFormatter();
    private static DateFormat myCurrentTimeDateFormat = TimestampFormatter.getLongFormatter();
    private static ResourceBundle myResourceBundle = I18n.getI18n().getBundle(PAlarmUtils.class);

    private PAlarmUtils() {
    }

    public static synchronized void setDateFormat(DateFormat dateFormat) {
        myDateFormat = dateFormat;
        myCurrentTimeDateFormat = (DateFormat)myDateFormat.clone();
        myCurrentTimeDateFormat.setCalendar(Calendar.getInstance(myResourceBundle.getLocale()));
    }

    public static DateFormat getDateFormat() {
        return myDateFormat;
    }

    public static void setResourceBundle(ResourceBundle resourceBundle) {
        myResourceBundle = resourceBundle;
    }

    public static synchronized String localiseTime(Calendar calendar) {
        if (calendar != null && myDateFormat != null) {
            myDateFormat.setCalendar(calendar);
            Object[] params = new Object[]{myDateFormat.format(calendar.getTime())};
            try {
                return MessageFormat.format(myResourceBundle.getString("PAlarmPrinter.AlarmTime_Text"), params);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static synchronized String getTime() {
        return myCurrentTimeDateFormat.format(new Date(System.currentTimeMillis()));
    }

    public static synchronized String getTimeStamp(Calendar cal) {
        if (cal == null) {
            return "";
        }
        myDateFormat.setCalendar(cal);
        return myDateFormat.format(cal.getTime());
    }

    public static synchronized String getTimezoneText(TimeZone givenTimeZone) {
        long offset;
        String sign = "+";
        String hours = "";
        String minutes = "";
        String dst = "";
        TimeZone timeZone = givenTimeZone;
        if (timeZone == null) {
            timeZone = myDateFormat.getTimeZone();
        }
        if ((offset = (long)timeZone.getRawOffset()) < 0L) {
            offset = -offset;
            sign = "-";
        }
        Date offsetDate = new Date(offset);
        Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        gmtCalendar.setTime(offsetDate);
        int intHours = gmtCalendar.get(11);
        hours = intHours < 10 ? "0" + String.valueOf(intHours) : String.valueOf(intHours);
        int intMinutes = gmtCalendar.get(12);
        minutes = intMinutes < 10 ? "0" + String.valueOf(intMinutes) : String.valueOf(intMinutes);
        if (timeZone.inDaylightTime(myDateFormat.getCalendar().getTime())) {
            dst = " " + myResourceBundle.getString("PAlarmView.Column.Time.DST_Text");
        }
        return " " + myResourceBundle.getString("PAlarmView.Column.Time.GMT_Text") + " " + sign + hours + minutes + dst;
    }
}

