/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.event;

import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.event.EventTransmitter;
import com.nokia.em.poseidon.frameworks.event.SpecificEventProcessor;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.util.EventObject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class EventHandler {
    protected Set<EventProcessor> myProcessors;
    protected ThreadPool myThreadPool = ThreadPool.getInstance();

    public EventHandler() {
        this.myProcessors = new CopyOnWriteArraySet<EventProcessor>();
    }

    public void sendAsynchronousEvent(EventObject event) {
        for (EventProcessor processor : this.myProcessors) {
            if (!this.isWillingToProcess(processor, event)) continue;
            this.myThreadPool.execute(new EventTransmitter(processor, event, "Thread for " + event.getClass()));
        }
    }

    public void sendSynchronousEvent(EventObject event) {
        for (EventProcessor processor : this.myProcessors) {
            if (!this.isWillingToProcess(processor, event)) continue;
            processor.processEvent(event);
        }
    }

    public void addProcessor(EventProcessor processor) {
        SpecificEventProcessor spe;
        if (processor instanceof SpecificEventProcessor && ((spe = (SpecificEventProcessor)processor).getEventsOfInterest() == null || spe.getSourcesOfInterest() == null)) {
            throw new IllegalArgumentException("Events of interest or sources of interest cannot be null");
        }
        this.myProcessors.add(processor);
    }

    public void removeProcessor(EventProcessor processor) {
        this.myProcessors.remove(processor);
    }

    protected boolean isWillingToProcess(EventProcessor processor, EventObject event) {
        if (processor instanceof SpecificEventProcessor) {
            SpecificEventProcessor spe = (SpecificEventProcessor)processor;
            return !(!spe.getEventsOfInterest().contains(event.getClass()) && !spe.getEventsOfInterest().contains(SpecificEventProcessor.ALL) || !spe.getSourcesOfInterest().contains(event.getSource().getClass()) && !spe.getSourcesOfInterest().contains(SpecificEventProcessor.ALL));
        }
        return true;
    }
}

