/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n;

import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundleGroup;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundleLink;
import com.nokia.em.poseidon.frameworks.i18n.ResourceCacheManager;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public final class I18n {
    private static final String BASE_BUNDLE_ID = "base";
    private static final String PACKAGE_WILDCARD_POSTFIX = ".*";
    private static I18n myInstance = new I18n();
    private ResourceCacheManager myResourceCacheManager;
    private Map<String, ResourceBundle> myResourceBundles = new ConcurrentHashMap<String, ResourceBundle>();
    private final ResourceBundle myBaseBundle;
    private Map<String, Set<ResourceBundle>> myAssociationMap = new ConcurrentHashMap<String, Set<ResourceBundle>>();

    public static I18n getI18n() {
        return myInstance;
    }

    private I18n() {
        this.myBaseBundle = new ResourceBundleGroup(BASE_BUNDLE_ID);
        this.myResourceBundles.put(BASE_BUNDLE_ID, this.myBaseBundle);
        this.myResourceCacheManager = new ResourceCacheManager();
        this.myBaseBundle.setResourceCacheManager(this.myResourceCacheManager);
    }

    public ResourceBundle getBaseBundle() {
        return this.myBaseBundle;
    }

    public ResourceBundle getBaseBundle(Locale locale) {
        this.myBaseBundle.setLocale(locale);
        return this.myBaseBundle;
    }

    public ResourceBundle getBundle(String bundleName) {
        if (bundleName == null || bundleName.length() == 0) {
            throw new IllegalArgumentException("Invalid bundle name: " + bundleName);
        }
        ResourceBundle bundle = this.myResourceBundles.get(bundleName);
        if (bundle == null) {
            bundle = this.myBaseBundle;
        }
        return bundle;
    }

    public ResourceBundle getBundle(String bundleName, Locale locale) {
        ResourceBundle bundle = this.getBundle(bundleName);
        bundle.setLocale(locale);
        return bundle;
    }

    public ResourceBundle getBundle(Class<?> clazz) {
        ResourceBundle requestedBundle;
        Set<ResourceBundle> associatedBundles;
        String className = clazz.getName();
        if (this.myAssociationMap.get(className) == null) {
            for (String associationName : this.myAssociationMap.keySet()) {
                if (!this.isParentPackage(className, associationName)) continue;
                Set<ResourceBundle> parentBundles = this.myAssociationMap.get(associationName);
                for (ResourceBundle bundle : parentBundles) {
                    this.addResourceBundleAssociation(className, bundle);
                }
            }
        }
        if ((associatedBundles = this.myAssociationMap.get(className)) == null || associatedBundles.size() == 0) {
            requestedBundle = this.myBaseBundle;
        } else {
            String bundleName = className.replace('.', '_');
            requestedBundle = new ResourceBundleGroup(bundleName);
            for (ResourceBundle bundle : associatedBundles) {
                ResourceBundleLink symbolicLink = new ResourceBundleLink(bundle);
                symbolicLink.setParentBundle(requestedBundle);
                requestedBundle.addChildBundle(symbolicLink);
            }
            requestedBundle.setResourceCacheManager(I18n.getI18n().getResourceCacheManager());
        }
        return requestedBundle;
    }

    public ResourceBundle getBundle(Class<?> clazz, Locale locale) {
        ResourceBundle bundle = this.getBundle(clazz);
        bundle.setLocale(locale);
        return bundle;
    }

    public void addResourceBundle(ResourceBundle bundle, ResourceBundle parentBundle) {
        if (this.myResourceBundles.containsKey(bundle.getName())) {
            this.myResourceBundles.remove(bundle.getName());
        } else {
            if (parentBundle == null) {
                bundle.setParentBundle(this.myBaseBundle);
            } else {
                bundle.setParentBundle(parentBundle);
            }
            bundle.setResourceCacheManager(this.myResourceCacheManager);
            this.myResourceBundles.put(bundle.getName(), bundle);
        }
    }

    public void addResourceBundleAssociation(String classOrPackageName, ResourceBundle bundle) {
        if (!this.myAssociationMap.containsKey(classOrPackageName)) {
            CopyOnWriteArraySet<ResourceBundle> emptyBundleSet = new CopyOnWriteArraySet<ResourceBundle>();
            emptyBundleSet.add(bundle);
            this.myAssociationMap.put(classOrPackageName, emptyBundleSet);
        } else {
            Set<ResourceBundle> bundleSet = this.myAssociationMap.get(classOrPackageName);
            bundleSet.add(bundle);
        }
    }

    public ResourceCacheManager getResourceCacheManager() {
        return this.myResourceCacheManager;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        sb.append(this.getClass().getName());
        sb.append(lineSeparator);
        sb.append("Resource bundles:");
        sb.append(lineSeparator);
        for (String bundleName : this.myResourceBundles.keySet()) {
            sb.append(this.myResourceBundles.get(bundleName));
            sb.append(lineSeparator);
        }
        sb.append("Class and package associations:");
        sb.append(lineSeparator);
        for (String classOrPackageName : this.myAssociationMap.keySet()) {
            sb.append(classOrPackageName);
            sb.append(" <-> ");
            for (ResourceBundle bundle : this.myAssociationMap.get(classOrPackageName)) {
                sb.append(String.valueOf(bundle.getName()) + ", ");
            }
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    @Deprecated
    public void resetSingleton() {
        for (ResourceBundle bundle : this.myResourceBundles.values()) {
            bundle.clear();
        }
        this.myResourceBundles.clear();
        this.myAssociationMap.clear();
    }

    public void clearResources() {
        this.myAssociationMap.clear();
        this.myResourceBundles.clear();
        this.myBaseBundle.removeChildBundles();
        this.myBaseBundle.clear();
    }

    private boolean isParentPackage(String packageName, String parentPackageName) {
        boolean retVal = false;
        if (packageName.startsWith(this.cutWildCardPostfix(parentPackageName))) {
            retVal = true;
        }
        return retVal;
    }

    private String cutWildCardPostfix(String packageName) {
        if (packageName.endsWith(PACKAGE_WILDCARD_POSTFIX)) {
            return packageName.substring(0, packageName.length() - 2);
        }
        return packageName;
    }
}

