/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n;

import com.nokia.em.poseidon.frameworks.i18n.ConfigurationFileParsingException;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.PropertiesBundle;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundleGroup;
import com.nokia.em.poseidon.frameworks.i18n.localizer.IObjectLocalizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class I18nConfigurator {
    private static final String TAG_RESOURCE_BUNDLE = "resourcebundle";
    private static final String TAG_RESOURCE_BUNDLE_NAME = "name";
    private static final String TAG_RESOURCE_BUNDLE_FILE_NAME = "filename";
    private static final String TAG_RESOURCE_BUNDLE_FILE_EXTENSION = "file-extension";
    private static final String TAG_RESOURCE_BUNDLE_PRIORITY = "priority";
    private static final String TAG_RESOURCE_BUNDLE_PARENT = "parent";
    private static final String TAG_RESOURCE_BUNDLE_TRIMMING = "trimming";
    private static final String TAG_ASSOCIATION = "associations";
    private static final String TAG_CLASS_ASSOCIATION = "class";
    private static final String TAG_PACKAGE_ASSOCIATION = "package";
    private static final String TAG_RESOURCE_BUNDLE_GROUP = "resourcebundlegroup";
    private static final String TAG_LOCALE = "locale";
    private static final String TAG_RESOURCE_BUILDER = "resource-builder";
    private static final String TAG_RESOURCE_TYPE = "resource-type";
    private static final String TAG_BUILDER_CLASS = "builder-class";
    private static final String TAG_LOCALIZER = "localizer";
    private static final String TAG_LOCALIZER_NAME = "name";
    private static final String TAG_LOCALIZER_CLASS = "class";
    private static final String TAG_LOCALIZER_PROPERTY = "property";
    private static final String TAG_OBJECT_LOCALIZER = "object-localizer";
    private static final String TAG_OBJECT_LOCALIZER_TARGET = "target-class";
    private static final String TAG_OBJECT_LOCALIZER_CLASS = "localizer-class";
    private static I18nConfigurator myInstance;
    private DocumentBuilder myDocumentBuilder;
    private Document myDocumentTree;
    private Locale myLocale;
    private ReentrantLock myLock = new ReentrantLock();

    private I18nConfigurator() throws ConfigurationFileParsingException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            this.myDocumentBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationFileParsingException("Initialization of DOM parser failed: " + e.getMessage(), e);
        }
    }

    public static synchronized I18nConfigurator getI18nConfigurator() throws ConfigurationFileParsingException {
        if (myInstance == null) {
            myInstance = new I18nConfigurator();
        }
        return myInstance;
    }

    public void loadConfiguration(String configurationFileName) throws ConfigurationFileParsingException {
        try {
            this.myLock.lock();
            I18n i18n = I18n.getI18n();
            this.loadXMLAndBuildDOMTree(configurationFileName);
            this.myLocale = Locale.getDefault();
            this.parseAndSetLocale();
            this.parseAndCreateResourceBundleGroups(i18n);
            this.parseAndCreateResourceBundles(i18n);
            this.parseAndSetResourceBuilders(i18n);
            this.parseAndSetLocalizers();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void loadXMLAndBuildDOMTree(String configurationFileName) throws ConfigurationFileParsingException {
        block11: {
            InputStream stream = null;
            try {
                try {
                    URL configFileURL = this.getClass().getResource(configurationFileName);
                    if (configFileURL != null) {
                        Logger.getLogger(this.getClass()).debug("Loading configuration file: " + configurationFileName);
                        stream = configFileURL.openStream();
                        this.myDocumentTree = this.myDocumentBuilder.parse(stream);
                        break block11;
                    }
                    throw new ConfigurationFileParsingException("Can not find configuration file: " + configurationFileName);
                }
                catch (SAXException e) {
                    throw new ConfigurationFileParsingException("Error parsing configuration file " + configurationFileName + ". Parser exception encountered: " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new ConfigurationFileParsingException("Configuration file " + configurationFileName + " not found or can not be opened ," + e.getMessage(), e);
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void parseAndSetLocale() throws ConfigurationFileParsingException {
        String localeString;
        NodeList localeNodes = this.myDocumentTree.getElementsByTagName(TAG_LOCALE);
        if (localeNodes.getLength() == 0) {
            return;
        }
        Node localeValueNode = localeNodes.item(0).getFirstChild();
        if (localeValueNode != null) {
            localeString = localeValueNode.getNodeValue();
            if (localeString == null) {
                throw new ConfigurationFileParsingException("Locale value can not be empty");
            }
        } else {
            throw new ConfigurationFileParsingException("Can not parse locale value. Syntax error.");
        }
        this.myLocale = new Locale(localeString);
    }

    private void parseAndCreateResourceBundleGroups(I18n i18n) throws ConfigurationFileParsingException {
        NodeList resourceBundleNodes = this.myDocumentTree.getElementsByTagName(TAG_RESOURCE_BUNDLE_GROUP);
        HashMap<String, String> childParentRelations = new HashMap<String, String>();
        int i = 0;
        while (i < resourceBundleNodes.getLength()) {
            Node bundleNode = resourceBundleNodes.item(i);
            String name = this.getNodeValue(bundleNode, "name");
            String parent = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_PARENT);
            String priority = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_PRIORITY);
            if (name == null || name.length() == 0) {
                throw new ConfigurationFileParsingException("Invalid or missing resource bundle group name: " + name);
            }
            if (parent != null) {
                childParentRelations.put(name, parent);
            }
            List<String> associationList = this.getBundleAssocations(bundleNode);
            ResourceBundleGroup bundleGroup = new ResourceBundleGroup(name);
            i18n.addResourceBundle(bundleGroup, i18n.getBaseBundle());
            this.parseAndSetBundlePriority(bundleGroup, priority);
            for (String association : associationList) {
                i18n.addResourceBundleAssociation(association, bundleGroup);
            }
            ++i;
        }
        this.setResourceBundleParents(i18n, childParentRelations);
    }

    private void parseAndCreateResourceBundles(I18n i18n) throws ConfigurationFileParsingException {
        HashMap<String, String> childParentRelations = new HashMap<String, String>();
        NodeList resourceBundleNodes = this.myDocumentTree.getElementsByTagName(TAG_RESOURCE_BUNDLE);
        int i = 0;
        while (i < resourceBundleNodes.getLength()) {
            Node bundleNode = resourceBundleNodes.item(i);
            String bundleName = this.getNodeValue(bundleNode, "name");
            String bundleFileName = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_FILE_NAME);
            String bundleFileExtension = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_FILE_EXTENSION);
            String bundlePriority = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_PRIORITY);
            String bundleParent = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_PARENT);
            String bundleTrimming = this.getNodeValue(bundleNode, TAG_RESOURCE_BUNDLE_TRIMMING);
            if (bundleName == null || bundleFileName == null) {
                throw new ConfigurationFileParsingException("Invalid or missing resource bundle name or file name tag: " + bundleName + "," + bundleFileName);
            }
            List<String> associationList = this.getBundleAssocations(bundleNode);
            PropertiesBundle bundle = new PropertiesBundle(bundleName, bundleFileName, this.myLocale);
            if (bundleFileExtension != null) {
                bundle.setBundleFileNameExtension(bundleFileExtension);
            }
            i18n.addResourceBundle(bundle, i18n.getBaseBundle());
            this.parseAndSetBundlePriority(bundle, bundlePriority);
            if (bundleParent != null) {
                childParentRelations.put(bundleName, bundleParent);
            }
            if (bundleTrimming != null) {
                bundle.setTrimEnabled(Boolean.valueOf(bundleTrimming));
            }
            for (String association : associationList) {
                i18n.addResourceBundleAssociation(association, bundle);
            }
            ++i;
        }
        this.setResourceBundleParents(i18n, childParentRelations);
    }

    private void parseAndSetResourceBuilders(I18n i18n) throws ConfigurationFileParsingException {
        NodeList builderNodes = this.myDocumentTree.getElementsByTagName(TAG_RESOURCE_BUILDER);
        int i = 0;
        while (i < builderNodes.getLength()) {
            String resourceTypeClass = this.getNodeValue(builderNodes.item(i), TAG_RESOURCE_TYPE);
            String builderClass = this.getNodeValue(builderNodes.item(i), TAG_BUILDER_CLASS);
            if (resourceTypeClass == null || builderClass == null) {
                throw new ConfigurationFileParsingException("Invalid resource builder type or class tag: " + resourceTypeClass + "," + builderClass);
            }
            try {
                i18n.getResourceCacheManager().registerResourceBuilder(Class.forName(resourceTypeClass), Class.forName(builderClass));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationFileParsingException("Can not create resource builder class " + builderClass + " for object type " + resourceTypeClass + ", " + e.getMessage(), e);
            }
            ++i;
        }
    }

    private void parseAndSetLocalizers() throws ConfigurationFileParsingException {
        NodeList localizerNodes = this.myDocumentTree.getElementsByTagName(TAG_LOCALIZER);
        int i = 0;
        while (i < localizerNodes.getLength()) {
            String localizerName = this.getNodeValue(localizerNodes.item(i), "name");
            String localizerClassName = this.getNodeValue(localizerNodes.item(i), "class");
            if (localizerName == null || localizerClassName == null) {
                throw new ConfigurationFileParsingException("Localizer definition missing name or class tag: " + localizerName + "," + localizerClassName);
            }
            try {
                Localizer localizerClass = LocalizerRegistry.lookup(localizerClassName);
                if (localizerClass == null) {
                    localizerClass = (Localizer)Class.forName(localizerClassName).newInstance();
                    LocalizerRegistry.register(localizerName, localizerClass);
                }
                this.parseAndSetLocalizerProperties(localizerNodes.item(i), localizerClass);
                this.parseAndRegisterObjectLocalizers(localizerNodes.item(i), localizerClass);
            }
            catch (Exception e) {
                throw new ConfigurationFileParsingException("Can not initiate localizer class: " + localizerClassName + ". Message = " + e.getMessage(), e);
            }
            ++i;
        }
    }

    private void parseAndSetLocalizerProperties(Node rootNode, Localizer localizer) throws ConfigurationFileParsingException {
        int i = 0;
        while (i < rootNode.getChildNodes().getLength()) {
            Node childNode = rootNode.getChildNodes().item(i);
            if (childNode.getNodeName().equalsIgnoreCase(TAG_LOCALIZER_PROPERTY)) {
                NamedNodeMap attributes = childNode.getAttributes();
                String propertyName = attributes.item(0).getNodeValue();
                String propertyValue = attributes.item(1).getNodeValue();
                if (propertyName != null && propertyValue != null) {
                    localizer.setProperty(propertyName, propertyValue);
                } else {
                    throw new ConfigurationFileParsingException("Invalid property tag. Syntax error.");
                }
            }
            ++i;
        }
    }

    private void parseAndRegisterObjectLocalizers(Node rootNode, Localizer localizer) throws ConfigurationFileParsingException {
        int i = 0;
        while (i < rootNode.getChildNodes().getLength()) {
            Node childNode = rootNode.getChildNodes().item(i);
            if (childNode.getNodeName().equalsIgnoreCase(TAG_OBJECT_LOCALIZER)) {
                String targetClassName = this.getNodeValue(childNode, TAG_OBJECT_LOCALIZER_TARGET);
                String objectLocalizerClassName = this.getNodeValue(childNode, TAG_OBJECT_LOCALIZER_CLASS);
                if (targetClassName == null || objectLocalizerClassName == null) {
                    throw new ConfigurationFileParsingException("Target or class name tag missing from object localizer definition: " + targetClassName + "," + objectLocalizerClassName);
                }
                try {
                    Class<?> localizerClass = Class.forName(targetClassName);
                    IObjectLocalizer objectLocalizer = (IObjectLocalizer)Class.forName(objectLocalizerClassName).newInstance();
                    localizer.registerObjectLocalizer(localizerClass, objectLocalizer);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationFileParsingException("Can not load object localizer class. " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationFileParsingException("Can not load object localizer class. " + e.getMessage(), e);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationFileParsingException("Can not load object localizer class. " + e.getMessage(), e);
                }
            }
            ++i;
        }
    }

    private String getNodeValue(Node rootNode, String nodeName) throws ConfigurationFileParsingException {
        String nodeValue = null;
        if (rootNode != null) {
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element child;
                if (childNodes.item(i).getNodeType() == 1 && (child = (Element)childNodes.item(i)).getTagName().equals(nodeName)) {
                    Node valueNode = child.getFirstChild();
                    if (valueNode != null) {
                        nodeValue = valueNode.getNodeValue();
                    } else {
                        throw new ConfigurationFileParsingException("Can not find value for element " + nodeName);
                    }
                }
                ++i;
            }
        }
        return nodeValue;
    }

    private List<String> getNodeValues(Node rootNode, String nodeName) throws ConfigurationFileParsingException {
        ArrayList<String> returnValueList = new ArrayList<String>();
        if (rootNode != null) {
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element child;
                if (childNodes.item(i).getNodeType() == 1 && (child = (Element)childNodes.item(i)).getTagName().equals(nodeName)) {
                    Node valueNode = child.getFirstChild();
                    if (valueNode != null) {
                        String nodeValue = valueNode.getNodeValue();
                        returnValueList.add(nodeValue);
                    } else {
                        throw new ConfigurationFileParsingException("Can not find value for element " + nodeName);
                    }
                }
                ++i;
            }
        }
        return returnValueList;
    }

    private Node moveToNode(Node rootNode, String nodeName) {
        Node searchResult = null;
        NodeList childNodes = rootNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element child;
            if (childNodes.item(i).getNodeType() == 1 && (child = (Element)childNodes.item(i)).getTagName().equals(nodeName)) {
                searchResult = childNodes.item(i);
                break;
            }
            ++i;
        }
        return searchResult;
    }

    private void setResourceBundleParents(I18n i18n, Map<String, String> childParentMap) {
        for (String childName : childParentMap.keySet()) {
            String parentName = childParentMap.get(childName);
            ResourceBundle childBundle = i18n.getBundle(childName);
            ResourceBundle parentBundle = i18n.getBundle(parentName);
            if (parentBundle.equals(i18n.getBaseBundle())) continue;
            childBundle.setParentBundle(parentBundle);
        }
    }

    private List<String> getBundleAssocations(Node rootNode) throws ConfigurationFileParsingException {
        ArrayList<String> associationList = new ArrayList<String>();
        try {
            List<String> classAssociations = this.getNodeValues(this.moveToNode(rootNode, TAG_ASSOCIATION), "class");
            List<String> packageAssociations = this.getNodeValues(this.moveToNode(rootNode, TAG_ASSOCIATION), TAG_PACKAGE_ASSOCIATION);
            associationList.addAll(classAssociations);
            associationList.addAll(packageAssociations);
        }
        catch (ConfigurationFileParsingException e) {
            throw new ConfigurationFileParsingException("Error parsing class or package association tag");
        }
        return associationList;
    }

    private void parseAndSetBundlePriority(ResourceBundle bundle, String priorityString) {
        if (bundle != null && priorityString != null) {
            int priority = 5;
            if ("max".equalsIgnoreCase(priorityString)) {
                priority = 10;
            } else if ("min".equalsIgnoreCase(priorityString)) {
                priority = 0;
            } else if ("high".equalsIgnoreCase(priorityString)) {
                priority = 7;
            } else if ("low".equalsIgnoreCase(priorityString)) {
                priority = 3;
            } else {
                try {
                    priority = Integer.valueOf(priorityString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            bundle.setPriority(priority);
        }
    }
}

