/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesBundle
extends ResourceBundle {
    private static final String FILENAME_ELEMENT_SEPARATOR = "_";
    private Map<String, String> myResourceMap;

    public PropertiesBundle(String bundleName, String bundleFileName, Locale locale) {
        super(bundleName, bundleFileName, locale);
        this.init();
    }

    @Override
    public void addChildBundle(ResourceBundle child) {
    }

    @Override
    public void clear() {
        if (this.myResourceMap != null) {
            this.myResourceMap.clear();
        }
    }

    public PropertiesBundle(String bundleName, String bundleFileName) {
        super(bundleName, bundleFileName, Locale.getDefault());
        this.init();
    }

    private void init() {
        this.myResourceCacheManager = I18n.getI18n().getResourceCacheManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadValues() {
        PropertiesBundle propertiesBundle = this;
        synchronized (propertiesBundle) {
            Properties bundle;
            block17: {
                String bundleFileName = this.getBundleFileName();
                bundle = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = this.findBundleFileStream(bundleFileName);
                        if (is != null) {
                            bundle.load(is);
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).error("Cannot load bundle file: " + bundleFileName + ". Message = " + e.getMessage(), e);
                        try {
                            is.close();
                            is = null;
                        }
                        catch (Exception exception) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    is.close();
                    is = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HashMap<String, String> keyValueMap = new HashMap<String, String>(bundle.keySet().size());
            Enumeration<Object> enums = bundle.keys();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                if (this.myTrimEnabled) {
                    keyValueMap.put(key, ((String)bundle.get(key)).trim());
                    continue;
                }
                keyValueMap.put(key, (String)bundle.get(key));
            }
            this.myResourceMap = keyValueMap;
        }
    }

    @Override
    public Object getObject(String key, Class classType) {
        if (this.myResourceMap == null) {
            this.loadValues();
        }
        String keyValue = this.myResourceMap.get(key);
        if (classType == String.class) {
            return keyValue;
        }
        Object obj = null;
        if (keyValue != null && classType != String.class) {
            obj = this.myResourceCacheManager.getResource(keyValue, classType);
        }
        return obj;
    }

    private String getBundleFileName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.myBundleFileName);
        sb.append(FILENAME_ELEMENT_SEPARATOR);
        sb.append(this.myLocale);
        sb.append(this.myBundleFileNameExtension);
        return sb.toString();
    }

    private InputStream findBundleFileStream(String bundleFileName) {
        String defaultBundleFileName;
        InputStream is;
        block12: {
            is = this.getClass().getResourceAsStream(bundleFileName);
            if (is == null && !bundleFileName.startsWith("/")) {
                is = this.getClass().getResourceAsStream("/" + bundleFileName);
            }
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream(bundleFileName);
            }
            if (is == null) {
                URL url = null;
                URLConnection urlConnection = null;
                try {
                    try {
                        url = new URL(bundleFileName);
                        urlConnection = url.openConnection();
                        urlConnection.setUseCaches(false);
                        is = urlConnection.getInputStream();
                    }
                    catch (Exception exception) {
                        if (is == null) {
                            url = null;
                            urlConnection = null;
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (is == null) {
                        url = null;
                        urlConnection = null;
                    }
                    throw throwable;
                }
                if (is == null) {
                    url = null;
                    urlConnection = null;
                }
            }
        }
        if (is == null && !bundleFileName.equals(defaultBundleFileName = String.valueOf(this.myBundleFileName) + ".properties")) {
            return this.findBundleFileStream(defaultBundleFileName);
        }
        return is;
    }
}

