/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n;

import com.nokia.em.poseidon.frameworks.i18n.ResourceBundleGroup;
import com.nokia.em.poseidon.frameworks.i18n.ResourceCacheManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class ResourceBundle
implements Comparable<ResourceBundle> {
    public static final int PRIORITY_MIN = 0;
    public static final int PRIORITY_MAX = 10;
    public static final int PRIORITY_HIGH = 7;
    public static final int PRIORITY_LOW = 3;
    public static final int PRIORITY_DEFAULT = 5;
    protected static final String HIERARCHYCONNECTOR_IDSTR = ".";
    protected static final String DEFAULT_BUNDLE_FILE_EXTENSION = ".properties";
    protected String myBundleName;
    protected String myBundleFileName;
    protected String myBundleFileNameExtension;
    protected Locale myLocale;
    protected ResourceBundle myParentBundle;
    protected List<ResourceBundle> myChildBundles;
    protected ResourceCacheManager myResourceCacheManager;
    protected int myPriority;
    protected boolean myTrimEnabled;

    public ResourceBundle(String bundleName, String bundleFileName, Locale locale) {
        this.myBundleName = bundleName;
        this.myBundleFileName = bundleFileName;
        this.myLocale = locale != null ? locale : Locale.getDefault();
        this.myBundleFileNameExtension = DEFAULT_BUNDLE_FILE_EXTENSION;
        this.myPriority = 5;
        this.myTrimEnabled = false;
        this.myChildBundles = new ArrayList<ResourceBundle>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildBundle(ResourceBundle child) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            if (!this.myChildBundles.contains(child)) {
                this.myChildBundles.add(child);
            }
            Collections.sort(this.myChildBundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildBundle(ResourceBundle child) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            this.myChildBundles.remove(child);
            Collections.sort(this.myChildBundles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildBundles() {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            for (ResourceBundle childBundle : this.myChildBundles) {
                childBundle.removeChildBundles();
            }
            this.myChildBundles.clear();
        }
    }

    public List<ResourceBundle> getChildBundles() {
        return this.myChildBundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocale(Locale loc) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            this.myLocale = loc;
            for (ResourceBundle childBundle : this.myChildBundles) {
                childBundle.setLocale(loc);
            }
        }
    }

    public Locale getLocale() {
        return this.myLocale;
    }

    public ResourceBundle getParentBundle() {
        return this.myParentBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentBundle(ResourceBundle parent) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            if (this.myParentBundle != null) {
                this.myParentBundle.removeChildBundle(this);
            }
            this.myParentBundle = parent;
            if (this.myParentBundle != null) {
                this.myParentBundle.addChildBundle(this);
            }
        }
    }

    public String getName() {
        return this.myBundleName;
    }

    public String getFileName() {
        return this.myBundleFileName;
    }

    public boolean isTrimmingEnabled() {
        return this.myTrimEnabled;
    }

    public void setTrimEnabled(boolean trimmingEnabled) {
        this.myTrimEnabled = trimmingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceCacheManager(ResourceCacheManager resourceCacheManager) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            this.myResourceCacheManager = resourceCacheManager;
        }
    }

    public ResourceCacheManager getResourceCacheManager() {
        return this.myResourceCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundleFileNameExtension(String extension) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            this.myBundleFileNameExtension = extension;
        }
    }

    public int getPriority() {
        return this.myPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(int priority) {
        ResourceBundle resourceBundle = this;
        synchronized (resourceBundle) {
            this.myPriority = priority >= 0 ? priority : 5;
        }
    }

    public String toString() {
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(this.myBundleName);
        ResourceBundle currentBundle = this;
        while (currentBundle.myParentBundle != null) {
            nameBuffer.insert(0, HIERARCHYCONNECTOR_IDSTR);
            currentBundle = currentBundle.myParentBundle;
            nameBuffer.insert(0, currentBundle.myBundleName);
        }
        nameBuffer.append(", ");
        nameBuffer.append("locale: ");
        nameBuffer.append(this.myLocale);
        nameBuffer.append(", ");
        if (this.getClass().equals(ResourceBundleGroup.class)) {
            nameBuffer.append("bundle group");
        } else {
            nameBuffer.append("base file: ");
            nameBuffer.append(this.myBundleFileName);
            nameBuffer.append(", extension: ");
            nameBuffer.append(this.myBundleFileNameExtension);
        }
        nameBuffer.append(", ");
        nameBuffer.append("childs = ");
        for (ResourceBundle child : this.myChildBundles) {
            nameBuffer.append(String.valueOf(child.getName()) + ",");
        }
        return nameBuffer.toString();
    }

    public ImageIcon getImageIcon(String key) {
        ImageIcon resultIcon = (ImageIcon)this.getObject(key, ImageIcon.class);
        if (resultIcon == null) {
            resultIcon = (ImageIcon)this.myResourceCacheManager.getNotFoundObject(ImageIcon.class);
            resultIcon.setDescription(key);
        }
        return resultIcon;
    }

    public ImageIcon getUniqueImageIcon(String key) {
        Image sourceImage;
        ImageIcon sourceIcon = (ImageIcon)this.getObject(key, ImageIcon.class);
        ImageIcon resultIcon = null;
        if (sourceIcon != null && (sourceImage = sourceIcon.getImage()) != null) {
            resultIcon = new ImageIcon(sourceIcon.getImage().getScaledInstance(sourceImage.getWidth(null), sourceImage.getHeight(null), 1));
        }
        if (resultIcon == null) {
            resultIcon = (ImageIcon)this.myResourceCacheManager.getNotFoundObject(ImageIcon.class);
            resultIcon.setDescription(key);
        }
        return resultIcon;
    }

    public Color getColor(String key) {
        Color resultColor = (Color)this.getObject(key, Color.class);
        if (resultColor == null) {
            resultColor = (Color)this.myResourceCacheManager.getNotFoundObject(Color.class);
        }
        return resultColor;
    }

    public Font getFont(String key) {
        Font resultFont = (Font)this.getObject(key, Font.class);
        if (resultFont == null) {
            resultFont = (Font)this.myResourceCacheManager.getNotFoundObject(Font.class);
        }
        return resultFont;
    }

    public String getString(String key) {
        String resultString = (String)this.getObject(key, String.class);
        if (resultString == null) {
            resultString = key;
        }
        return resultString;
    }

    public int getMnemonic(String key) {
        String resultStr = this.getString(key);
        if (resultStr.equals(key)) {
            return (Integer)this.myResourceCacheManager.getNotFoundObject(Integer.class);
        }
        char mnemonicChar = resultStr.charAt(0);
        return Character.toUpperCase(mnemonicChar);
    }

    public KeyStroke getAccelerator(String key) {
        KeyStroke result = (KeyStroke)this.getObject(key, KeyStroke.class);
        if (result == null) {
            result = (KeyStroke)this.myResourceCacheManager.getNotFoundObject(KeyStroke.class);
        }
        return result;
    }

    @Override
    public int compareTo(ResourceBundle bundle) {
        Integer anotherPriority = bundle.myPriority;
        return anotherPriority.compareTo(this.myPriority);
    }

    public void clear() {
    }

    protected abstract void loadValues();

    public abstract Object getObject(String var1, Class var2);
}

