/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n;

import com.nokia.em.poseidon.frameworks.i18n.IResourceBuilder;
import com.nokia.em.poseidon.frameworks.i18n.ResourceCache;
import com.nokia.em.poseidon.frameworks.i18n.resourcebuilders.ColorBuilder;
import com.nokia.em.poseidon.frameworks.i18n.resourcebuilders.FontBuilder;
import com.nokia.em.poseidon.frameworks.i18n.resourcebuilders.ImageIconBuilder;
import com.nokia.em.poseidon.frameworks.i18n.resourcebuilders.KeyStrokeBuilder;
import com.nokia.laf.NetLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ResourceCacheManager {
    private ResourceCache<String, Object> myCache = new ResourceCache();
    private Map<Class, IResourceBuilder> myRegisteredResourceBuilders = new HashMap<Class, IResourceBuilder>();
    private Map<Class, Object> myNotFoundObjects;

    public ResourceCacheManager() {
        this.registerResourceBuilder(ImageIcon.class, ImageIconBuilder.class);
        this.registerResourceBuilder(Font.class, FontBuilder.class);
        this.registerResourceBuilder(Color.class, ColorBuilder.class);
        this.registerResourceBuilder(KeyStroke.class, KeyStrokeBuilder.class);
    }

    public Object getResource(String name, Class type) {
        IResourceBuilder builder;
        Object requestedResource = this.myCache.get(name);
        if (requestedResource == null && (builder = this.myRegisteredResourceBuilders.get(type)) != null && (requestedResource = builder.buildResource(name)) != null) {
            this.myCache.put(name, requestedResource);
        }
        return requestedResource;
    }

    public void registerResourceBuilder(Class resourceType, Class builderClass) {
        try {
            IResourceBuilder resourceBuilderInstance = (IResourceBuilder)builderClass.newInstance();
            this.myRegisteredResourceBuilders.put(resourceType, resourceBuilderInstance);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot create resource builder: " + builderClass.getName() + " - " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot create resource builder: " + builderClass.getName() + " - " + e.toString());
        }
    }

    public void registerResourceBuilder(Class resourceType, IResourceBuilder resourceBuilder) {
        this.myRegisteredResourceBuilders.put(resourceType, resourceBuilder);
    }

    public void setNotFoundObject(Class clazz, Object object) {
        if (this.myNotFoundObjects == null) {
            this.buildNotFoundObjects();
        }
        this.myNotFoundObjects.put(clazz, object);
    }

    public synchronized Object getNotFoundObject(Class clazz) {
        if (this.myNotFoundObjects == null) {
            this.buildNotFoundObjects();
        }
        return this.myNotFoundObjects.get(clazz);
    }

    private void buildNotFoundObjects() {
        this.myNotFoundObjects = new HashMap<Class, Object>();
        this.setNotFoundObject(Color.class, Color.PINK);
        this.setNotFoundObject(Font.class, NetLookAndFeel.getUserTextFont().deriveFont(10.0f));
        this.setNotFoundObject(ImageIcon.class, this.buildNotFoundImageIcon());
        this.setNotFoundObject(KeyStroke.class, KeyStroke.getKeyStroke('X'));
        this.setNotFoundObject(Integer.class, -1);
    }

    private ImageIcon buildNotFoundImageIcon() {
        return new ImageIcon(this.getClass().getResource("/com/nokia/em/poseidon/frameworks/i18n/res/notfound.gif"));
    }
}

