/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n.localizer;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.IObjectLocalizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.ObjectHierarchyIterator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Localizer
implements Cloneable {
    private static final String SET_METHOD_PREFIX = "set";
    private Map<Class, IObjectLocalizer> myObjectLocalizerMap = new HashMap<Class, IObjectLocalizer>();
    protected ResourceBundle myResourceBundle;

    public Localizer() {
        this.myResourceBundle = I18n.getI18n().getBaseBundle();
    }

    public Localizer(ResourceBundle bundle) {
        this.myResourceBundle = bundle;
    }

    public void registerObjectLocalizer(Class objectClass, IObjectLocalizer localizer) {
        this.myObjectLocalizerMap.put(objectClass, localizer);
    }

    public void unregisterObjectLocalizer(Class objectClass) {
        this.myObjectLocalizerMap.remove(objectClass);
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        if (bundle != null) {
            this.myResourceBundle = bundle;
        }
    }

    public void setProperty(String propertyName, Object propertyValue) {
        Field field = this.findClassField(propertyName);
        if (field != null) {
            try {
                field.set(this, propertyValue);
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else {
            Method method = this.findSetMethod(propertyName);
            if (method != null) {
                Object[] methodParams = new Object[]{propertyValue};
                try {
                    method.invoke((Object)this, methodParams);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }

    public void localizeObjectHierarchy(ObjectHierarchyIterator hierarchyIterator) {
        while (hierarchyIterator.hasNext()) {
            Object obj = hierarchyIterator.nextObject();
            this.localizeObject(obj);
        }
    }

    public void localizeObject(Object object) {
        IObjectLocalizer localizer;
        Class<?> classType = object.getClass();
        if (this.myObjectLocalizerMap.containsKey(classType) && (localizer = this.myObjectLocalizerMap.get(classType)) != null) {
            localizer.localize(object, this);
        }
        for (Class parentClassType : this.myObjectLocalizerMap.keySet()) {
            if (parentClassType.equals(classType) || !parentClassType.isAssignableFrom(classType)) continue;
            IObjectLocalizer localizer2 = this.myObjectLocalizerMap.get(parentClassType);
            localizer2.localize(object, this);
        }
    }

    public Object clone() {
        Localizer cloneObject = null;
        try {
            cloneObject = (Localizer)super.clone();
            cloneObject.myObjectLocalizerMap = new HashMap<Class, IObjectLocalizer>(this.myObjectLocalizerMap);
            cloneObject.myResourceBundle = I18n.getI18n().getBaseBundle();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloneObject;
    }

    private Field findClassField(String fieldName) {
        Field[] classFields;
        Field resultField = null;
        Field[] fieldArray = classFields = this.getClass().getFields();
        int n = classFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field classField = fieldArray[n2];
            if (classField.getName().equalsIgnoreCase(fieldName)) {
                resultField = classField;
                break;
            }
            ++n2;
        }
        return resultField;
    }

    private Method findSetMethod(String fieldName) {
        Method resultMethod = null;
        String methodName = SET_METHOD_PREFIX + fieldName;
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method classMethod = methodArray[n2];
            if (classMethod.getName().equalsIgnoreCase(methodName)) {
                resultMethod = classMethod;
                break;
            }
            ++n2;
        }
        return resultMethod;
    }
}

