/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.i18n.localizer;

import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.ActionLocalizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingLocalizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;

public class LocalizerRegistry {
    public static final String SWING_LOCALIZER = "swing";
    public static final String ACTION_LOCALIZER = "action";
    public static final String EMPTY_LOCALIZER = "empty";
    private static Map<String, Localizer> myLocalizerRegistry = new ConcurrentHashMap<String, Localizer>();

    static {
        myLocalizerRegistry.put(SWING_LOCALIZER, new SwingLocalizer());
        myLocalizerRegistry.put(EMPTY_LOCALIZER, new Localizer());
    }

    public static Localizer lookup(String localizerName) {
        if (myLocalizerRegistry.get(localizerName) != null) {
            return (Localizer)myLocalizerRegistry.get(localizerName).clone();
        }
        return null;
    }

    public static Localizer lookupAndSetBundle(String localizerName, ResourceBundle bundle) {
        Localizer localizer = LocalizerRegistry.lookup(localizerName);
        if (localizer != null) {
            localizer.setResourceBundle(bundle);
        }
        return localizer;
    }

    public static void register(String localizerName, Localizer localizer) {
        myLocalizerRegistry.put(localizerName, localizer);
    }

    public static void unregister(String localizerName) {
        myLocalizerRegistry.remove(localizerName);
    }

    public static Localizer getSwingLocalizer() {
        return new SwingLocalizer();
    }

    public static Localizer getActionLocalizer() {
        Localizer localizer = new Localizer();
        localizer.registerObjectLocalizer(Action.class, new ActionLocalizer());
        return localizer;
    }

    public static Localizer getEmptyLocalizer() {
        return new Localizer();
    }
}

