/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.model;

import com.nokia.em.poseidon.frameworks.model.Model;
import com.nokia.em.poseidon.frameworks.model.ModelObserver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ModelBase
implements Model,
ModelObserver {
    protected Set<ModelObserver> myObservers = new CopyOnWriteArraySet<ModelObserver>();
    protected List<Model> mySubModels = new LinkedList<Model>();
    protected boolean myActive = true;

    @Override
    public void init() {
    }

    @Override
    public void addObserver(ModelObserver observer) {
        this.myObservers.add(observer);
        if (this.myActive) {
            observer.modelUpdated(this);
        }
    }

    @Override
    public void removeObserver(ModelObserver observer) {
        this.myObservers.remove(observer);
    }

    @Override
    public void addModel(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("Sub-model is null!");
        }
        if (this.mySubModels.contains(model)) {
            throw new IllegalArgumentException("Duplicate sub-model: " + model);
        }
        this.mySubModels.add(model);
        model.addObserver(this);
        this.modelUpdated(this);
    }

    @Override
    public boolean containsModel(Model model) {
        return this.mySubModels.contains(model);
    }

    @Override
    public void removeModel(Model model) {
        this.mySubModels.remove(model);
        model.removeObserver(this);
        this.modelUpdated(this);
    }

    @Override
    public boolean containsObserver(ModelObserver observer) {
        return this.myObservers.contains(observer);
    }

    @Override
    public List<ModelObserver> getObservers() {
        ArrayList<ModelObserver> observers = new ArrayList<ModelObserver>();
        for (ModelObserver o : this.myObservers) {
            observers.add(o);
        }
        return observers;
    }

    @Override
    public void makeActive(boolean activate) {
        this.myActive = activate;
    }

    public boolean isActive() {
        return this.myActive;
    }

    protected void notifyObservers(Model model) {
        if (this.myActive) {
            for (ModelObserver observer : this.myObservers) {
                observer.modelUpdated(model);
            }
        }
    }

    @Override
    public void modelUpdated(Model model) {
        this.notifyObservers(model);
    }
}

