/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.model;

import com.nokia.em.poseidon.frameworks.model.Model;
import com.nokia.em.poseidon.frameworks.model.ModelBase;
import java.util.HashMap;
import java.util.Map;

public class PropertyModel
extends ModelBase {
    protected Map<String, Object> myProperties = new HashMap<String, Object>();
    protected transient String myLastUpdatedKey;

    public synchronized void setProperty(String key, Object value) {
        this.myLastUpdatedKey = key;
        this.myProperties.put(key, value);
        this.modelUpdated(this);
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, (Object)value);
    }

    public void setProperty(String key, float value) {
        this.setProperty(key, new Float(value));
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, (Object)value);
    }

    public boolean hasProperty(String key) {
        boolean found = this.myProperties.containsKey(key);
        if (!found) {
            for (Model model : this.mySubModels) {
                if (model instanceof PropertyModel && (found = ((PropertyModel)model).hasProperty(key))) break;
            }
        }
        return found;
    }

    public Object getProperty(String key) {
        Object found = this.myProperties.get(key);
        if (found == null) {
            for (Model model : this.mySubModels) {
                if (model instanceof PropertyModel && (found = ((PropertyModel)model).getProperty(key)) != null) break;
            }
        }
        return found;
    }

    public Boolean getBooleanProperty(String key) {
        Object b = this.getProperty(key);
        return b == null ? null : (Boolean)b;
    }

    public int getIntProperty(String key) {
        return (Integer)this.getProperty(key);
    }

    public float getFloatProperty(String key) {
        return ((Float)this.getProperty(key)).floatValue();
    }

    public double getDoubleProperty(String key) {
        return (Double)this.getProperty(key);
    }

    public String getStringProperty(String key) {
        return (String)this.getProperty(key);
    }

    public <T> T getProperty(String key, Class<T> clazz) {
        return (T)this.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.myProperties;
    }

    public void clear() {
        this.myProperties.clear();
        this.modelUpdated(this);
    }

    public String getLastUpdatedKey() {
        return this.myLastUpdatedKey;
    }
}

