/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc;

import com.nokia.em.poseidon.frameworks.model.Model;
import com.nokia.em.poseidon.frameworks.model.ModelObserver;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.ControllerEvent;
import com.nokia.em.poseidon.frameworks.mvc.ControllerListener;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.View;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class ControllerBase
implements Controller,
ModelObserver {
    protected Set<ControllerListener> myListeners = new CopyOnWriteArraySet<ControllerListener>();
    protected View myView;
    protected Object myModel;
    protected boolean myIsDestroyed;

    protected void doDestroy() {
        this.myView = null;
        this.myIsDestroyed = true;
        this.myListeners.clear();
    }

    protected void fireControllerEvent(ControllerEvent event) {
        for (ControllerListener listener : this.myListeners) {
            listener.processControllerEvent(event);
        }
    }

    @Override
    public void setView(View view) {
        if (view == this.myView) {
            return;
        }
        if (this.myView != null) {
            this.myView.setController(null);
        }
        this.myView = view;
        if (this.myView != null) {
            this.myView.setController(this);
        }
    }

    @Override
    public View getView() {
        return this.myView;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.getView() != null) {
            this.getView().setVisible(visible);
        }
    }

    @Override
    public boolean isVisible() {
        if (this.getView() != null) {
            return this.getView().isVisible();
        }
        return false;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        if (this.getView() != null) {
            this.getView().dispose();
        }
        this.doDestroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.myIsDestroyed;
    }

    @Override
    public void viewShownNotify() {
    }

    @Override
    public void viewHiddenNotify() {
    }

    @Override
    public void processGuiEvent(GuiEvent event) {
    }

    @Override
    public void addControllerListener(ControllerListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeControllerListener(ControllerListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public <T> T getModel() {
        return (T)this.myModel;
    }

    @Override
    public <T> void setModel(T model) {
        if (this.myModel instanceof Model) {
            ((Model)this.myModel).removeObserver(this);
        }
        this.myModel = model;
        if (this.myModel instanceof Model) {
            ((Model)this.myModel).addObserver(this);
        }
    }

    @Override
    public void modelUpdated(Model model) {
    }
}

