/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericViewBase
implements View {
    protected Controller myController;
    protected boolean myIsDisposed;
    protected boolean myIsVisible;
    protected Set<GuiListener> myListeners = new HashSet<GuiListener>();

    public GenericViewBase(Controller controller) {
        this.setController(controller);
    }

    protected void fireGuiEvent(GuiEvent event) {
        for (GuiListener listener : this.myListeners) {
            listener.processGuiEvent(event);
        }
    }

    @Override
    public void setController(Controller ctrl) {
        if (ctrl == null) {
            this.removeGuiListener(this.myController);
        } else {
            this.addGuiListener(ctrl);
        }
        this.myController = ctrl;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.myIsVisible == visible) {
            return;
        }
        this.myIsVisible = visible;
        if (this.myController != null) {
            if (visible) {
                this.myController.viewShownNotify();
            } else {
                this.myController.viewHiddenNotify();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.myIsVisible;
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.myIsDisposed = true;
        this.myIsVisible = false;
        this.myListeners.clear();
        this.myController = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.myListeners.remove(listener);
    }
}

