/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc.swing;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.util.ViewUtils;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class JDialogViewBase
extends JDialog
implements View {
    protected Controller myController;
    protected boolean myIsDisposed;
    protected boolean myIsScaledByFontSize;
    protected Set<GuiListener> myListeners;
    protected boolean myDestroyOnClose;
    protected WindowAdapter myWindowAdapter;

    public JDialogViewBase(Controller controller) throws HeadlessException {
        this(controller, (Frame)null, false);
    }

    public JDialogViewBase(Controller controller, Frame owner) throws HeadlessException {
        this(controller, owner, false);
    }

    public JDialogViewBase(Controller controller, Frame owner, boolean modal) throws HeadlessException {
        this(controller, owner, null, modal);
    }

    public JDialogViewBase(Controller controller, Frame owner, String title) throws HeadlessException {
        this(controller, owner, title, false);
    }

    public JDialogViewBase(Controller controller, Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
        this.setController(controller);
    }

    public JDialogViewBase(Controller controller, Frame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init();
        this.setController(controller);
    }

    public JDialogViewBase(Controller controller, Dialog owner) throws HeadlessException {
        this(controller, owner, false);
    }

    public JDialogViewBase(Controller controller, Dialog owner, boolean modal) throws HeadlessException {
        this(controller, owner, null, modal);
    }

    public JDialogViewBase(Controller controller, Dialog owner, String title) throws HeadlessException {
        this(controller, owner, title, false);
    }

    public JDialogViewBase(Controller controller, Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init();
        this.setController(controller);
    }

    public JDialogViewBase(Controller controller, Dialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.init();
        this.setController(controller);
    }

    public JDialogViewBase() {
    }

    protected void init() {
        this.myListeners = new HashSet<GuiListener>();
        this.myDestroyOnClose = true;
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.myWindowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JDialogViewBase.this.handleWindowClosing();
            }
        };
        this.addWindowListener(this.myWindowAdapter);
    }

    protected void handleWindowClosing() {
        if (this.myController != null) {
            if (this.myDestroyOnClose) {
                this.myController.destroy();
            } else {
                this.myController.setVisible(false);
            }
        }
    }

    protected void setDestroyOnClose(boolean destroy) {
        this.myDestroyOnClose = destroy;
    }

    protected void fireGuiEvent(GuiEvent event) {
        for (GuiListener listener : this.myListeners) {
            listener.processGuiEvent(event);
        }
    }

    protected void storeSettings() {
        ViewUtils.storeSettings(this.getClass().getName(), this.getBounds(), this.myIsScaledByFontSize);
    }

    protected void storeSettingsByKeySettings(String keySettings) {
        ViewUtils.storeSettings(keySettings, this.getBounds(), this.myIsScaledByFontSize);
    }

    protected void restoreSettings() {
        if (this.isResizable()) {
            this.restoreLocationAndOriginalSize();
        } else {
            this.restoreLocation();
        }
    }

    protected void restoreLocationAndOriginalSize() {
        this.restoreOriginalSize(this.getClass().getName());
    }

    protected void restoreLocationAndOriginalSize(String keySettings) {
        this.restoreOriginalSize(keySettings);
    }

    private void restoreOriginalSize(String key) {
        this.setBounds(ViewUtils.restoreSettings(key, ViewUtils.getDefaultBounds(this.getSize(), this.getParent()), this.myIsScaledByFontSize));
    }

    protected void restoreLocation() {
        this.restore(this.getClass().getName());
    }

    protected void restoreLocation(String keySettings) {
        this.restore(keySettings);
    }

    private void restore(String key) {
        Rectangle bounds = ViewUtils.restoreSettings(key, ViewUtils.getDefaultBounds(this.getSize(), this.getParent()), this.myIsScaledByFontSize);
        this.setLocation(bounds.x, bounds.y);
    }

    protected void setScaledByFontSize(boolean isScaled) {
        this.myIsScaledByFontSize = isScaled;
    }

    @Override
    public void setController(Controller ctrl) {
        this.removeGuiListener(this.myController);
        if (ctrl != null) {
            this.addGuiListener(ctrl);
        }
        this.myController = ctrl;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setVisible(final boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JDialogViewBase.this.myController != null) {
                    if (visible) {
                        JDialogViewBase.this.myController.viewShownNotify();
                    } else {
                        JDialogViewBase.this.myController.viewHiddenNotify();
                    }
                }
            }
        });
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.storeSettings();
        super.dispose();
        this.myIsDisposed = true;
        this.myDestroyOnClose = true;
        this.myIsScaledByFontSize = false;
        this.myListeners.clear();
        this.removeWindowListener(this.myWindowAdapter);
        this.myController = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.myListeners.remove(listener);
    }
}

