/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc.swing;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.util.ViewUtils;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;

public abstract class JFrameViewBase
extends JFrame
implements View {
    protected Controller myController;
    protected boolean myIsDisposed;
    protected Set<GuiListener> myListeners;
    protected boolean myDestroyOnClose;
    protected WindowAdapter myWindowAdapter;

    public JFrameViewBase(Controller controller, String title, GraphicsConfiguration grfxConfig) {
        super(title, grfxConfig);
        this.init();
        this.setController(controller);
    }

    public JFrameViewBase(Controller controller, String title) {
        super(title);
        this.init();
        this.setController(controller);
    }

    public JFrameViewBase(Controller controller, GraphicsConfiguration grfxConfig) {
        super(grfxConfig);
        this.init();
        this.setController(controller);
    }

    public JFrameViewBase(Controller controller) {
        this.init();
        this.setController(controller);
    }

    protected void init() {
        this.myListeners = new HashSet<GuiListener>();
        this.myDestroyOnClose = true;
        this.setDefaultCloseOperation(0);
        this.myWindowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrameViewBase.this.handleWindowClosing();
            }
        };
        this.addWindowListener(this.myWindowAdapter);
    }

    protected void handleWindowClosing() {
        if (this.myController != null) {
            if (this.myDestroyOnClose) {
                this.myController.destroy();
            } else {
                this.myController.setVisible(false);
            }
        }
    }

    protected void setDestroyOnClose(boolean destroy) {
        this.myDestroyOnClose = destroy;
    }

    protected void fireGuiEvent(GuiEvent event) {
        for (GuiListener listener : this.myListeners) {
            listener.processGuiEvent(event);
        }
    }

    protected void storeSettings() {
        ViewUtils.storeSettings(this.getClass().getName(), this.getBounds());
        ViewUtils.storeExtendedState(this.getClass().getName(), this.getExtendedState());
    }

    protected void restoreSettings() {
        Rectangle defaultBounds = ViewUtils.getDefaultBounds(this.getSize(), this.getParent());
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (defaultBounds.height == 0 && defaultBounds.width == 0) {
            defaultBounds = maxBounds;
        }
        this.setBounds(ViewUtils.restoreSettings(this.getClass().getName(), defaultBounds));
        if (maxBounds.equals(this.getBounds())) {
            this.setExtendedState(6);
        } else {
            this.setExtendedState(ViewUtils.restoreExtendedState(this.getClass().getName(), 0));
        }
    }

    @Override
    public void setController(Controller ctrl) {
        this.removeGuiListener(this.myController);
        if (ctrl != null) {
            this.addGuiListener(ctrl);
        }
        this.myController = ctrl;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
        if (this.myController != null) {
            if (visible) {
                this.myController.viewShownNotify();
            } else {
                this.myController.viewHiddenNotify();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.storeSettings();
        super.dispose();
        this.myIsDisposed = true;
        this.myDestroyOnClose = true;
        this.myListeners.clear();
        this.removeWindowListener(this.myWindowAdapter);
        this.myController = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.myListeners.remove(listener);
    }
}

