/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc.swing;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.ViewUtils;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public abstract class JInternalFrameViewBase
extends JInternalFrame
implements View {
    protected final String IS_ICON = ".is_icon";
    protected final String IS_MAXIMUM = ".is_maximum";
    protected Controller myController;
    protected boolean myIsDisposed;
    protected boolean myDestroyOnClose;
    protected InternalFrameAdapter myInternalFrameAdapter;

    public JInternalFrameViewBase(Controller controller) {
        this(controller, "", false, false, false, false);
    }

    public JInternalFrameViewBase(Controller controller, String title) {
        this(controller, title, false, false, false, false);
    }

    public JInternalFrameViewBase(Controller controller, String title, boolean resizable) {
        this(controller, title, resizable, false, false, false);
    }

    public JInternalFrameViewBase(Controller controller, String title, boolean resizable, boolean closable) {
        this(controller, title, resizable, closable, false, false);
    }

    public JInternalFrameViewBase(Controller controller, String title, boolean resizable, boolean closable, boolean maximizable) {
        this(controller, title, resizable, closable, maximizable, false);
    }

    public JInternalFrameViewBase(Controller controller, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.init();
        this.setController(controller);
    }

    protected void init() {
        this.myDestroyOnClose = true;
        this.setDefaultCloseOperation(0);
        this.myInternalFrameAdapter = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent event) {
                if (JInternalFrameViewBase.this.myController != null) {
                    JInternalFrameViewBase.this.handleWindowClosing();
                }
            }
        };
        this.addInternalFrameListener(this.myInternalFrameAdapter);
    }

    protected void handleWindowClosing() {
        if (this.myController != null) {
            if (this.myDestroyOnClose) {
                this.myController.destroy();
            } else {
                this.myController.setVisible(false);
            }
        }
    }

    protected void setDestroyOnClose(boolean destroy) {
        this.myDestroyOnClose = destroy;
    }

    protected void fireGuiEvent(GuiEvent event) {
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            listener.processGuiEvent(event);
            ++n2;
        }
    }

    protected void storeSettings() {
        ViewUtils.storeSettings(this.getClass().getName(), this.getBounds());
        PSettings settings = PSettings.getInstance();
        settings.set(String.valueOf(this.getClass().getName()) + ".is_icon", this.isIcon());
        settings.set(String.valueOf(this.getClass().getName()) + ".is_maximum", this.isMaximum());
    }

    protected void restoreSettings() {
        this.setBounds(ViewUtils.restoreSettings(this.getClass().getName(), ViewUtils.getDefaultBounds(this.getSize(), this.getParent())));
        try {
            PSettings settings = PSettings.getInstance();
            this.setIcon(settings.get(String.valueOf(this.getClass().getName()) + ".is_icon", false));
            this.setMaximum(settings.get(String.valueOf(this.getClass().getName()) + ".is_maximum", false));
        }
        catch (PropertyVetoException e) {
            Logger.getLogger(this.getClass()).error("Failed to load internal frame state", e);
        }
    }

    @Override
    public void setController(Controller ctrl) {
        this.removeGuiListener(this.myController);
        if (ctrl != null) {
            this.addGuiListener(ctrl);
        }
        this.myController = ctrl;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
        if (this.myController != null) {
            if (visible) {
                this.myController.viewShownNotify();
            } else {
                this.myController.viewHiddenNotify();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.storeSettings();
        super.dispose();
        this.myIsDisposed = true;
        this.myDestroyOnClose = true;
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            this.listenerList.remove(GuiListener.class, listener);
            ++n2;
        }
        this.removeInternalFrameListener(this.myInternalFrameAdapter);
        this.myController = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.listenerList.add(GuiListener.class, listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.listenerList.remove(GuiListener.class, listener);
    }
}

