/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.mvc.swing;

import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.GuiEvent;
import com.nokia.em.poseidon.frameworks.mvc.GuiListener;
import com.nokia.em.poseidon.frameworks.mvc.View;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class JPanelViewBase
extends JPanel
implements View {
    protected Controller myController;
    protected boolean myIsDisposed;

    public JPanelViewBase(Controller controller) {
        this.setController(controller);
    }

    public JPanelViewBase(Controller controller, LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.setController(controller);
    }

    public JPanelViewBase(Controller controller, LayoutManager layout) {
        super(layout);
        this.setController(controller);
    }

    public JPanelViewBase(Controller controller, boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.setController(controller);
    }

    protected void fireGuiEvent(GuiEvent event) {
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            listener.processGuiEvent(event);
            ++n2;
        }
    }

    @Override
    public void setController(Controller ctrl) {
        this.removeGuiListener(this.myController);
        if (ctrl != null) {
            this.addGuiListener(ctrl);
        }
        this.myController = ctrl;
    }

    @Override
    public Controller getController() {
        return this.myController;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
        if (this.myController != null) {
            if (visible) {
                this.myController.viewShownNotify();
            } else {
                this.myController.viewHiddenNotify();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
            parent.validate();
            parent.repaint();
        }
        GuiListener[] guiListenerArray = (GuiListener[])this.listenerList.getListeners(GuiListener.class);
        int n = guiListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            GuiListener listener = guiListenerArray[n2];
            this.listenerList.remove(GuiListener.class, listener);
            ++n2;
        }
        this.myIsDisposed = true;
        this.myController = null;
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    @Override
    public void addGuiListener(GuiListener listener) {
        this.listenerList.add(GuiListener.class, listener);
    }

    @Override
    public void removeGuiListener(GuiListener listener) {
        this.listenerList.remove(GuiListener.class, listener);
    }
}

