/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.print;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.print.PPrintLine;
import com.nokia.em.poseidon.frameworks.print.PPrintText;
import com.nokia.em.poseidon.frameworks.print.PPrintableArea;
import com.nokia.em.poseidon.frameworks.print.PPrintableSection;
import com.nokia.em.poseidon.services.conninfo.BasicConnectionFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import com.nokia.widgets.text.TimeZoneFormatter;
import com.nokia.widgets.text.TimestampFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PPrintHelper {
    private PPrintableSection myDocument;
    private int myExtraLinesAfterHeader = 0;
    private int myExtraLinesBeforeFooter = 0;
    private List<PPrintText> myAdditionalHeaderRows = new ArrayList<PPrintText>();
    private String myAppendedText;
    private String myHeaderText = null;
    private String myFooterText = null;
    private String myCustomHeaderText = null;
    private String myCustomFooterText = null;
    private String myReportNameSuffix;
    private String myStoredTime;
    private ConnectionInfo myConnectioninfo;
    private static ResourceBundle myResourceBundle = I18n.getI18n().getBundle(PPrintHelper.class);
    private String myGeneralFooterText;

    public PPrintHelper(PPrintableSection document) {
        this.myDocument = document;
        this.initialize();
    }

    private void initialize() {
        this.myConnectioninfo = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
        this.myGeneralFooterText = myResourceBundle.getString("PPrintHelper.ReportFooter_Text");
        this.myReportNameSuffix = myResourceBundle.getString("PrintHelper.ReportSuffix_Text");
    }

    public void setCustomHeaderText(String text) {
        this.myCustomHeaderText = text;
    }

    public PPrintableArea createPageHeader() {
        this.myHeaderText = this.myCustomHeaderText != null ? this.myCustomHeaderText : this.getDefaultHeaderText();
        PPrintableArea area = (PPrintableArea)((Object)this.myDocument);
        PPrintText headerPrintText = new PPrintText(this.myHeaderText, area);
        headerPrintText.setAlignment(this.myDocument.getAlignment());
        return this.makeSectionArea(headerPrintText, area);
    }

    private String getDefaultHeaderText() {
        return String.valueOf(this.getReportName()) + " " + this.getReportNameSuffix() + "    " + this.getSiteName() + "    " + this.getCurrentTime() + this.getExtraText();
    }

    public String getDefaultHeaderTextFirstPart() {
        return String.valueOf(this.getReportName()) + " " + this.getReportNameSuffix() + "    " + this.getSiteName();
    }

    public String getDefaultHeaderTextSecondPart() {
        return String.valueOf(this.getCurrentTime()) + " " + this.getExtraText();
    }

    public PPrintableArea createPageHeader(String extraText) {
        this.myAppendedText = extraText;
        return this.createPageHeader();
    }

    public PPrintableArea createPageHeader(int emptyLine) {
        this.myExtraLinesAfterHeader = emptyLine;
        return this.createPageHeader();
    }

    public PPrintableArea createPageHeader(String extraText, int emptyLine) {
        this.myAppendedText = extraText;
        this.myExtraLinesAfterHeader = emptyLine;
        return this.createPageHeader();
    }

    public String getExtraText() {
        return this.myAppendedText == null ? "" : " " + this.myAppendedText;
    }

    public void addHeaderRow(PPrintText text) {
        this.myAdditionalHeaderRows.add(text);
    }

    public void setCustomFooterText(String text) {
        this.myCustomFooterText = text;
    }

    public PPrintableArea createPageFooter() {
        this.myFooterText = this.myCustomFooterText != null ? this.myCustomFooterText : String.valueOf(this.myGeneralFooterText) + " " + this.getReportName() + " " + this.getReportNameSuffix();
        PPrintableArea area = (PPrintableArea)((Object)this.myDocument);
        PPrintText footerPText = new PPrintText(this.myFooterText, area);
        footerPText.setAlignment(this.myDocument.getAlignment());
        return this.makeSectionArea(footerPText, area);
    }

    public PPrintableArea createPageFooter(int emptyLine) {
        this.myExtraLinesBeforeFooter = emptyLine;
        return this.createPageFooter();
    }

    private PPrintableArea makeSectionArea(PPrintText text, PPrintableArea area) {
        PPrintLine line1 = new PPrintLine(0.0, 1.0, 0.0, 0.0, area);
        PPrintLine line2 = new PPrintLine(0.0, 1.0, 0.0, 0.0, area);
        PPrintableArea sectionArea = new PPrintableArea(area);
        this.addEmptyLines(sectionArea, this.myExtraLinesBeforeFooter);
        sectionArea.add(line1);
        if (text.calculatePrintableArea(area)) {
            sectionArea.add(text);
        } else {
            PPrintText firstPart = new PPrintText(this.getDefaultHeaderTextFirstPart(), area);
            firstPart.setAlignment(this.myDocument.getAlignment());
            if (firstPart.calculatePrintableArea(area)) {
                PPrintText secondPart = new PPrintText(this.getDefaultHeaderTextSecondPart(), area);
                secondPart.setAlignment(this.myDocument.getAlignment());
                sectionArea.add(firstPart);
                sectionArea.add(secondPart);
            } else {
                firstPart = new PPrintText(String.valueOf(this.getReportName()) + " " + this.getReportNameSuffix(), area);
                firstPart.setAlignment(this.myDocument.getAlignment());
                PPrintText secondPart = new PPrintText(this.getSiteName(), area);
                secondPart.setAlignment(this.myDocument.getAlignment());
                PPrintText thirdPart = new PPrintText(this.getDefaultHeaderTextSecondPart(), area);
                thirdPart.setAlignment(this.myDocument.getAlignment());
                sectionArea.add(firstPart);
                sectionArea.add(secondPart);
                sectionArea.add(thirdPart);
            }
        }
        this.appendHeaderRows(sectionArea, this.myAdditionalHeaderRows);
        sectionArea.add(line2);
        this.addEmptyLines(sectionArea, this.myExtraLinesAfterHeader);
        return sectionArea;
    }

    private void appendHeaderRows(PPrintableArea area, List<PPrintText> textRows) {
        Iterator<PPrintText> iter = textRows.iterator();
        while (iter.hasNext()) {
            PPrintText row = iter.next();
            area.add(row);
            iter.remove();
        }
    }

    private void addEmptyLines(PPrintableArea area, int emptyLines) {
        int lines = emptyLines;
        while (lines > 0) {
            area.add(new PPrintText(" ", area));
            --lines;
        }
    }

    private String getReportNameSuffix() {
        return this.myReportNameSuffix;
    }

    private String getCurrentTime() {
        Date currentDate = new Date(System.currentTimeMillis());
        this.myStoredTime = String.valueOf(TimestampFormatter.applyLongFormat(currentDate)) + " " + TimeZoneFormatter.formatGMTText(Calendar.getInstance().getTimeZone(), currentDate);
        return this.myStoredTime;
    }

    public String getSiteName() {
        this.myConnectioninfo = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
        ConnectionEvent connEvent = this.myConnectioninfo == null ? null : this.myConnectioninfo.getLatestConnectionEvent(new BasicConnectionFilter(ConnectionStatus.CONNECTED));
        return connEvent == null ? "" : connEvent.getNetworkElementName();
    }

    public String getStoredTime() {
        return this.myStoredTime;
    }

    public String getReportName() {
        String reportName = this.myDocument.getReportName();
        return reportName.replace(" report", "");
    }

    public String getHeaderText() {
        return this.myHeaderText;
    }

    public String getFooterText() {
        return this.myFooterText;
    }
}

